/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.noesis.preview;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerManagerListener;
import com.intellij.platform.lsp.api.LspServerState;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.noesis.lang.service.NoesisLsp4jServer;
import com.jetbrains.rider.noesis.lang.service.NoesisLspServerDescriptor;
import com.jetbrains.rider.noesis.lang.service.NoesisLspXamlRunDiagnosticsParams;
import com.jetbrains.rider.noesis.preview.NoesisPreview;
import com.jetbrains.rider.noesis.preview.NoesisPreviewEditor;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditor;
import com.jetbrains.rider.xaml.splitEditor.XamlSplitEditorOrientation;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/noesis/preview/NoesisLspServerManagerListener;", "Lcom/intellij/platform/lsp/api/LspServerManagerListener;", "preview", "Lcom/jetbrains/rider/noesis/preview/NoesisPreview;", "<init>", "(Lcom/jetbrains/rider/noesis/preview/NoesisPreview;)V", "getPreview", "()Lcom/jetbrains/rider/noesis/preview/NoesisPreview;", "editor", "Lcom/jetbrains/rider/noesis/preview/NoesisPreviewEditor;", "sequentialLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "serverStateChanged", "", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "fileOpened", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "sendNotification", "Lcom/jetbrains/rider/xaml/splitEditor/XamlSplitEditor;", "server", "intellij.rider.plugins.noesis"})
public final class NoesisLspServerManagerListener
implements LspServerManagerListener {
    @NotNull
    private final NoesisPreview preview;
    @NotNull
    private final NoesisPreviewEditor editor;
    @NotNull
    private final SequentialLifetimes sequentialLifetime;

    public NoesisLspServerManagerListener(@NotNull NoesisPreview preview) {
        Intrinsics.checkNotNullParameter((Object)preview, (String)"preview");
        this.preview = preview;
        this.editor = this.preview.getEditor();
        this.sequentialLifetime = new SequentialLifetimes(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.editor)));
    }

    @NotNull
    public final NoesisPreview getPreview() {
        return this.preview;
    }

    public void serverStateChanged(@NotNull LspServer lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        if (!(lspServer.getDescriptor() instanceof NoesisLspServerDescriptor)) {
            return;
        }
        if (lspServer.getState() == LspServerState.ShutdownNormally || lspServer.getState() == LspServerState.ShutdownUnexpectedly) {
            this.preview.cleanupPreview();
        }
    }

    public void fileOpened(@NotNull LspServer lspServer, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(lspServer.getDescriptor() instanceof NoesisLspServerDescriptor)) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.editor.getFile(), (Object)file)) {
            LifetimeDefinition lifetime = this.sequentialLifetime.next();
            this.editor.getParentEditor().getCodeEditor().getEditor().getDocument().addDocumentListener(new DocumentListener(this, lspServer){
                final /* synthetic */ NoesisLspServerManagerListener this$0;
                final /* synthetic */ LspServer $lspServer;
                {
                    this.this$0 = $receiver;
                    this.$lspServer = $lspServer;
                }

                public void documentChanged(DocumentEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    NoesisLspServerManagerListener.access$sendNotification(this.this$0, NoesisLspServerManagerListener.access$getEditor$p(this.this$0).getParentEditor(), this.$lspServer);
                }
            }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)lifetime), null, (int)1, null));
            this.sendNotification(this.editor.getParentEditor(), lspServer);
        }
    }

    private final void sendNotification(XamlSplitEditor editor, LspServer server) {
        JComponent jComponent = editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent editorComponent = jComponent;
        NoesisLspXamlRunDiagnosticsParams params = this.preview.getEditor().getParentEditor().getOrientation() == XamlSplitEditorOrientation.VERTICAL ? new NoesisLspXamlRunDiagnosticsParams(editorComponent.getWidth() / 2, editorComponent.getHeight(), 10) : new NoesisLspXamlRunDiagnosticsParams(editorComponent.getWidth(), editorComponent.getHeight() / 2, 10);
        server.sendNotification(arg_0 -> NoesisLspServerManagerListener.sendNotification$lambda$0(params, arg_0));
    }

    private static final Unit sendNotification$lambda$0(NoesisLspXamlRunDiagnosticsParams $params, LanguageServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((NoesisLsp4jServer)it).runDiagnostics($params);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$sendNotification(NoesisLspServerManagerListener $this, XamlSplitEditor editor, LspServer server) {
        $this.sendNotification(editor, server);
    }

    public static final /* synthetic */ NoesisPreviewEditor access$getEditor$p(NoesisLspServerManagerListener $this) {
        return $this.editor;
    }
}

