/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.toolWindow.log;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unreal.filters.linkInfo.BlueprintClassHyperLinkInfo;
import com.jetbrains.rider.plugins.unreal.filters.linkInfo.MethodReferenceHyperLinkInfo;
import com.jetbrains.rider.plugins.unreal.filters.linkInfo.UnrealClassHyperLinkInfo;
import com.jetbrains.rider.plugins.unreal.model.BlueprintReference;
import com.jetbrains.rider.plugins.unreal.model.FString;
import com.jetbrains.rider.plugins.unreal.model.LogMessageInfo;
import com.jetbrains.rider.plugins.unreal.model.StringRange;
import com.jetbrains.rider.plugins.unreal.model.UClass;
import com.jetbrains.rider.plugins.unreal.model.UnrealLogEvent;
import com.jetbrains.rider.plugins.unreal.model.VerbosityType;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.MethodReference;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.RdRiderModel;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.RdRiderModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogCategoryFilterComboBox;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogConsoleViewContentType;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogFilter;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogPanelSettings;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogSettingsActionGroup;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogVerbosityFilterComboBox;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020!H\u0002J\u001a\u0010%\u001a\u00020!2\b\b\u0002\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020\u0012H\u0002J\u0010\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "tabModel", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "getTabModel", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "settings", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanelSettings;", "logData", "Ljava/util/ArrayDeque;", "Lcom/jetbrains/rider/plugins/unreal/model/UnrealLogEvent;", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "console", "getConsole", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "logFilter", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogFilter;", "verbosityFilterActionGroup", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogVerbosityFilterComboBox;", "categoryFilterActionGroup", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogCategoryFilterComboBox;", "settingsActionGroup", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogSettingsActionGroup;", "clear", "", "print", "unrealLogEvent", "filter", "printSpaces", "n", "", "style", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printInfo", "s", "Lcom/jetbrains/rider/plugins/unreal/model/LogMessageInfo;", "getMessageStyle", "type", "Lcom/jetbrains/rider/plugins/unreal/model/VerbosityType;", "printImpl", "", "addLogDataItem", "item", "Companion", "intellij.rider.plugins.unreal.link"})
@SourceDebugExtension(value={"SMAP\nUnrealLogPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealLogPanel.kt\ncom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1053#2:253\n*S KotlinDebug\n*F\n+ 1 UnrealLogPanel.kt\ncom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel\n*L\n194#1:253\n*E\n"})
public final class UnrealLogPanel
extends SimpleToolWindowPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tabModel;
    @NotNull
    private final Project project;
    @NotNull
    private final UnrealLogPanelSettings settings;
    @NotNull
    private final ArrayDeque<UnrealLogEvent> logData;
    @NotNull
    private final ConsoleViewImpl consoleView;
    @NotNull
    private final UnrealLogFilter logFilter;
    @NotNull
    private final UnrealLogVerbosityFilterComboBox verbosityFilterActionGroup;
    @NotNull
    private final UnrealLogCategoryFilterComboBox categoryFilterActionGroup;
    @NotNull
    private final UnrealLogSettingsActionGroup settingsActionGroup;
    private static final int MAX_STORED_LOG_DATA_ITEMS = 32768;
    private static final int TIME_WIDTH = 29;
    private static final int VERBOSITY_WIDTH = 12;

    public UnrealLogPanel(@NotNull String tabModel, @NotNull Lifetime lifetime, @NotNull Project project) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false);
        this.tabModel = tabModel;
        this.project = project;
        this.settings = UnrealLogPanelSettings.Companion.getInstance(this.project);
        this.logData = new ArrayDeque();
        this.consoleView = UnrealLogPanel.Companion.createConsole(this.project, lifetime);
        this.logFilter = new UnrealLogFilter(lifetime, this.settings);
        this.verbosityFilterActionGroup = new UnrealLogVerbosityFilterComboBox(this.settings);
        this.categoryFilterActionGroup = new UnrealLogCategoryFilterComboBox(this.settings, this.logFilter);
        this.settingsActionGroup = new UnrealLogSettingsActionGroup(this.settings);
        this.setContent((JComponent)this.consoleView);
        DefaultActionGroup $this$_init__u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$_init__u24lambda_u240.addAll((Collection)ArraysKt.toList((Object[])this.consoleView.createConsoleActions()));
        DefaultActionGroup actionGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup, this.myVertical);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        DefaultActionGroup $this$_init__u24lambda_u241 = bl = new DefaultActionGroup();
        boolean bl2 = false;
        $this$_init__u24lambda_u241.add((AnAction)this.verbosityFilterActionGroup);
        $this$_init__u24lambda_u241.add((AnAction)this.categoryFilterActionGroup);
        $this$_init__u24lambda_u241.add((AnAction)this.settingsActionGroup);
        DefaultActionGroup topGroup = bl;
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)topGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar topToolbar = actionToolbar2;
        JPanel topPanel = new JPanel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        topToolbar.setTargetComponent((JComponent)topPanel);
        topPanel.add(topToolbar.getComponent());
        this.consoleView.scrollTo(0);
        this.consoleView.add((Component)topPanel, (Object)"North");
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
        this.logFilter.addFilterChangedListener((Function0<Unit>)((Function0)() -> UnrealLogPanel._init_$lambda$2(this)));
        RdRiderModel model = RdRiderModel_PregeneratedKt.getRdRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project));
        model.isConnectedToUnrealEditor().advise(lifetime, arg_0 -> UnrealLogPanel._init_$lambda$3(this, arg_0));
        model.getUnrealLog().advise(lifetime, arg_0 -> UnrealLogPanel._init_$lambda$4(this, arg_0));
    }

    @NotNull
    public final String getTabModel() {
        return this.tabModel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ConsoleViewImpl getConsole() {
        return this.consoleView;
    }

    public final void clear() {
        this.logData.clear();
        this.consoleView.clear();
    }

    private final void print(UnrealLogEvent unrealLogEvent) {
        this.addLogDataItem(unrealLogEvent);
        this.printImpl(unrealLogEvent);
    }

    private final void filter() {
        Editor editor = this.consoleView.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        int currentScroll = editor.getScrollingModel().getVerticalScrollOffset();
        this.consoleView.clear();
        ActionsKt.invokeLater$default(null, () -> UnrealLogPanel.filter$lambda$5(this, currentScroll), (int)1, null);
    }

    private final void printSpaces(int n, ConsoleViewContentType style) {
        if (n <= 0) {
            return;
        }
        this.consoleView.print(StringsKt.repeat((CharSequence)" ", (int)n), style);
    }

    static /* synthetic */ void printSpaces$default(UnrealLogPanel unrealLogPanel, int n, ConsoleViewContentType consoleViewContentType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        unrealLogPanel.printSpaces(n, consoleViewContentType);
    }

    private final void printInfo(LogMessageInfo s, ConsoleViewContentType style) {
        if (this.settings.getShowTimestamps()) {
            String timeString;
            Date date = s.getTime();
            String string = timeString = date != null ? date.toString() : null;
            if (timeString != null) {
                this.consoleView.print(timeString, style);
                this.printSpaces(30 - timeString.length(), style);
            } else {
                this.printSpaces(30, style);
            }
        }
        if (this.settings.getAlignMessages()) {
            if (this.settings.getShowVerbosity()) {
                verbosityString = s.getType().toString();
                this.consoleView.print(verbosityString, style);
                this.printSpaces(12 - verbosityString.length() + 1, style);
            }
            String category = s.getCategory().getData();
            this.consoleView.print(category, style);
            this.printSpaces(this.settings.getCategoryWidth() - category.length(), style);
            this.printSpaces(1, style);
        } else {
            if (this.settings.getShowVerbosity()) {
                verbosityString = s.getType().toString();
                this.consoleView.print(verbosityString, style);
                this.consoleView.print(": ", style);
            }
            this.consoleView.print(s.getCategory().getData(), style);
            this.consoleView.print(": ", style);
        }
    }

    private final ConsoleViewContentType getMessageStyle(VerbosityType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_FATAL();
            case 2 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_ERROR();
            case 3 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_WARNING();
            case 4 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_DISPLAY();
            case 5 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_LOG();
            case 6 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_VERBOSE();
            case 7 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_VERY_VERBOSE();
            default -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_LOG();
        };
    }

    private final boolean printImpl(UnrealLogEvent unrealLogEvent) {
        this.logFilter.addCategory(unrealLogEvent.getInfo().getCategory().getData());
        if (!this.logFilter.isMessageAllowed(unrealLogEvent.getInfo())) {
            return false;
        }
        ConsoleViewContentType style = this.getMessageStyle(unrealLogEvent.getInfo().getType());
        this.printInfo(unrealLogEvent.getInfo(), style);
        if (unrealLogEvent.getBpPathRanges().isEmpty() && unrealLogEvent.getMethodRanges().isEmpty()) {
            ConsoleViewImpl $this$printImpl_u24lambda_u246 = this.consoleView;
            boolean bl = false;
            $this$printImpl_u24lambda_u246.print(unrealLogEvent.getText().getData(), style);
            this.consoleView.print(PlatformDependentKt.getEol(), style);
            return true;
        }
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)unrealLogEvent.getBpPathRanges(), (Iterable)unrealLogEvent.getMethodRanges());
        boolean $i$f$sortedBy2 = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StringRange it = (StringRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFirst());
                it = (StringRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
            }
        });
        boolean bl = $this$sortedBy$iv = !((Collection)sortedRanges).isEmpty();
        if (_Assertions.ENABLED && !$this$sortedBy$iv) {
            String $i$f$sortedBy2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$sortedBy2);
        }
        ArrayList<StringRange> allRanges = new ArrayList<StringRange>();
        StringRange lastAddedRange = (StringRange)sortedRanges.get(0);
        allRanges.add(lastAddedRange);
        int n = sortedRanges.size();
        for (int index = 1; index < n; ++index) {
            StringRange curRange = (StringRange)sortedRanges.get(index);
            if (lastAddedRange.getLast() > curRange.getFirst()) continue;
            allRanges.add(curRange);
            lastAddedRange = curRange;
        }
        String line = unrealLogEvent.getText().getData();
        if (((StringRange)CollectionsKt.first((List)allRanges)).getFirst() > 0) {
            String string = line.substring(0, ((StringRange)allRanges.get(0)).getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.consoleView.print(string, style);
        }
        RdRiderModel model = RdRiderModel_PregeneratedKt.getRdRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project));
        for (IndexedValue rangeWithIndex : CollectionsKt.withIndex((Iterable)allRanges)) {
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(((StringRange)rangeWithIndex.getValue()).getFirst(), ((StringRange)rangeWithIndex.getValue()).getLast()), (String)"substring(...)");
            if (unrealLogEvent.getBpPathRanges().contains(rangeWithIndex.getValue())) {
                BlueprintClassHyperLinkInfo hyperLinkInfo = new BlueprintClassHyperLinkInfo(model.getOpenBlueprint(), new BlueprintReference(new FString(match), new FString("")));
                this.consoleView.printHyperlink(match, (HyperlinkInfo)hyperLinkInfo);
            } else {
                String[] stringArray = new String[]{"::"};
                List list = StringsKt.split$default((CharSequence)match, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String string = (String)list.get(0);
                String method = (String)list.get(1);
                MethodReference methodReference = new MethodReference(new UClass(new FString(string)), new FString(method));
                UnrealClassHyperLinkInfo classHyperLinkInfo = new UnrealClassHyperLinkInfo(model, methodReference, new UClass(new FString(string)));
                this.consoleView.printHyperlink(string, (HyperlinkInfo)classHyperLinkInfo);
                this.consoleView.print("::", style);
                MethodReferenceHyperLinkInfo methodHyperLinkInfo = new MethodReferenceHyperLinkInfo(model, methodReference);
                this.consoleView.printHyperlink(method, (HyperlinkInfo)methodHyperLinkInfo);
            }
            if (rangeWithIndex.getIndex() >= allRanges.size() - 1 || ((StringRange)allRanges.get(rangeWithIndex.getIndex() + 1)).getFirst() == ((StringRange)rangeWithIndex.getValue()).getLast()) continue;
            String string = line.substring(((StringRange)rangeWithIndex.getValue()).getLast(), ((StringRange)allRanges.get(rangeWithIndex.getIndex() + 1)).getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.consoleView.print(string, style);
        }
        if (((StringRange)CollectionsKt.last((List)allRanges)).getLast() < line.length()) {
            String string = line.substring(((StringRange)CollectionsKt.last((List)allRanges)).getLast());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.consoleView.print(string, style);
        }
        this.consoleView.print(PlatformDependentKt.getEol(), style);
        return true;
    }

    private final void addLogDataItem(UnrealLogEvent item) {
        while (this.logData.size() >= 32768) {
            this.logData.removeFirst();
        }
        this.logData.add(item);
    }

    private static final Unit _init_$lambda$2(UnrealLogPanel this$0) {
        this$0.filter();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(UnrealLogPanel this$0, boolean it) {
        if (it && this$0.settings.getClearOnStart()) {
            this$0.clear();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(UnrealLogPanel this$0, UnrealLogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.print(event);
        return Unit.INSTANCE;
    }

    private static final Unit filter$lambda$5(UnrealLogPanel this$0, int $currentScroll) {
        Iterator<UnrealLogEvent> iterator = this$0.logData.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<UnrealLogEvent> iterator2 = iterator;
        while (iterator2.hasNext()) {
            UnrealLogEvent logEvent = iterator2.next();
            Intrinsics.checkNotNull((Object)logEvent);
            this$0.printImpl(logEvent);
        }
        Editor editor = this$0.consoleView.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        editor.getScrollingModel().scrollVertically($currentScroll);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel$Companion;", "", "<init>", "()V", "MAX_STORED_LOG_DATA_ITEMS", "", "TIME_WIDTH", "VERBOSITY_WIDTH", "createConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.plugins.unreal.link"})
    public static final class Companion {
        private Companion() {
        }

        private final ConsoleViewImpl createConsole(Project project, Lifetime lifetime) {
            ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
            ConsoleViewImpl consoleView2 = (ConsoleViewImpl)consoleView;
            lifetime.bracketIfAlive(() -> Companion.createConsole$lambda$0(consoleView2), () -> Companion.createConsole$lambda$1(consoleView2));
            return consoleView2;
        }

        private static final JComponent createConsole$lambda$0(ConsoleViewImpl $consoleView) {
            return $consoleView.getComponent();
        }

        private static final Unit createConsole$lambda$1(ConsoleViewImpl $consoleView) {
            $consoleView.dispose();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VerbosityType.values().length];
            try {
                nArray[VerbosityType.Fatal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Display.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Log.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Verbose.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.VeryVerbose.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

