/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.rider.cpp.debugger.RiderCppDebugProcess;
import com.jetbrains.rider.cpp.debugger.RiderCppDebugProcessExtension;
import com.jetbrains.rider.plugins.unreal.UnrealHost;
import com.jetbrains.rider.plugins.unreal.debugger.BlueprintExecutionStack;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/plugins/unreal/debugger/UnrealDebugProcessExtension;", "Lcom/jetbrains/rider/cpp/debugger/RiderCppDebugProcessExtension;", "<init>", "()V", "mySupportModuleIsAvailableKey", "Lcom/intellij/openapi/util/Key;", "", "myIsUnrealHostKey", "getExecutionStack", "Lcom/jetbrains/cidr/execution/debugger/CidrExecutionStack;", "process", "Lcom/jetbrains/rider/cpp/debugger/RiderCppDebugProcess;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "current", "cause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "returnValue", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "handleModulesLoaded", "", "debugProcess", "changedModules", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "handleModulesUnloaded", "containsRiderDebuggerSupportModule", "modules", "initIsUnrealHost", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "intellij.rider.plugins.unreal.link"})
@SourceDebugExtension(value={"SMAP\nUnrealDebugProcessExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealDebugProcessExtension.kt\ncom/jetbrains/rider/plugins/unreal/debugger/UnrealDebugProcessExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1755#2,3:66\n*S KotlinDebug\n*F\n+ 1 UnrealDebugProcessExtension.kt\ncom/jetbrains/rider/plugins/unreal/debugger/UnrealDebugProcessExtension\n*L\n52#1:66,3\n*E\n"})
public final class UnrealDebugProcessExtension
implements RiderCppDebugProcessExtension {
    @NotNull
    private final Key<Boolean> mySupportModuleIsAvailableKey = new Key("riderDebuggingSupportModuleIsAvailable");
    @NotNull
    private final Key<Boolean> myIsUnrealHostKey = new Key("riderIsUnrealHost");

    @Nullable
    public CidrExecutionStack getExecutionStack(@NotNull RiderCppDebugProcess process, @NotNull LLThread thread, @Nullable LLFrame frame, boolean current, @Nullable CidrSuspensionCause cause, @Nullable LLValue returnValue) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.initIsUnrealHost((CidrDebugProcess)process);
        Object object = process.getUserData(this.myIsUnrealHostKey);
        Intrinsics.checkNotNull((Object)object);
        if (!((Boolean)object).booleanValue()) {
            return null;
        }
        Boolean bl = (Boolean)process.getUserData(this.mySupportModuleIsAvailableKey);
        boolean isSupportModuleAvailable = bl != null ? bl : false;
        return new BlueprintExecutionStack((CidrDebugProcess)process, thread, frame, current, cause, returnValue, isSupportModuleAvailable);
    }

    public void handleModulesLoaded(@NotNull RiderCppDebugProcess debugProcess, @NotNull List<LLModule> changedModules) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter(changedModules, (String)"changedModules");
        Boolean it = (Boolean)debugProcess.getUserData(this.mySupportModuleIsAvailableKey);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)true)) {
            return;
        }
        if (!this.containsRiderDebuggerSupportModule(changedModules)) {
            return;
        }
        debugProcess.putUserData(this.mySupportModuleIsAvailableKey, (Object)true);
    }

    public void handleModulesUnloaded(@NotNull RiderCppDebugProcess debugProcess, @NotNull List<LLModule> changedModules) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter(changedModules, (String)"changedModules");
        Boolean it = (Boolean)debugProcess.getUserData(this.mySupportModuleIsAvailableKey);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it, (Object)true)) {
            return;
        }
        if (!this.containsRiderDebuggerSupportModule(changedModules)) {
            return;
        }
        debugProcess.putUserData(this.mySupportModuleIsAvailableKey, (Object)false);
    }

    private final boolean containsRiderDebuggerSupportModule(List<LLModule> modules) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = modules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LLModule it = (LLModule)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)it.getPath(), (CharSequence)"RiderDebuggerSupport", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void initIsUnrealHost(CidrDebugProcess debugProcess) {
        Boolean it = (Boolean)debugProcess.getUserData(this.myIsUnrealHostKey);
        boolean bl = false;
        if (it != null) {
            return;
        }
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        Project project2 = project;
        UnrealHost host = UnrealHost.Companion.getInstance(project2);
        debugProcess.putUserData(this.myIsUnrealHostKey, (Object)host.isUnrealEngineSolution());
    }
}

