/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.debugger;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.UnrealModel_PregeneratedKt;
import com.jetbrains.rider.UnrealLinkBundle;
import com.jetbrains.rider.plugins.unreal.UnrealPluginUsagesCollector;
import com.jetbrains.rider.plugins.unreal.debugger.BlueprintCallstackFrameCompatibilityMatcher;
import com.jetbrains.rider.plugins.unreal.debugger.UnrealDebuggerLogger;
import com.jetbrains.rider.plugins.unreal.debugger.frames.BlueprintFrame;
import com.jetbrains.rider.plugins.unreal.debugger.frames.StubBlueprintFrame;
import com.jetbrains.rider.plugins.unreal.debugger.frames.UnrealExternalCodeFrame;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogPanelSettings;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 E2\u00020\u0001:\u0002EFB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\u001eJ\b\u0010$\u001a\u00020\u001eH\u0002J$\u0010%\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'0&2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'J0\u0010)\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'0&2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0002J \u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'H\u0002J(\u0010,\u001a\u00020\u001e2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00142\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0001H\u0002J\u0012\u00100\u001a\u00020\t2\b\u00101\u001a\u0004\u0018\u00010\u000eH\u0002J \u00102\u001a\b\u0012\u0004\u0012\u0002030&2\u0006\u00101\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0002J \u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'H\u0002J \u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00142\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'H\u0002J0\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'0&2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'2\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0002J \u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00142\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'H\u0002J>\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\u00072\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010>\u001a\u00020\u00072\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0014H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010@\u001a\u00020\u0017H\u0002J\u0018\u0010A\u001a\u00020\t2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0'H\u0002J\b\u0010B\u001a\u00020\tH\u0002J\b\u0010C\u001a\u00020\tH\u0002J\b\u0010D\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/jetbrains/rider/plugins/unreal/debugger/BlueprintStackTransformer;", "", "<init>", "()V", "myOverallTransformActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "myBatchNumber", "", "myRiderModuleIsAvailable", "", "Ljava/lang/Boolean;", "myProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "myPreviousFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "myObsolescent", "Lcom/intellij/xdebugger/Obsolescent;", "myProject", "Lcom/intellij/openapi/project/Project;", "myCachedBlueprintCallstack", "", "Lcom/jetbrains/rider/plugins/unreal/debugger/BlueprintStackTransformer$BlueprintCallFrame;", "myCachedErrorForBlueprintCallstack", "", "myTopFrame", "myUnrealEngineLocation", "myLastCollapsedFrame", "Lcom/jetbrains/rider/plugins/unreal/debugger/frames/UnrealExternalCodeFrame;", "myInstanceNumber", "beginTransformation", "", "obsolescent", "project", "process", "isSupportModuleAvailable", "endTransformation", "propertyInitializedInvariant", "transform", "Ljava/util/concurrent/CompletableFuture;", "", "stackFrames", "transformInternalAsync", "transformActivity", "collapseExternalCodeFrames", "updateOrAddCollapsedFrame", "frames", "newCollapsedCount", "equalityObject", "shouldFrameBeCollapsed", "frame", "initializeBlueprintDataForStack", "Ljava/lang/Void;", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "parentActivity", "processStackFramesSynchronously", "addBlueprintFramesToStack", "injectBlueprintFunctions", "addBlueprintStubFramesToStack", "createBlueprintFrame", "frameEqualityObject", "bpIndex", "decodeBlueprintCallFrames", "frameIndex", "result", "input", "isProcessingNeeds", "isBlueprintCallstackEnabled", "isShowUnrealFramesEnabled", "isSupportedPlatform", "Companion", "BlueprintCallFrame", "intellij.rider.plugins.unreal.link"})
@SourceDebugExtension(value={"SMAP\nBlueprintStackTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlueprintStackTransformer.kt\ncom/jetbrains/rider/plugins/unreal/debugger/BlueprintStackTransformer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,395:1\n62#2,5:396\n62#2,5:401\n62#2,5:406\n295#3,2:411\n1872#3,3:413\n1317#4,2:416\n*S KotlinDebug\n*F\n+ 1 BlueprintStackTransformer.kt\ncom/jetbrains/rider/plugins/unreal/debugger/BlueprintStackTransformer\n*L\n47#1:396,5\n81#1:401,5\n92#1:406,5\n288#1:411,2\n299#1:413,3\n347#1:416,2\n*E\n"})
public final class BlueprintStackTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private StructuredIdeActivity myOverallTransformActivity;
    private int myBatchNumber;
    @Nullable
    private Boolean myRiderModuleIsAvailable;
    @Nullable
    private CidrDebugProcess myProcess;
    @Nullable
    private XStackFrame myPreviousFrame;
    @Nullable
    private Obsolescent myObsolescent;
    @Nullable
    private Project myProject;
    @Nullable
    private List<BlueprintCallFrame> myCachedBlueprintCallstack;
    @NlsSafe
    @Nullable
    private String myCachedErrorForBlueprintCallstack;
    @Nullable
    private XStackFrame myTopFrame;
    @Nullable
    private String myUnrealEngineLocation;
    @Nullable
    private UnrealExternalCodeFrame myLastCollapsedFrame;
    private final int myInstanceNumber = myInstanceCounter.incrementAndGet();
    @NotNull
    private static final AtomicInteger myInstanceCounter = new AtomicInteger(0);

    public final void beginTransformation(@NotNull Obsolescent obsolescent, @NotNull Project project, @NotNull CidrDebugProcess process, boolean isSupportModuleAvailable) {
        Intrinsics.checkNotNullParameter((Object)obsolescent, (String)"obsolescent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Logger $this$debug_u24default$iv = UnrealDebuggerLogger.Companion.getLogger();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Begin transformation of blueprint stack frames. Project: " + project.getName() + " process: " + process.getRunParameters() + " isSupportModuleAvailable: " + isSupportModuleAvailable + " myInstanceNumber: " + this.myInstanceNumber, e$iv);
        }
        this.myPreviousFrame = null;
        this.myCachedBlueprintCallstack = null;
        this.myCachedErrorForBlueprintCallstack = null;
        this.myTopFrame = null;
        this.myRiderModuleIsAvailable = isSupportModuleAvailable;
        this.myLastCollapsedFrame = null;
        this.myObsolescent = obsolescent;
        this.myProject = project;
        this.myProcess = process;
        this.myUnrealEngineLocation = (String)UnrealModel_PregeneratedKt.getUnrealModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getUnrealEngineLocation().getValueOrNull();
        if (this.myUnrealEngineLocation == null) {
            UnrealDebuggerLogger.Companion.getLogger().warn("Unreal Engine location is not set, project: " + project.getName());
        }
        this.propertyInitializedInvariant();
        this.myBatchNumber = 0;
        this.myOverallTransformActivity = UnrealPluginUsagesCollector.startBlueprintStackTransformActivity(project, this.isSupportedPlatform(), isSupportModuleAvailable, this.isBlueprintCallstackEnabled(), this.isShowUnrealFramesEnabled());
    }

    public final void endTransformation() {
        block1: {
            Logger $this$debug_u24default$iv = UnrealDebuggerLogger.Companion.getLogger();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("End transformation of blueprint stack frames. myInstanceNumber: " + this.myInstanceNumber, e$iv);
            }
            StructuredIdeActivity structuredIdeActivity = this.myOverallTransformActivity;
            if (structuredIdeActivity == null) break block1;
            StructuredIdeActivity.finished$default((StructuredIdeActivity)structuredIdeActivity, null, (int)1, null);
        }
    }

    private final void propertyInitializedInvariant() {
        boolean bl;
        boolean bl2 = bl = this.myProject != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = this.myProcess != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = this.myObsolescent != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final CompletableFuture<List<XStackFrame>> transform(@NotNull List<? extends XStackFrame> stackFrames) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        Logger $this$debug_u24default$iv22 = UnrealDebuggerLogger.Companion.getLogger();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv22.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv22;
            boolean bl = false;
            logger.debug("Transforming blueprint stack frames. myInstanceNumber: " + this.myInstanceNumber + " stackFrames: " + stackFrames.size(), e$iv);
        }
        int $this$debug_u24default$iv22 = this.myBatchNumber;
        this.myBatchNumber = $this$debug_u24default$iv22 + 1;
        StructuredIdeActivity transformActivity = UnrealPluginUsagesCollector.startBlueprintStackTransformBatchActivity(this.myProject, this.myOverallTransformActivity, this.myBatchNumber, stackFrames.size());
        CompletionStage completionStage = this.transformInternalAsync(stackFrames, transformActivity).handle((arg_0, arg_1) -> BlueprintStackTransformer.transform$lambda$4((arg_0, arg_1) -> BlueprintStackTransformer.transform$lambda$3(transformActivity, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"handle(...)");
        return completionStage;
    }

    private final CompletableFuture<List<XStackFrame>> transformInternalAsync(List<? extends XStackFrame> stackFrames, StructuredIdeActivity transformActivity) {
        if (!this.isSupportedPlatform()) {
            CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(stackFrames);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        if (this.myProject == null || !this.isBlueprintCallstackEnabled() && this.isShowUnrealFramesEnabled()) {
            CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(stackFrames);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        this.propertyInitializedInvariant();
        if (this.myTopFrame == null) {
            this.myTopFrame = (XStackFrame)CollectionsKt.firstOrNull(stackFrames);
        }
        CompletableFuture<List<XStackFrame>> stackWithInjectedBlueprint = this.injectBlueprintFunctions(stackFrames, transformActivity);
        CompletionStage completionStage = stackWithInjectedBlueprint.thenApply(arg_0 -> BlueprintStackTransformer.transformInternalAsync$lambda$5((Function1)new Function1<List<? extends XStackFrame>, List<? extends XStackFrame>>((Object)this){

            public final List<XStackFrame> invoke(List<? extends XStackFrame> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return BlueprintStackTransformer.access$collapseExternalCodeFrames((BlueprintStackTransformer)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final List<XStackFrame> collapseExternalCodeFrames(List<? extends XStackFrame> stackFrames) {
        if (this.isShowUnrealFramesEnabled() || this.myUnrealEngineLocation == null) {
            return stackFrames;
        }
        List frames = new ArrayList();
        int exCodeFramesCount = 0;
        int index = 0;
        Object equalityObject = null;
        for (XStackFrame frame : stackFrames) {
            ++index;
            if (this.shouldFrameBeCollapsed(frame)) {
                ++exCodeFramesCount;
                XStackFrame xStackFrame = frame;
                equalityObject = xStackFrame != null ? xStackFrame.getEqualityObject() : null;
                continue;
            }
            if (exCodeFramesCount > 0) {
                Object object = equalityObject;
                if (object == null) {
                    object = index;
                }
                this.updateOrAddCollapsedFrame(frames, exCodeFramesCount, object);
                exCodeFramesCount = 0;
                equalityObject = null;
            }
            frames.add(frame);
            this.myLastCollapsedFrame = null;
        }
        ++index;
        if (exCodeFramesCount > 0) {
            Object object = equalityObject;
            if (object == null) {
                object = index;
            }
            this.updateOrAddCollapsedFrame(frames, exCodeFramesCount, object);
        }
        return frames;
    }

    private final void updateOrAddCollapsedFrame(List<XStackFrame> frames, int newCollapsedCount, Object equalityObject) {
        if (this.myLastCollapsedFrame != null) {
            UnrealExternalCodeFrame unrealExternalCodeFrame = this.myLastCollapsedFrame;
            Intrinsics.checkNotNull((Object)((Object)unrealExternalCodeFrame));
            UnrealExternalCodeFrame unrealExternalCodeFrame2 = unrealExternalCodeFrame;
            unrealExternalCodeFrame2.setCollapsedFramesCount(unrealExternalCodeFrame2.getCollapsedFramesCount() + newCollapsedCount);
        } else {
            UnrealExternalCodeFrame newCollapsedFrame = new UnrealExternalCodeFrame(equalityObject, newCollapsedCount);
            frames.add(newCollapsedFrame);
            this.myLastCollapsedFrame = newCollapsedFrame;
        }
    }

    private final boolean shouldFrameBeCollapsed(XStackFrame frame) {
        boolean bl;
        if (Intrinsics.areEqual((Object)frame, (Object)this.myTopFrame)) {
            return false;
        }
        if (!(frame instanceof CidrStackFrame)) {
            return false;
        }
        Object object = ((CidrStackFrame)frame).getSourcePosition();
        if (object != null && (object = object.getFile()) != null && (object = object.getPath()) != null) {
            String string = this.myUnrealEngineLocation;
            Intrinsics.checkNotNull((Object)string);
            bl = StringsKt.startsWith((String)object, (String)string, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    private final CompletableFuture<Void> initializeBlueprintDataForStack(CidrStackFrame frame, StructuredIdeActivity parentActivity) {
        CompletableFuture completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        CompletableFuture featureResult = completableFuture;
        if (Intrinsics.areEqual((Object)this.myRiderModuleIsAvailable, (Object)false)) {
            this.myCachedErrorForBlueprintCallstack = UnrealLinkBundle.message("RiderLink.Unreal.Debugger.BlueprintCallstack.Blueprint.StubFrame.InstallRiderLink", new Object[0]);
            return featureResult;
        }
        if (this.myCachedBlueprintCallstack != null) {
            return featureResult;
        }
        if (this.myCachedErrorForBlueprintCallstack != null) {
            return featureResult;
        }
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        Intrinsics.checkNotNull((Object)cidrDebugProcess);
        featureResult = cidrDebugProcess.postCommand(arg_0 -> BlueprintStackTransformer.initializeBlueprintDataForStack$lambda$6(this, parentActivity, frame, arg_0));
        return featureResult;
    }

    private final List<XStackFrame> processStackFramesSynchronously(List<? extends XStackFrame> stackFrames) {
        if (this.myCachedBlueprintCallstack != null) {
            return this.addBlueprintFramesToStack(stackFrames);
        }
        return this.addBlueprintStubFramesToStack(stackFrames);
    }

    private final List<XStackFrame> addBlueprintFramesToStack(List<? extends XStackFrame> stackFrames) {
        List result = new ArrayList();
        int bpIndex = 0;
        for (XStackFrame xStackFrame : stackFrames) {
            if (!(xStackFrame instanceof CidrStackFrame)) {
                result.add(xStackFrame);
                continue;
            }
            Object object = ((CidrStackFrame)xStackFrame).getEqualityObject();
            Intrinsics.checkNotNull((Object)object);
            List<BlueprintCallFrame> list = this.myCachedBlueprintCallstack;
            Intrinsics.checkNotNull(list);
            bpIndex = this.createBlueprintFrame(object, bpIndex, list, ((CidrStackFrame)xStackFrame).getFrameIndex(), result);
            result.add(xStackFrame);
        }
        return result;
    }

    private final CompletableFuture<List<XStackFrame>> injectBlueprintFunctions(List<? extends XStackFrame> stackFrames, StructuredIdeActivity parentActivity) {
        Object v6;
        block6: {
            boolean bl;
            if (this.myProject == null || !this.isBlueprintCallstackEnabled()) {
                CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(stackFrames);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
            Obsolescent obsolescent = this.myObsolescent;
            boolean bl2 = obsolescent != null ? obsolescent.isObsolete() : false;
            if (bl2) {
                CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(stackFrames);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
            if (!this.isProcessingNeeds(stackFrames)) {
                this.myPreviousFrame = (XStackFrame)CollectionsKt.lastOrNull(stackFrames);
                CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(stackFrames);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
            boolean bl3 = bl = !((Collection)stackFrames).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Iterable $this$firstOrNull$iv = stackFrames;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XStackFrame it = (XStackFrame)element$iv;
                boolean bl4 = false;
                if (!(it instanceof CidrStackFrame)) continue;
                v6 = element$iv;
                break block6;
            }
            v6 = null;
        }
        Object var5_12 = v6;
        CidrStackFrame cidrStackFrame = var5_12 instanceof CidrStackFrame ? (CidrStackFrame)var5_12 : null;
        if (cidrStackFrame == null) {
            CompletableFuture<List<XStackFrame>> completableFuture = CompletableFuture.completedFuture(stackFrames);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CidrStackFrame firstFrame = cidrStackFrame;
        CompletionStage completionStage = this.initializeBlueprintDataForStack(firstFrame, parentActivity).thenApply(arg_0 -> BlueprintStackTransformer.injectBlueprintFunctions$lambda$9(arg_0 -> BlueprintStackTransformer.injectBlueprintFunctions$lambda$8(this, stackFrames, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    private final List<XStackFrame> addBlueprintStubFramesToStack(List<? extends XStackFrame> stackFrames) {
        boolean bl;
        boolean bl2 = bl = this.myCachedErrorForBlueprintCallstack != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List resultWithStubs = new ArrayList();
        Iterable $this$forEachIndexed$iv = stackFrames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            XStackFrame previousCidrFrame;
            void currentFrame;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            XStackFrame xStackFrame = (XStackFrame)item$iv;
            int index = n;
            boolean bl3 = false;
            boolean found = false;
            if (currentFrame instanceof CidrStackFrame && index > 0 && BlueprintCallstackFrameCompatibilityMatcher.Companion.matchFrames((XStackFrame)currentFrame, previousCidrFrame = stackFrames.get(index - 1)).isMatched()) {
                found = true;
            }
            resultWithStubs.add(currentFrame);
            if (!found) continue;
            void v1 = currentFrame;
            Intrinsics.checkNotNull((Object)v1);
            Object object = v1.getEqualityObject();
            Intrinsics.checkNotNull((Object)object);
            String string = this.myCachedErrorForBlueprintCallstack;
            Intrinsics.checkNotNull((Object)string);
            StubBlueprintFrame stubFrame = new StubBlueprintFrame(object, string);
            resultWithStubs.add(stubFrame);
        }
        return resultWithStubs;
    }

    private final int createBlueprintFrame(Object frameEqualityObject, int bpIndex, List<BlueprintCallFrame> decodeBlueprintCallFrames, int frameIndex, List<XStackFrame> result) {
        String ubergraphConst;
        int bpIndexLocal = bpIndex;
        if (bpIndexLocal >= decodeBlueprintCallFrames.size()) {
            return bpIndexLocal;
        }
        BlueprintCallFrame bpFrame = decodeBlueprintCallFrames.get(bpIndexLocal);
        if (frameIndex != bpFrame.getOriginalFrameIndex()) {
            return bpIndexLocal;
        }
        String functionFullName = bpFrame.getFunctionFullName();
        if (StringsKt.contains$default((CharSequence)functionFullName, (CharSequence)((ubergraphConst = "ExecuteUbergraph") + "_" + bpFrame.getObjectName()), (boolean)false, (int)2, null)) {
            functionFullName = "Event Graph";
        }
        result.add(new BlueprintFrame(frameEqualityObject, bpFrame.getObjectName(), bpFrame.getFunctionDisplayName(), functionFullName));
        return ++bpIndexLocal;
    }

    private final List<BlueprintCallFrame> decodeBlueprintCallFrames(String input) {
        if (((CharSequence)input).length() == 0) {
            return new ArrayList();
        }
        List result = new ArrayList();
        String[] stringArray = new String[]{"<<<!!!"};
        Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"^^^"};
            List parts = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (parts.size() >= 4) {
                result.add(new BlueprintCallFrame(Integer.parseInt((String)parts.get(0)), (String)parts.get(1), (String)parts.get(2), (String)parts.get(3)));
                continue;
            }
            throw new IllegalArgumentException("Invalid line format: " + it);
        }
        return result;
    }

    private final boolean isProcessingNeeds(List<? extends XStackFrame> stackFrames) {
        if (stackFrames.isEmpty()) {
            return false;
        }
        if (BlueprintCallstackFrameCompatibilityMatcher.Companion.matchFrames((XStackFrame)CollectionsKt.first(stackFrames), this.myPreviousFrame).isMatched()) {
            return true;
        }
        int n = stackFrames.size();
        for (int i = 1; i < n; ++i) {
            if (!BlueprintCallstackFrameCompatibilityMatcher.Companion.matchFrames(stackFrames.get(i), stackFrames.get(i - 1)).isMatched()) continue;
            return true;
        }
        return false;
    }

    private final boolean isBlueprintCallstackEnabled() {
        boolean bl;
        boolean bl2 = bl = this.myProject != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Project project = this.myProject;
        Intrinsics.checkNotNull((Object)project);
        return UnrealLogPanelSettings.Companion.getInstance(project).getShowBlueprintCallstack();
    }

    private final boolean isShowUnrealFramesEnabled() {
        boolean bl;
        boolean bl2 = bl = this.myProject != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Project project = this.myProject;
        Intrinsics.checkNotNull((Object)project);
        return UnrealLogPanelSettings.Companion.getInstance(project).getShowUnrealFrames();
    }

    private final boolean isSupportedPlatform() {
        return SystemInfo.isWindows;
    }

    private static final List transform$lambda$3(StructuredIdeActivity $transformActivity, List okResult, Throwable exception) {
        StructuredIdeActivity structuredIdeActivity = $transformActivity;
        if (structuredIdeActivity != null) {
            StructuredIdeActivity.finished$default((StructuredIdeActivity)structuredIdeActivity, null, (int)1, null);
        }
        if (exception != null) {
            throw exception;
        }
        return okResult;
    }

    private static final List transform$lambda$4(Function2 $tmp0, Object p0, Throwable p1) {
        return (List)$tmp0.invoke(p0, (Object)p1);
    }

    private static final List transformInternalAsync$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initializeBlueprintDataForStack$lambda$6(BlueprintStackTransformer this$0, StructuredIdeActivity $parentActivity, CidrStackFrame $frame, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Obsolescent obsolescent = this$0.myObsolescent;
        boolean bl = obsolescent != null ? obsolescent.isObsolete() : false;
        if (bl) {
            return;
        }
        StructuredIdeActivity activity = UnrealPluginUsagesCollector.startBlueprintStackGettingDataActivity(this$0.myProject, $parentActivity);
        String bpStackData = null;
        try {
            String string = driver.executeInterpreterCommand($frame.getThreadId(), $frame.getFrameIndex(), "jb_unreal_blueprint_get_stack " + $frame.getThread().getTid());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
            bpStackData = ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        finally {
            StructuredIdeActivity structuredIdeActivity = activity;
            if (structuredIdeActivity != null) {
                StructuredIdeActivity.finished$default((StructuredIdeActivity)structuredIdeActivity, null, (int)1, null);
            }
        }
        if (StringsKt.startsWith$default((String)bpStackData, (String)"NONE_BP_FRAMES", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)bpStackData, (String)"ERROR_BP_FRAMES", (boolean)false, (int)2, null) || ((CharSequence)bpStackData).length() == 0) {
            this$0.myCachedErrorForBlueprintCallstack = UnrealLinkBundle.message("RiderLink.Unreal.Debugger.BlueprintCallstack.Blueprint.StubFrame.UnspecifiedError", new Object[0]);
        } else if (StringsKt.startsWith$default((String)bpStackData, (String)"ERROR_AV_EXCEPTION", (boolean)false, (int)2, null)) {
            this$0.myCachedErrorForBlueprintCallstack = UnrealLinkBundle.message("RiderLink.Unreal.Debugger.BlueprintCallstack.Blueprint.StubFrame.EvaluationFailed", new Object[0]);
        } else {
            this$0.myCachedBlueprintCallstack = this$0.decodeBlueprintCallFrames(bpStackData);
        }
    }

    private static final List injectBlueprintFunctions$lambda$8(BlueprintStackTransformer this$0, List $stackFrames, Void it) {
        return this$0.processStackFramesSynchronously($stackFrames);
    }

    private static final List injectBlueprintFunctions$lambda$9(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$collapseExternalCodeFrames(BlueprintStackTransformer $this, List stackFrames) {
        return $this.collapseExternalCodeFrames(stackFrames);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/unreal/debugger/BlueprintStackTransformer$BlueprintCallFrame;", "", "originalFrameIndex", "", "functionFullName", "", "objectName", "functionDisplayName", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOriginalFrameIndex", "()I", "getFunctionFullName", "()Ljava/lang/String;", "getObjectName", "getFunctionDisplayName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rider.plugins.unreal.link"})
    public static final class BlueprintCallFrame {
        private final int originalFrameIndex;
        @NotNull
        private final String functionFullName;
        @NotNull
        private final String objectName;
        @NotNull
        private final String functionDisplayName;

        public BlueprintCallFrame(int originalFrameIndex, @NotNull String functionFullName, @NotNull String objectName, @NotNull String functionDisplayName) {
            Intrinsics.checkNotNullParameter((Object)functionFullName, (String)"functionFullName");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            Intrinsics.checkNotNullParameter((Object)functionDisplayName, (String)"functionDisplayName");
            this.originalFrameIndex = originalFrameIndex;
            this.functionFullName = functionFullName;
            this.objectName = objectName;
            this.functionDisplayName = functionDisplayName;
        }

        public final int getOriginalFrameIndex() {
            return this.originalFrameIndex;
        }

        @NotNull
        public final String getFunctionFullName() {
            return this.functionFullName;
        }

        @NotNull
        public final String getObjectName() {
            return this.objectName;
        }

        @NotNull
        public final String getFunctionDisplayName() {
            return this.functionDisplayName;
        }

        public final int component1() {
            return this.originalFrameIndex;
        }

        @NotNull
        public final String component2() {
            return this.functionFullName;
        }

        @NotNull
        public final String component3() {
            return this.objectName;
        }

        @NotNull
        public final String component4() {
            return this.functionDisplayName;
        }

        @NotNull
        public final BlueprintCallFrame copy(int originalFrameIndex, @NotNull String functionFullName, @NotNull String objectName, @NotNull String functionDisplayName) {
            Intrinsics.checkNotNullParameter((Object)functionFullName, (String)"functionFullName");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            Intrinsics.checkNotNullParameter((Object)functionDisplayName, (String)"functionDisplayName");
            return new BlueprintCallFrame(originalFrameIndex, functionFullName, objectName, functionDisplayName);
        }

        public static /* synthetic */ BlueprintCallFrame copy$default(BlueprintCallFrame blueprintCallFrame, int n, String string, String string2, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = blueprintCallFrame.originalFrameIndex;
            }
            if ((n2 & 2) != 0) {
                string = blueprintCallFrame.functionFullName;
            }
            if ((n2 & 4) != 0) {
                string2 = blueprintCallFrame.objectName;
            }
            if ((n2 & 8) != 0) {
                string3 = blueprintCallFrame.functionDisplayName;
            }
            return blueprintCallFrame.copy(n, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "BlueprintCallFrame(originalFrameIndex=" + this.originalFrameIndex + ", functionFullName=" + this.functionFullName + ", objectName=" + this.objectName + ", functionDisplayName=" + this.functionDisplayName + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.originalFrameIndex);
            result = result * 31 + this.functionFullName.hashCode();
            result = result * 31 + this.objectName.hashCode();
            result = result * 31 + this.functionDisplayName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlueprintCallFrame)) {
                return false;
            }
            BlueprintCallFrame blueprintCallFrame = (BlueprintCallFrame)other;
            if (this.originalFrameIndex != blueprintCallFrame.originalFrameIndex) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.functionFullName, (Object)blueprintCallFrame.functionFullName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.objectName, (Object)blueprintCallFrame.objectName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.functionDisplayName, (Object)blueprintCallFrame.functionDisplayName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/unreal/debugger/BlueprintStackTransformer$Companion;", "", "<init>", "()V", "myInstanceCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.rider.plugins.unreal.link"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

