/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.convertentity;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.lang.ASTNode;
import com.intellij.lang.XmlCodeFoldingBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import com.sixrr.xrp.intention.Intention;
import com.sixrr.xrp.intention.PsiElementPredicate;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertEntityIntention
extends Intention {
    @Nls
    private String myName = this.getFamilyName();
    @FileModifier.SafeFieldForPreview
    private BidirectionalMap<String, String> nameToSymbol;

    @Override
    protected void processIntention(@NotNull PsiElement element, Editor editor) throws IncorrectOperationException {
        Object placeholder;
        String text;
        if (element == null) {
            ConvertEntityIntention.$$$reportNull$$$0(0);
        }
        if ((text = element.getText()).charAt(1) != '#') {
            placeholder = this.getSymbol(element.getContainingFile(), text.substring(1, text.length() - 1));
            if (placeholder != null) {
                placeholder = "#" + Integer.toString(((String)placeholder).charAt(0));
            }
        } else {
            String refValue = XmlCodeFoldingBuilder.getEntityValue((String)text);
            placeholder = this.getName(element.getContainingFile(), refValue);
        }
        if (placeholder != null) {
            ConvertEntityIntention.replaceEntity(element, (String)placeholder, editor);
        }
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ConvertEntityIntention.$$$reportNull$$$0(1);
        }
    }

    private static void replaceEntity(@NotNull PsiElement element, String newEntityText, Editor editor) {
        if (element == null) {
            ConvertEntityIntention.$$$reportNull$$$0(2);
        }
        XmlTag tag = XmlElementFactory.getInstance((Project)element.getProject()).createTagFromText((CharSequence)("<a>&" + newEntityText + ";</a>"), element.getContainingFile().getLanguage());
        ASTNode entity = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode()).getTreeNext().getFirstChildNode();
        element.getParent().getNode().replaceChild(element.getNode(), entity);
        editor.getCaretModel().moveToOffset(entity.getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = element -> {
            if (element instanceof XmlEntityRef || element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_CHAR_ENTITY_REF) {
                String text = element.getText();
                if (text.charAt(1) != '#') {
                    String symbol = this.getSymbol(element.getContainingFile(), text.substring(1, text.length() - 1));
                    if (symbol != null) {
                        this.myName = RefactorXBundle.message("convert.to.numeric.character.entity", new Object[0]);
                        return true;
                    }
                } else {
                    String refValue = XmlCodeFoldingBuilder.getEntityValue((String)text);
                    String name = this.getName(element.getContainingFile(), refValue);
                    if (name != null) {
                        this.myName = RefactorXBundle.message("convert.to.named.character.entity", new Object[0]);
                        return true;
                    }
                }
            }
            return false;
        };
        if (psiElementPredicate == null) {
            ConvertEntityIntention.$$$reportNull$$$0(3);
        }
        return psiElementPredicate;
    }

    @Nullable
    private String getSymbol(PsiFile file, String name) {
        this.prepareMap(file);
        return (String)this.nameToSymbol.get((Object)StringUtil.toLowerCase((String)name));
    }

    @Nullable
    private String getName(PsiFile file, String symbol) {
        this.prepareMap(file);
        return (String)ContainerUtil.getFirstItem((Collection)((Collection)ObjectUtils.notNull((Object)this.nameToSymbol.getKeysByValue((Object)symbol), Collections.emptySet())));
    }

    private void prepareMap(PsiFile file) {
        final BidirectionalMap result = new BidirectionalMap();
        XmlFile entities = XmlUtil.findXmlFile((PsiFile)file, (String)Html5SchemaProvider.getCharsDtdLocation());
        XmlUtil.processXmlElements((XmlElement)entities, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement decl) {
                if (decl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (decl instanceof XmlEntityDecl) {
                    XmlEntityDecl entity = (XmlEntityDecl)decl;
                    String value = XmlCodeFoldingBuilder.getEntityValue((String)entity.getValueElement().getValue());
                    String name = entity.getName();
                    if (name != null) {
                        result.put((Object)StringUtil.toLowerCase((String)name), (Object)value);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/sixrr/xrp/convertentity/ConvertEntityIntention$1", "execute"));
            }
        }, (boolean)true);
        this.nameToSymbol = result;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? this.getFamilyName() : this.myName;
        if (string == null) {
            ConvertEntityIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = RefactorXBundle.message("intention.family.name.convert.entity", new Object[0]);
        if (string == null) {
            ConvertEntityIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/convertentity/ConvertEntityIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/convertentity/ConvertEntityIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceEntity";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

