/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.List;
import java.util.PriorityQueue;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.index.VertexSequencePackedRtree;
import org.locationtech.jts.simplify.LinkedRing;
import org.locationtech.jts.simplify.RingHullIndex;

class RingHull {
    private LinearRing inputRing;
    private int targetVertexNum = -1;
    private double targetAreaDelta = -1.0;
    private LinkedRing vertexRing;
    private double areaDelta = 0.0;
    private VertexSequencePackedRtree vertexIndex;
    private PriorityQueue<Corner> cornerQueue;

    public RingHull(LinearRing ring, boolean isOuter) {
        this.inputRing = ring;
        this.init(ring.getCoordinates(), isOuter);
    }

    public void setMinVertexNum(int minVertexNum) {
        this.targetVertexNum = minVertexNum;
    }

    public void setMaxAreaDelta(double maxAreaDelta) {
        this.targetAreaDelta = maxAreaDelta;
    }

    public Envelope getEnvelope() {
        return this.inputRing.getEnvelopeInternal();
    }

    public VertexSequencePackedRtree getVertexIndex() {
        return this.vertexIndex;
    }

    public LinearRing getHull(RingHullIndex hullIndex) {
        this.compute(hullIndex);
        Coordinate[] hullPts = this.vertexRing.getCoordinates();
        return this.inputRing.getFactory().createLinearRing(hullPts);
    }

    private void init(Coordinate[] ring, boolean isOuter) {
        boolean orientCW = isOuter;
        if (orientCW == Orientation.isCCW(ring)) {
            ring = (Coordinate[])ring.clone();
            CoordinateArrays.reverse(ring);
        }
        this.vertexRing = new LinkedRing(ring);
        this.vertexIndex = new VertexSequencePackedRtree(ring);
        this.vertexIndex.remove(ring.length - 1);
        this.cornerQueue = new PriorityQueue();
        for (int i2 = 0; i2 < this.vertexRing.size(); ++i2) {
            this.addCorner(i2, this.cornerQueue);
        }
    }

    private void addCorner(int i2, PriorityQueue<Corner> cornerQueue) {
        if (RingHull.isConvex(this.vertexRing, i2)) {
            return;
        }
        Corner corner = new Corner(i2, this.vertexRing.prev(i2), this.vertexRing.next(i2), RingHull.area(this.vertexRing, i2));
        cornerQueue.add(corner);
    }

    public static boolean isConvex(LinkedRing vertexRing, int index) {
        Coordinate pn;
        Coordinate p2;
        Coordinate pp = vertexRing.prevCoordinate(index);
        return -1 == Orientation.index(pp, p2 = vertexRing.getCoordinate(index), pn = vertexRing.nextCoordinate(index));
    }

    public static double area(LinkedRing vertexRing, int index) {
        Coordinate pp = vertexRing.prevCoordinate(index);
        Coordinate p2 = vertexRing.getCoordinate(index);
        Coordinate pn = vertexRing.nextCoordinate(index);
        return Triangle.area(pp, p2, pn);
    }

    public void compute(RingHullIndex hullIndex) {
        while (!this.cornerQueue.isEmpty() && this.vertexRing.size() > 3) {
            Corner corner = this.cornerQueue.poll();
            if (corner.isRemoved(this.vertexRing)) continue;
            if (this.isAtTarget(corner)) {
                return;
            }
            if (!this.isRemovable(corner, hullIndex)) continue;
            this.removeCorner(corner, this.cornerQueue);
        }
    }

    private boolean isAtTarget(Corner corner) {
        if (this.targetVertexNum >= 0) {
            return this.vertexRing.size() < this.targetVertexNum;
        }
        if (this.targetAreaDelta >= 0.0) {
            return this.areaDelta + corner.getArea() > this.targetAreaDelta;
        }
        return true;
    }

    private void removeCorner(Corner corner, PriorityQueue<Corner> cornerQueue) {
        int index = corner.getIndex();
        int prev2 = this.vertexRing.prev(index);
        int next = this.vertexRing.next(index);
        this.vertexRing.remove(index);
        this.vertexIndex.remove(index);
        this.areaDelta += corner.getArea();
        this.addCorner(prev2, cornerQueue);
        this.addCorner(next, cornerQueue);
    }

    private boolean isRemovable(Corner corner, RingHullIndex hullIndex) {
        Envelope cornerEnv = corner.envelope(this.vertexRing);
        if (this.hasIntersectingVertex(corner, cornerEnv, this)) {
            return false;
        }
        if (hullIndex == null) {
            return true;
        }
        for (RingHull hull : hullIndex.query(cornerEnv)) {
            if (hull == this || !this.hasIntersectingVertex(corner, cornerEnv, hull)) continue;
            return false;
        }
        return true;
    }

    private boolean hasIntersectingVertex(Corner corner, Envelope cornerEnv, RingHull hull) {
        int[] result2 = hull.query(cornerEnv);
        for (int i2 = 0; i2 < result2.length; ++i2) {
            Coordinate v;
            int index = result2[i2];
            if (hull == this && corner.isVertex(index) || !corner.intersects(v = hull.getCoordinate(index), this.vertexRing)) continue;
            return true;
        }
        return false;
    }

    private Coordinate getCoordinate(int index) {
        return this.vertexRing.getCoordinate(index);
    }

    private int[] query(Envelope cornerEnv) {
        return this.vertexIndex.query(cornerEnv);
    }

    void queryHull(Envelope queryEnv, List<Coordinate> pts) {
        int[] result2 = this.vertexIndex.query(queryEnv);
        for (int i2 = 0; i2 < result2.length; ++i2) {
            int index = result2[i2];
            if (!this.vertexRing.hasCoordinate(index)) continue;
            Coordinate v = this.vertexRing.getCoordinate(index);
            pts.add(v);
        }
    }

    public Polygon toGeometry() {
        GeometryFactory fact = new GeometryFactory();
        Coordinate[] coords = this.vertexRing.getCoordinates();
        return fact.createPolygon(fact.createLinearRing(coords));
    }

    private static class Corner
    implements Comparable<Corner> {
        private int index;
        private int prev;
        private int next;
        private double area;

        public Corner(int i2, int prev2, int next, double area) {
            this.index = i2;
            this.prev = prev2;
            this.next = next;
            this.area = area;
        }

        public boolean isVertex(int index) {
            return index == this.index || index == this.prev || index == this.next;
        }

        public int getIndex() {
            return this.index;
        }

        public double getArea() {
            return this.area;
        }

        @Override
        public int compareTo(Corner o) {
            return Double.compare(this.area, o.area);
        }

        public Envelope envelope(LinkedRing ring) {
            Coordinate pp = ring.getCoordinate(this.prev);
            Coordinate p2 = ring.getCoordinate(this.index);
            Coordinate pn = ring.getCoordinate(this.next);
            Envelope env = new Envelope(pp, pn);
            env.expandToInclude(p2);
            return env;
        }

        public boolean intersects(Coordinate v, LinkedRing ring) {
            Coordinate pp = ring.getCoordinate(this.prev);
            Coordinate p2 = ring.getCoordinate(this.index);
            Coordinate pn = ring.getCoordinate(this.next);
            return Triangle.intersects(pp, p2, pn, v);
        }

        public boolean isRemoved(LinkedRing ring) {
            return ring.prev(this.index) != this.prev || ring.next(this.index) != this.next;
        }

        public LineString toLineString(LinkedRing ring) {
            Coordinate pp = ring.getCoordinate(this.prev);
            Coordinate p2 = ring.getCoordinate(this.index);
            Coordinate pn = ring.getCoordinate(this.next);
            return new GeometryFactory().createLineString(new Coordinate[]{Corner.safeCoord(pp), Corner.safeCoord(p2), Corner.safeCoord(pn)});
        }

        private static Coordinate safeCoord(Coordinate p2) {
            if (p2 == null) {
                return new Coordinate(Double.NaN, Double.NaN);
            }
            return p2;
        }
    }
}

