/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.operation.overlay.MaximalEdgeRing;
import org.locationtech.jts.operation.overlay.MinimalEdgeRing;
import org.locationtech.jts.util.Assert;

public class PolygonBuilder {
    private GeometryFactory geometryFactory;
    private List shellList = new ArrayList();

    public PolygonBuilder(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public void add(PlanarGraph graph) {
        this.add(graph.getEdgeEnds(), graph.getNodes());
    }

    public void add(Collection dirEdges, Collection nodes2) {
        PlanarGraph.linkResultDirectedEdges(nodes2);
        List maxEdgeRings = this.buildMaximalEdgeRings(dirEdges);
        ArrayList freeHoleList = new ArrayList();
        List edgeRings = this.buildMinimalEdgeRings(maxEdgeRings, this.shellList, freeHoleList);
        this.sortShellsAndHoles(edgeRings, this.shellList, freeHoleList);
        this.placeFreeHoles(this.shellList, freeHoleList);
    }

    public List getPolygons() {
        List resultPolyList = this.computePolygons(this.shellList);
        return resultPolyList;
    }

    private List buildMaximalEdgeRings(Collection dirEdges) {
        ArrayList<MaximalEdgeRing> maxEdgeRings = new ArrayList<MaximalEdgeRing>();
        for (DirectedEdge de : dirEdges) {
            if (!de.isInResult() || !de.getLabel().isArea() || de.getEdgeRing() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(de, this.geometryFactory);
            maxEdgeRings.add(er);
            er.setInResult();
        }
        return maxEdgeRings;
    }

    private List buildMinimalEdgeRings(List maxEdgeRings, List shellList, List freeHoleList) {
        ArrayList<MaximalEdgeRing> edgeRings = new ArrayList<MaximalEdgeRing>();
        for (MaximalEdgeRing er : maxEdgeRings) {
            if (er.getMaxNodeDegree() > 2) {
                er.linkDirectedEdgesForMinimalEdgeRings();
                List minEdgeRings = er.buildMinimalRings();
                EdgeRing shell = this.findShell(minEdgeRings);
                if (shell != null) {
                    this.placePolygonHoles(shell, minEdgeRings);
                    shellList.add(shell);
                    continue;
                }
                freeHoleList.addAll(minEdgeRings);
                continue;
            }
            edgeRings.add(er);
        }
        return edgeRings;
    }

    private EdgeRing findShell(List minEdgeRings) {
        int shellCount = 0;
        MinimalEdgeRing shell = null;
        for (MinimalEdgeRing er : minEdgeRings) {
            if (er.isHole()) continue;
            shell = er;
            ++shellCount;
        }
        Assert.isTrue(shellCount <= 1, "found two shells in MinimalEdgeRing list");
        return shell;
    }

    private void placePolygonHoles(EdgeRing shell, List minEdgeRings) {
        for (MinimalEdgeRing er : minEdgeRings) {
            if (!er.isHole()) continue;
            er.setShell(shell);
        }
    }

    private void sortShellsAndHoles(List edgeRings, List shellList, List freeHoleList) {
        for (EdgeRing er : edgeRings) {
            if (er.isHole()) {
                freeHoleList.add(er);
                continue;
            }
            shellList.add(er);
        }
    }

    private void placeFreeHoles(List shellList, List freeHoleList) {
        for (EdgeRing hole : freeHoleList) {
            if (hole.getShell() != null) continue;
            EdgeRing shell = PolygonBuilder.findEdgeRingContaining(hole, shellList);
            if (shell == null) {
                throw new TopologyException("unable to assign hole to a shell", hole.getCoordinate(0));
            }
            hole.setShell(shell);
        }
    }

    private static EdgeRing findEdgeRingContaining(EdgeRing testEr, List shellList) {
        LinearRing testRing = testEr.getLinearRing();
        Envelope testEnv = testRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        EdgeRing minShell = null;
        Envelope minShellEnv = null;
        for (EdgeRing tryShell : shellList) {
            LinearRing tryShellRing = tryShell.getLinearRing();
            Envelope tryShellEnv = tryShellRing.getEnvelopeInternal();
            if (tryShellEnv.equals(testEnv) || !tryShellEnv.contains(testEnv)) continue;
            testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryShellRing.getCoordinates());
            boolean isContained = false;
            if (PointLocation.isInRing(testPt, tryShellRing.getCoordinates())) {
                isContained = true;
            }
            if (!isContained || minShell != null && !minShellEnv.contains(tryShellEnv)) continue;
            minShell = tryShell;
            minShellEnv = minShell.getLinearRing().getEnvelopeInternal();
        }
        return minShell;
    }

    private List computePolygons(List shellList) {
        ArrayList<Polygon> resultPolyList = new ArrayList<Polygon>();
        for (EdgeRing er : shellList) {
            Polygon poly = er.toPolygon(this.geometryFactory);
            resultPolyList.add(poly);
        }
        return resultPolyList;
    }
}

