/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.SqlPreFormatter;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(1);
        }
        TextRange textRange = this.process(node, range, null, true);
        if (textRange == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range, @Nullable SqlCodeStyleSettings sqlSettings, boolean allowResolving) {
        SqlPreFormatter preFormatter;
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(3);
        }
        if (range == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(4);
        }
        if ((preFormatter = SqlPreFormatProcessor.preparePreFormatter(node, sqlSettings, allowResolving)) != null) {
            return preFormatter.process(range);
        }
        return range;
    }

    @Nullable
    private static SqlPreFormatter preparePreFormatter(@NotNull ASTNode node, @Nullable SqlCodeStyleSettings sqlSettings, boolean allowResolving) {
        Document document;
        SqlCodeStyleSettings settings;
        PsiElement psiElement;
        PsiFile file;
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(5);
        }
        PsiFile psiFile = file = (psiElement = node.getPsi()) == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        if (SqlPreFormatProcessor.fileIsFrankensteinInjection(file)) {
            return null;
        }
        if (file.getTextLength() < 1024 && SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlStatement.class).isEmpty()) {
            return null;
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlCodeStyleSettings sqlCodeStyleSettings = settings = sqlSettings != null ? sqlSettings : SqlCodeStyles.getSqlSettings((PsiFile)file);
        if (settings.DISABLE_FORMATTING) {
            return null;
        }
        Project project = psiElement.getProject();
        Document hardRef = (Document)file.getUserData(FileDocumentManagerBase.HARD_REF_TO_DOCUMENT_KEY);
        Object object = hardRef != null ? hardRef : (document = ApplicationManager.getApplication().isReadAccessAllowed() ? file.getViewProvider().getDocument() : null);
        if (document == null) {
            return null;
        }
        return new SqlPreFormatter(project, document, psiElement, language.getDbms(), settings, allowResolving);
    }

    private static boolean fileIsFrankensteinInjection(@NotNull PsiFile file) {
        Boolean frankenstein;
        if (file == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(6);
        }
        return (frankenstein = (Boolean)file.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION)) != null && frankenstein != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preparePreFormatter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileIsFrankensteinInjection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

