/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokensHelper {
    private final TokenClasses myClasses;
    private final SqlLanguageDialectEx.BuiltinFunctions myFunctionMap;
    private final NullableFunction<String, IElementType> myReservedTokens;
    private final NullableFunction<String, IElementType> myReservedPlTokens;
    private final NullableFunction<String, IElementType> myAllTokens;
    private final Set<String> myKeywords;
    private final Set<String> myReservedKeywords;
    private final Set<SqlKeywordTokenType> mySyntheticKeywords;

    public TokensHelper(@NotNull Class<?> tokensHolderClass, @NotNull SqlLanguageDialectEx.BuiltinFunctions functionMap) {
        if (tokensHolderClass == null) {
            TokensHelper.$$$reportNull$$$0(0);
        }
        if (functionMap == null) {
            TokensHelper.$$$reportNull$$$0(1);
        }
        this(tokensHolderClass, null, functionMap);
    }

    public TokensHelper(@NotNull Class<?> tokensHolderClass, @Nullable Class<?> reservedPlHolderClass, @NotNull SqlLanguageDialectEx.BuiltinFunctions functionMap) {
        if (tokensHolderClass == null) {
            TokensHelper.$$$reportNull$$$0(2);
        }
        if (functionMap == null) {
            TokensHelper.$$$reportNull$$$0(3);
        }
        this(new TokenClasses(tokensHolderClass), reservedPlHolderClass, functionMap);
    }

    public TokensHelper(@NotNull TokenClasses classes, @Nullable Class<?> reservedPlHolderClass, @NotNull SqlLanguageDialectEx.BuiltinFunctions functionMap) {
        if (classes == null) {
            TokensHelper.$$$reportNull$$$0(4);
        }
        if (functionMap == null) {
            TokensHelper.$$$reportNull$$$0(5);
        }
        this.myClasses = classes;
        this.myFunctionMap = functionMap;
        TokensHelper.initTokens(this.getFunctionMap(), this.getClasses());
        if (reservedPlHolderClass != null) {
            SqlTokenRegistry.initTypeMap(reservedPlHolderClass, null);
        }
        this.myAllTokens = SqlTokenRegistry.getTokenProvider((Class)this.getClasses().all);
        this.myReservedTokens = SqlTokenRegistry.getTokenProvider((Class)this.getClasses().reserved);
        this.myReservedPlTokens = reservedPlHolderClass == null ? this.myReservedTokens : SqlTokenRegistry.getTokenProvider(reservedPlHolderClass);
        this.myKeywords = SqlTokenRegistry.getTokens((Class)this.getClasses().all);
        this.myReservedKeywords = SqlTokenRegistry.getTokens((Class)this.getClasses().reserved);
        this.mySyntheticKeywords = SqlTokenRegistry.getSyntheticTokens((Class)this.getClasses().all);
    }

    public boolean isSyntheticKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && this.mySyntheticKeywords.contains(tokenType);
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && this.getReservedTokens().fun((Object)tokenType.toString()) != null;
    }

    public boolean isReservedPlKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && this.myReservedPlTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public TokenClasses getClasses() {
        TokenClasses tokenClasses = this.myClasses;
        if (tokenClasses == null) {
            TokensHelper.$$$reportNull$$$0(6);
        }
        return tokenClasses;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getFunctionMap() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = this.myFunctionMap;
        if (builtinFunctions == null) {
            TokensHelper.$$$reportNull$$$0(7);
        }
        return builtinFunctions;
    }

    @NotNull
    public NullableFunction<String, IElementType> getAllTokens() {
        NullableFunction<String, IElementType> nullableFunction = this.myAllTokens;
        if (nullableFunction == null) {
            TokensHelper.$$$reportNull$$$0(8);
        }
        return nullableFunction;
    }

    @NotNull
    public NullableFunction<String, IElementType> getReservedTokens() {
        NullableFunction<String, IElementType> nullableFunction = this.myReservedTokens;
        if (nullableFunction == null) {
            TokensHelper.$$$reportNull$$$0(9);
        }
        return nullableFunction;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = this.myKeywords;
        if (set == null) {
            TokensHelper.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = this.myReservedKeywords;
        if (set == null) {
            TokensHelper.$$$reportNull$$$0(11);
        }
        return set;
    }

    public static void initTokens(SqlLanguageDialectEx.BuiltinFunctions functions, TokenClasses tokensClasses) {
        TokensHelper.ensureElementFactoryIsLoaded(tokensClasses);
        SqlTokenRegistry.initTypeMap((Class)tokensClasses.all, null);
        SqlTokenRegistry.initTypeMap((Class)tokensClasses.reserved, null);
        Set reservedNames = SqlTokenRegistry.getTokens((Class)tokensClasses.reserved);
        SqlTokenRegistry.initTypeMap((Class)tokensClasses.optional, (Set)reservedNames);
        Set<String> fromDefinitions = SqlDialectImplUtilCore.getAllKeywordsFromDefinition(functions.forTokens(), new HashSet<String>());
        fromDefinitions.removeAll(reservedNames);
        SqlTokenRegistry.addTokensToClassMap((Class)tokensClasses.optional, fromDefinitions, (boolean)false);
        SqlTokenRegistry.addTokensToClassMap((Class)tokensClasses.all, fromDefinitions, (boolean)true);
    }

    private static void ensureElementFactoryIsLoaded(TokenClasses tokensClasses) {
        String name2 = tokensClasses.all.getName();
        int suffixStart = name2.lastIndexOf("Tokens");
        String factoryName = name2.substring(0, suffixStart) + "ElementFactory";
        try {
            Class.forName(factoryName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokensHolderClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/base/TokensHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/base/TokensHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTokens";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedTokens";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

