/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DriversSideTab
extends DatabaseConfigSideTab {
    public DriversSideTab(@NotNull DatabaseConfigEditorImpl editor2) {
        if (editor2 == null) {
            DriversSideTab.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message("tab.title.drivers", new Object[0]), editor2);
    }

    Collection<DatabaseDriver> getAllDrivers(DatabaseConfigEditorImpl.DataSourceSettings settings) {
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        ArrayList<DatabaseDriver> result2 = new ArrayList<DatabaseDriver>(driverManager.getDrivers());
        result2.addAll(settings.newDrivers);
        result2.removeAll(this.myRemovedObjects);
        result2.sort(Comparator.comparing(DatabaseDriver::getName, DbPresentation.NAMES_COMPARATOR));
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            DriversSideTab.$$$reportNull$$$0(1);
        }
        try {
            HashSet addedItems = new HashSet();
            Set selection = keepSelection ? this.getSelectedItems().toSet() : null;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            List<@NlsContexts.Separator String> sections = Arrays.asList(DatabaseBundle.message("separator.user.drivers", new Object[0]), DatabaseBundle.message("separator.complete.support", new Object[0]), DatabaseBundle.message("separator.basic.support", new Object[0]));
            List items = this.sectionize(this.getAllDrivers(settings), this::createItem, o -> !((DatabaseDriver)o.getObject()).isPredefined() ? 0 : (LocalDataSourceManager.isGenericSupport((DatabaseDriver)o.getObject()) ? 2 : 1));
            for (int i2 = 0; i2 < items.size(); ++i2) {
                this.mySidePanel.addSeparator(sections.get(i2));
                List list = items.get(i2);
                list.sort(Comparator.comparing(it -> LocalDataSourceManager.getExtraSection((DatabaseDriver)it.getObject()), Comparing::compare).thenComparing(SidePanelItem.DriverItem::getName, DbPresentation.NAMES_COMPARATOR));
                String ps = null;
                for (SidePanelItem.DriverItem item : list) {
                    String section;
                    if (i2 == 2 && !Objects.equals(section = LocalDataSourceManager.getExtraSection((DatabaseDriver)item.getObject()), ps)) {
                        if (section != null) {
                            this.mySidePanel.addSeparator(section);
                        }
                        ps = section;
                    }
                    addedItems.add(this.addToSidePanel(item));
                }
            }
            if (keepSelection) {
                this.restoreSelection(selection);
            }
            for (SidePanelItem item : new ArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
        }
        finally {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    @Override
    public boolean isMine(Object object) {
        return object instanceof DatabaseDriver;
    }

    @NotNull
    private SidePanelItem.DriverItem createItem(@NotNull DatabaseDriver obj2) {
        SidePanelItem.DriverItem item;
        if (obj2 == null) {
            DriversSideTab.$$$reportNull$$$0(2);
        }
        if ((item = (SidePanelItem.DriverItem)this.getSidePanelItem(obj2)) == null) {
            item = new SidePanelItem.DriverItem(this.myEditor, obj2);
        }
        SidePanelItem.DriverItem driverItem = this.createItem(item);
        if (driverItem == null) {
            DriversSideTab.$$$reportNull$$$0(3);
        }
        return driverItem;
    }

    @NotNull
    JBIterable<SidePanelItem.DriverItem> getSelectedDrivers() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DriverItem.class);
        if (jBIterable == null) {
            DriversSideTab.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Override
    void configureActionGroups(DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup context, JList<?> target2) {
        ActionManager actionManager = ActionManager.getInstance();
        AddAction addAction = new AddAction();
        addAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target2);
        DatabaseConfigSideTab.RemoveAction removeAction = new DatabaseConfigSideTab.RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target2);
        DatabaseConfigSideTab.CopyAction copyAction = new DatabaseConfigSideTab.CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target2);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        BackAction backAction = new BackAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        ShowDriverUsagesAction showUsagesAction = new ShowDriverUsagesAction();
        ResetToPredefinedAction resetToPredefAction = new ResetToPredefinedAction();
        showUsagesAction.registerCustomShortcutSet(actionManager.getAction("FindUsages").getShortcutSet(), target2);
        DatabaseConfigSideTab.ResetAction revertAction = new DatabaseConfigSideTab.ResetAction();
        revertAction.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target2);
        left.addAll(new AnAction[]{addAction, removeAction, copyAction});
        right.addAll(new AnAction[]{backAction, forwardAction});
        context.add((AnAction)addAction);
        context.add((AnAction)removeAction);
        context.add((AnAction)copyAction);
        context.addSeparator();
        context.add((AnAction)showUsagesAction);
        context.addSeparator();
        context.add((AnAction)revertAction);
        context.add((AnAction)resetToPredefAction);
    }

    @Override
    boolean canRemove(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.DriverItem driverItem;
        if (item == null) {
            DriversSideTab.$$$reportNull$$$0(5);
        }
        if ((driverItem = (SidePanelItem.DriverItem)ObjectUtils.tryCast(item, SidePanelItem.DriverItem.class)) == null) {
            return false;
        }
        DatabaseDriver driver = (DatabaseDriver)driverItem.getObject();
        DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)driverItem.getConfigurable();
        if (driver.isPredefined()) {
            return false;
        }
        DatabaseDriverImpl actual = configurable != null ? configurable.getTempDriver() : null;
        return !this.myEditor.isUsed(driver) && (actual == null || !this.myEditor.isUsed(actual));
    }

    @Override
    protected void ensureNewObjectDropped(Object object) {
        if (object instanceof DatabaseDriver) {
            this.myEditor.getSettings().newDrivers.remove(object);
        }
    }

    @Override
    protected void removeObject(Object object) {
        if (object instanceof DatabaseDriver) {
            DatabaseDriver driver = (DatabaseDriver)object;
            for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
                if (databaseDriver != driver) continue;
                DatabaseDriverManager.getInstance().removeDriver(driver);
                break;
            }
        }
    }

    @Override
    public void copy(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.DriverItem driverItem;
        if (item == null) {
            DriversSideTab.$$$reportNull$$$0(6);
        }
        if ((driverItem = (SidePanelItem.DriverItem)ObjectUtils.tryCast(item, SidePanelItem.DriverItem.class)) == null) {
            return;
        }
        DatabaseDriverImpl databaseDriver = (DatabaseDriverImpl)this.myEditor.getTempTargetOrTarget((DatabaseDriver)driverItem.getObject());
        Set names = (Set)JBIterable.from(this.getAllDrivers(this.myEditor.getSettings())).map(DatabaseDriver::getName).addAllTo((Collection)CollectionFactory.createCaseInsensitiveStringSet());
        String newName = DbUtil.generateUniqueName(databaseDriver.getName(), names);
        this.addNewDriverAndNavigate(databaseDriver.copy(newName, false));
    }

    private DatabaseDriver createDatabaseDriver() {
        return DataSourceUiUtil.createDefaultDatabaseDriver(this.getAllDrivers(this.myEditor.getSettings()));
    }

    void addNewDriverAndNavigate(@NotNull DatabaseDriver newDriver) {
        if (newDriver == null) {
            DriversSideTab.$$$reportNull$$$0(7);
        }
        this.myEditor.getSettings().newDrivers.add(newDriver);
        this.refillSidePanel(this.myEditor.getSettings(), false);
        this.myEditor.navigateTo(newDriver, true);
    }

    @NotNull
    private static Set<String> getDialectEquality(@Nullable String dialect) {
        HashSet<String> res2 = new HashSet<String>();
        if (dialect == null) {
            HashSet<String> hashSet = res2;
            if (hashSet == null) {
                DriversSideTab.$$$reportNull$$$0(8);
            }
            return hashSet;
        }
        res2.add(dialect);
        SqlLanguageDialect lang = SqlDialects.findDialectById(dialect);
        if (lang == null) {
            HashSet<String> hashSet = res2;
            if (hashSet == null) {
                DriversSideTab.$$$reportNull$$$0(9);
            }
            return hashSet;
        }
        Dbms dbms = lang.getDbms();
        HSet eqSet = (HSet)ContainerUtil.find(Arrays.asList(Dbms.POSTGRES_LIKE, Dbms.ORACLE.getHSet(), Dbms.MSSQL_LIKE, Dbms.MYSQL_LIKE), dbms::in);
        if (eqSet != null) {
            for (SqlLanguageDialect d : SqlDialects.getSqlDialects()) {
                if (!d.getDbms().in(eqSet)) continue;
                res2.add(d.getID());
            }
        }
        HashSet<String> hashSet = res2;
        if (hashSet == null) {
            DriversSideTab.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    JBIterable<DatabaseDriver> getDrivers(JBIterable<LocalDataSource> dataSources) {
        String defaultDialect = SqlDialects.getGenericDialect().getID();
        JBIterable dialects = dataSources.filterMap(source -> {
            DatabaseDriver driver = source.getDatabaseDriver();
            return driver == null ? null : StringUtil.notNullize((String)driver.getSqlDialect(), (String)defaultDialect);
        });
        if (dialects.toSet().size() != 1) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DriversSideTab.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        Set<String> equality = DriversSideTab.getDialectEquality((String)dialects.first());
        JBIterable jBIterable = JBIterable.from(this.getAllDrivers(this.myEditor.getSettings())).filter(DatabaseDriver.class).filter(driver -> equality.contains(StringUtil.notNullize((String)this.myEditor.getTempTargetOrTarget(driver).getSqlDialect(), (String)defaultDialect)));
        if (jBIterable == null) {
            DriversSideTab.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Override
    public boolean canCopy(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DriversSideTab.$$$reportNull$$$0(13);
        }
        return item instanceof SidePanelItem.DriverItem;
    }

    private void showUsagesPopup(final @Nullable SidePanelItem.DriverItem item) {
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final ArrayList actions = new ArrayList();
        if (item != null) {
            ContainerUtil.process(this.myEditor.dsSideTab.getSidePanelItems(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(final SidePanelItem.DataSourceItem dataSourceItem) {
                    DatabaseDriver driver;
                    LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                    DatabaseDriver databaseDriver = driver = dataSource == null ? null : dataSource.getDatabaseDriver();
                    if (driver == null) {
                        return true;
                    }
                    if (driver == item.getObject() || driver == DriversSideTab.this.myEditor.getTempTargetOrTarget((DatabaseDriver)item.getObject())) {
                        actions.add(new DumbAwareAction(dataSourceItem.getName(), null, ((DbDataSourceImpl)dataSourceItem.getObject()).getIcon()){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                DriversSideTab.this.myEditor.navigateTo(dataSourceItem.getObject(), false);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DriversSideTab$1$1", "actionPerformed"));
                            }
                        });
                    }
                    return true;
                }
            });
        }
        if (actions.isEmpty()) {
            Messages.showInfoMessage((Component)this.getComponent(), (String)DatabaseBundle.message("dialog.message.DatabaseConfigEditor.no.usages.found", new Object[0]), (String)DatabaseBundle.message("dialog.title.DatabaseConfigEditor.driver.usages", new Object[0]));
        } else {
            JList<Place> list = this.getList();
            int selectedRow = list.getSelectedIndex();
            Rectangle rowBounds = list.getCellBounds(selectedRow, selectedRow);
            Point location = rowBounds.getLocation();
            location.x += Math.min(rowBounds.width, list.getParent().getWidth());
            int count = actions.size();
            ListPopup popup2 = popupFactory.createActionGroupPopup(DatabaseBundle.message("popup.title.DatabaseConfigEditor.used.by.choice.data.source.data.sources", count, count == 0 ? 0 : 1), (ActionGroup)new DefaultActionGroup(actions), DataManager.getInstance().getDataContext(list), null, true);
            popup2.show(new RelativePoint(list, location));
        }
    }

    @Nullable
    public static DriversSideTab getDriversTab(@Nullable AnActionEvent e) {
        return e == null ? null : (DriversSideTab)ObjectUtils.tryCast((Object)e.getData(SIDE_PANEL), DriversSideTab.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DriversSideTab";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DriversSideTab";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDrivers";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectEquality";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrivers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canRemove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewDriverAndNavigate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canCopy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static final class AddAction
    extends DumbAwareAction {
        private AddAction() {
            super(DatabaseBundle.message("action.driver.text", new Object[0]), null, IconUtil.getAddIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DriversSideTab driversTab;
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            if ((driversTab = DriversSideTab.getDriversTab(e)) == null) {
                return;
            }
            driversTab.addNewDriverAndNavigate(driversTab.createDatabaseDriver());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DriversSideTab$AddAction", "actionPerformed"));
        }
    }

    private static class ShowDriverUsagesAction
    extends DumbAwareAction {
        ShowDriverUsagesAction() {
            super(DatabaseBundle.message("action.show.driver.usages.text", new Object[0]), null, AllIcons.Actions.Find);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ShowDriverUsagesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DriversSideTab sidePanel;
            if (e == null) {
                ShowDriverUsagesAction.$$$reportNull$$$0(1);
            }
            if ((sidePanel = DriversSideTab.getDriversTab(e)) == null) {
                return;
            }
            sidePanel.showUsagesPopup((SidePanelItem.DriverItem)sidePanel.getSelectedDrivers().first());
        }

        public void update(@NotNull AnActionEvent e) {
            DriversSideTab sidePanel;
            if (e == null) {
                ShowDriverUsagesAction.$$$reportNull$$$0(2);
            }
            SidePanelItem.DriverItem selectedDriver = (sidePanel = DriversSideTab.getDriversTab(e)) == null ? null : (SidePanelItem.DriverItem)sidePanel.getSelectedDrivers().single();
            e.getPresentation().setEnabledAndVisible(selectedDriver != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriversSideTab$ShowDriverUsagesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriversSideTab$ShowDriverUsagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ResetToPredefinedAction
    extends DumbAwareAction {
        ResetToPredefinedAction() {
            super(DatabaseBundle.message("action.reset.to.predefined.text", new Object[0]), null, AllIcons.Actions.Undo);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DriversSideTab driversTab;
            if (e == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(1);
            }
            JBIterable drivers = (driversTab = DriversSideTab.getDriversTab(e)) == null ? JBIterable.empty() : driversTab.getSelectedDrivers().filter(ResetToPredefinedAction.isPredefinedChangedCondition(driversTab));
            for (SidePanelItem.DriverItem driverItem : drivers) {
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)driverItem.createConfigurable();
                DatabaseDriverImpl driver = configurable.getTempDriver();
                DatabaseDriverManager.getInstance().resetToPredefined(driver);
                configurable.resetFromTemp();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            DriversSideTab driversTab;
            if (e == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(2);
            }
            JBIterable selectedDrivers = (driversTab = DriversSideTab.getDriversTab(e)) == null ? JBIterable.empty() : driversTab.getSelectedDrivers().filter(ResetToPredefinedAction.isPredefinedChangedCondition(driversTab));
            e.getPresentation().setEnabledAndVisible(!selectedDrivers.isEmpty());
        }

        @NotNull
        private static Condition<SidePanelItem.DriverItem> isPredefinedChangedCondition(DriversSideTab sideTab) {
            Condition condition = item -> !DatabaseDriverManager.getInstance().isInPredefinedState(sideTab.myEditor.getTempTargetOrTarget((DatabaseDriver)item.getObject()));
            if (condition == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(3);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriversSideTab$ResetToPredefinedAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriversSideTab$ResetToPredefinedAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isPredefinedChangedCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

