/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DbModelResetHelper;
import com.intellij.database.schemaEditor.model.DbModelResolveHelper;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbModelApplyHelper
extends DbModelResolveHelper
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbModelApplyHelper.class);
    private final Throwable trace;
    private boolean disposed;
    private final Set<DbEditorModel<?, ?>> myModified;
    private final Set<DbEditorModel<?, ?>> myCreated;
    private Throwable myForbidModifications;

    private DbModelApplyHelper(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner) {
        if (controller == null) {
            DbModelApplyHelper.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            DbModelApplyHelper.$$$reportNull$$$0(1);
        }
        super(controller, owner);
        this.trace = new Throwable();
        this.disposed = false;
        this.myModified = Collections.synchronizedSet(new LinkedHashSet());
        this.myCreated = Collections.synchronizedSet(new LinkedHashSet());
        this.myForbidModifications = new Throwable("Forbidden here");
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void created(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.track(model, DbModelApplyHelper.this.myCreated);
                this.track(model, DbModelApplyHelper.this.myModified);
            }

            @Override
            public void removed(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.track(model, DbModelApplyHelper.this.myModified);
            }

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.track(model, DbModelApplyHelper.this.myModified);
            }

            private void track(@NotNull DbEditorModel<?, ?> model, Set<DbEditorModel<?, ?>> collection) {
                if (model == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (DbModelApplyHelper.this.myForbidModifications != null) {
                    throw new AssertionError("Modification happened during apply", DbModelApplyHelper.this.myForbidModifications);
                }
                collection.add(model);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelApplyHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "track";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    public void dispose() {
        this.disposed = true;
    }

    public static void applyAll(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull DbModelTransactionManager.DbModelTransaction transaction) {
        if (controller == null) {
            DbModelApplyHelper.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            DbModelApplyHelper.$$$reportNull$$$0(3);
        }
        if (transaction == null) {
            DbModelApplyHelper.$$$reportNull$$$0(4);
        }
        DbModelApplyHelper.apply(controller, owner, new ArrayList(controller.getAllModels()), transaction);
    }

    public static void applyRefs(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull Iterable<DbModelRef<?, ?>> models2, @NotNull DbModelTransactionManager.DbModelTransaction transaction) {
        if (controller == null) {
            DbModelApplyHelper.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            DbModelApplyHelper.$$$reportNull$$$0(6);
        }
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(7);
        }
        if (transaction == null) {
            DbModelApplyHelper.$$$reportNull$$$0(8);
        }
        DbModelApplyHelper.apply(controller, owner, DbModelRef.resolveRefs(controller, models2), transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(@NotNull DbEditorModelController controller, @NotNull ElementOwner owner, @NotNull Iterable<DbEditorModel<?, ?>> models2, @NotNull DbModelTransactionManager.DbModelTransaction transaction) {
        if (controller == null) {
            DbModelApplyHelper.$$$reportNull$$$0(9);
        }
        if (owner == null) {
            DbModelApplyHelper.$$$reportNull$$$0(10);
        }
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(11);
        }
        if (transaction == null) {
            DbModelApplyHelper.$$$reportNull$$$0(12);
        }
        DbModelApplyHelper helper = new DbModelApplyHelper(controller, owner);
        try {
            helper.applyTrackingChanges(models2, transaction);
        }
        finally {
            Disposer.dispose((Disposable)helper);
        }
    }

    private void applyTrackingChanges(@NotNull Iterable<DbEditorModel<?, ?>> models2, @NotNull DbModelTransactionManager.DbModelTransaction transaction) {
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(13);
        }
        if (transaction == null) {
            DbModelApplyHelper.$$$reportNull$$$0(14);
        }
        this.myOwner.getCached().forEach(this.myOwner::find);
        this.applyModifiedUntilSettle(models2);
        this.myOwner.getCached().forEach(this.myOwner::find);
    }

    private void applyModifiedUntilSettle(Iterable<DbEditorModel<?, ?>> modifiedModels) {
        while (DbModelApplyHelper.isNotEmpty(modifiedModels)) {
            while (DbModelApplyHelper.isNotEmpty(modifiedModels)) {
                this.resetCreatedUntilSettle();
                this.applyModels(modifiedModels);
                modifiedModels = this.extractModifiedModels();
            }
            this.withModificationsAllowed(() -> {
                this.resolveModels();
                return null;
            }, true);
            modifiedModels = this.extractModifiedModels();
        }
    }

    private void resetCreatedUntilSettle() {
        List<DbEditorModel<?, ?>> created = this.extractCreatedModels();
        while (!created.isEmpty()) {
            this.resetCreatedModels(created);
            created = this.extractCreatedModels();
        }
    }

    private void resetCreatedModels(List<DbEditorModel<?, ?>> created) {
        this.withModificationsAllowed(() -> {
            this.resetCreatedModelsImpl(created);
            return null;
        }, true);
    }

    private void resetCreatedModelsImpl(List<DbEditorModel<?, ?>> created) {
        ElementOwner oOwner = this.myOwner.getOriginal();
        if (oOwner == null) {
            return;
        }
        List toPull = ContainerUtil.filter(created, m -> oOwner.find(m.getIdentity()) != null);
        DbModelResetHelper.reset(this.myController, oOwner, toPull);
    }

    private static boolean isNotEmpty(Iterable<?> ible) {
        Collection c2;
        return ible instanceof Collection ? !(c2 = (Collection)ible).isEmpty() : ible.iterator().hasNext();
    }

    @NotNull
    private List<DbEditorModel<?, ?>> extractModifiedModels() {
        return this.extractCollectionState(this.myModified);
    }

    @NotNull
    private List<DbEditorModel<?, ?>> extractCreatedModels() {
        return this.extractCollectionState(this.myCreated);
    }

    @NotNull
    private List<DbEditorModel<?, ?>> extractCollectionState(@NotNull Set<DbEditorModel<?, ?>> collection) {
        if (collection == null) {
            DbModelApplyHelper.$$$reportNull$$$0(15);
        }
        ArrayList modified = new ArrayList(collection);
        modified.forEach(collection::remove);
        ArrayList arrayList = modified;
        if (arrayList == null) {
            DbModelApplyHelper.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private Set<DbEditorModel<?, ?>> expand(@NotNull Iterable<DbEditorModel<?, ?>> models2) {
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(17);
        }
        LinkedHashSet res2 = ContainerUtil.newLinkedHashSet(models2);
        Set allIds = ContainerUtil.map2Set((Collection)res2, DbEditorModel::getIdentity);
        Set dropCreateIds = ContainerUtil.map2SetNotNull((Collection)res2, m -> m.getState() instanceof DbObjectModelState ? m.getIdentity() : null);
        for (DbEditorModel<?, ?> model : this.myController.getAllModels()) {
            ElementIdentity<?> id = model.getIdentity();
            if (!dropCreateIds.contains(id) && (!allIds.contains(id) || !(model.getState() instanceof DbObjectModelState))) continue;
            res2.add(model);
        }
        return res2;
    }

    private void applyModels(@NotNull Iterable<DbEditorModel<?, ?>> models2) {
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(18);
        }
        DbEditorModel anyUnregistered = (DbEditorModel)JBIterable.from(models2).find(e -> !this.myController.isModelRegistered((DbEditorModel<?, ?>)e));
        Set<DbEditorModel<?, ?>> expanded = this.expand(models2);
        DbModelApplyHelper.processByTarget(expanded, DbModelResolveHelper::applyOrder, new DbModelResolveHelper.ByTargetProcessor(){

            @Override
            public <T extends BasicElement> void process(@NotNull ElementIdentity<T> identity, @NotNull Set<DbEditorModel<T, ?>> models2) {
                if (identity == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (models2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                DbModelApplyHelper.this.applyToTarget(identity, models2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "identity";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "models";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/schemaEditor/model/DbModelApplyHelper$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.withModificationsAllowed(() -> {
            for (DbEditorModel model : expanded) {
                this.enableModel(model);
            }
            return null;
        }, true);
    }

    private <T extends BasicElement> void applyMulti(MultiElementIdentity<T> targetId, Iterable<DbEditorModel<T, ?>> models2) {
        for (DbEditorModel<T, ?> model : models2) {
            this.multiApplyModel(model);
        }
    }

    private <T extends BasicElement, S extends DbModelState> void multiApplyModel(DbEditorModel<T, S> model) {
        try {
            if (model.getMultiApplier() != null) {
                model.getMultiApplier().apply(model, this.myOwner);
            } else {
                model.getState().setEnabled(false);
            }
        }
        catch (Throwable th) {
            LOG.error(th);
        }
    }

    private <T extends BasicElement> void applyToTarget(@NotNull ElementIdentity<T> targetId, @NotNull Iterable<DbEditorModel<T, ?>> models2) {
        if (targetId == null) {
            DbModelApplyHelper.$$$reportNull$$$0(19);
        }
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(20);
        }
        DbEditorModel<T, DbObjectModelState<T>> objModel = DbModelApplyHelper.getObjectModel(this.myController, targetId, models2);
        List<DbEditorModel<T, ?>> sorted = DbModelApplyHelper.sortForApply(models2, objModel);
        if (targetId instanceof MultiElementIdentity) {
            this.applyToTargetImpl((MultiElementIdentity)targetId, sorted);
            return;
        }
        this.applyToTargetImpl(targetId, objModel, sorted);
    }

    private <T extends BasicElement> void applyToTargetImpl(@NotNull ElementIdentity<T> targetId, @Nullable DbEditorModel<T, DbObjectModelState<T>> objModel, @NotNull List<DbEditorModel<T, ?>> models2) {
        if (targetId == null) {
            DbModelApplyHelper.$$$reportNull$$$0(21);
        }
        if (models2 == null) {
            DbModelApplyHelper.$$$reportNull$$$0(22);
        }
        if (this.isDropped(targetId, objModel)) {
            this.myOwner.drop(targetId);
        } else {
            this.myOwner.findOrCreate(targetId);
        }
        for (DbEditorModel<T, ?> model : models2) {
            this.applyModel(model);
        }
    }

    private <T extends BasicElement, S extends DbModelState> void applyModel(DbEditorModel<T, S> model) {
        if (!this.myController.isModelRegistered(model)) {
            return;
        }
        try {
            model.getApplier().apply(model, this.myOwner);
        }
        catch (Throwable th) {
            LOG.error(th);
        }
    }

    private <T extends BasicElement> boolean isDropped(@NotNull ElementIdentity<T> targetId, @Nullable DbEditorModel<T, DbObjectModelState<T>> objModel) {
        if (targetId == null) {
            DbModelApplyHelper.$$$reportNull$$$0(23);
        }
        if (objModel == null) {
            return true;
        }
        if (this.myController.isModelRegistered(objModel)) {
            return objModel.getState().isDropped();
        }
        ElementOwner originalOwner = this.myOwner.getOriginal();
        Object originalElement = originalOwner == null ? null : originalOwner.findElement(targetId);
        return originalElement == null;
    }

    private <T extends BasicElement> void applyToTargetImpl(MultiElementIdentity<T> targetId, Iterable<DbEditorModel<T, ?>> models2) {
        this.withModificationsAllowed(() -> {
            this.applyMulti(targetId, models2);
            return null;
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V withModificationsAllowed(Supplier<V> r, boolean allowed) {
        Throwable prev2 = this.myForbidModifications;
        this.myForbidModifications = allowed ? null : new Throwable("Forbidden here");
        try {
            V v = r.get();
            return v;
        }
        finally {
            this.myForbidModifications = prev2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbModelApplyHelper";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbModelApplyHelper";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCollectionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyAll";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyRefs";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyTrackingChanges";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractCollectionState";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyModels";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyToTarget";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyToTargetImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDropped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

