/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.run.actions.ChangeTableSamplingSizeAction;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsSafe;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeTableSamplingSizeActionGroup
extends DefaultActionGroup
implements DumbAware {
    private static final List<@NlsSafe String> DEFAULT_TABLE_SAMPLING_SIZES = Arrays.asList("0.1", "0.5", "1", "2", "5", "10", "20", "30", "50", "70", "90");

    public ChangeTableSamplingSizeActionGroup() {
        this.setPopup(true);
        this.setActions();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangeTableSamplingSizeActionGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void setActions() {
        this.removeAll();
        for (String size : DEFAULT_TABLE_SAMPLING_SIZES) {
            this.add((AnAction)new ChangeTableSamplingSizeAction(size));
        }
        this.add((AnAction)new ChangeTableSamplingSizeAction(null));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangeTableSamplingSizeActionGroup.$$$reportNull$$$0(1);
        }
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        e.getPresentation().setEnabledAndVisible(grid != null && grid.getDataHookup() instanceof DatabaseTableGridDataHookUp && DbImplUtilCore.supportsTableSampling(DataGridUtil.getDatabaseTable(grid), DataGridUtil.getDbms(grid)));
        if (grid != null) {
            String size = DataGridUtilCore.getTableSamplingSize(grid);
            e.getPresentation().setText(size == null ? DatabaseBundle.message("action.Console.TableResult.ChangeTableSample.disabled.text", new Object[0]) : DatabaseBundle.message("action.Console.TableResult.ChangeTableSample.percent.text", size));
        } else {
            e.getPresentation().setText(this.getTemplateText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChangeTableSamplingSizeActionGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChangeTableSamplingSizeActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

