/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.h2.model.H2Root;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.Version;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u001cMNOPQRSTUVWXYZ[\\]^_`abcdefghB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u0005*\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0002J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0006H\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0015J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J2\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00130\u0015J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J2\u0010\"\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010$\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010&\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010(\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010*\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010,\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010.\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00130\u0015J2\u00100\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u00130\u0015J2\u00102\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u00130\u0015J2\u00104\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020\u00130\u0015J*\u00106\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u00130\u0015J*\u00108\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010:\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010<\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010>\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010@\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010B\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010D\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010F\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\u00130\u0015J*\u0010G\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010I\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u00130\u0015J2\u0010K\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u00130\u0015\u00a8\u0006i"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "<init>", "()V", "isAtLeast", "", "Lcom/intellij/database/model/basic/BasicElement;", "than", "", "", "isLess", "isV2", "retrieveDatabases", "", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DbInfo;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "isNewSchema", "processUsers", "", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$UserInfo;", "processRoles", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoleInfo;", "retrieveCollations", "", "retrieveSchemas", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SchemaInfo;", "processTables", "schema", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TableInfo;", "dataTypeQueryColumns", "processColumns", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ColumnInfo;", "processIndexes", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexInfo;", "processIndexColumns", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "processConstraints", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstraintInfo;", "processCheckConstraints", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$CheckInfo;", "processForeignKeys", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyInfo;", "processKeyColumnsV2", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyColumnInfo;", "processTriggers", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TriggerInfo;", "processSequences", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceInfo;", "processDomains", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DomainInfo;", "processDomainChecks", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DomainCheckInfo;", "processRoutines", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfo;", "processRoutinesV2", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfoV2;", "processRoutineArguments", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineArgumentInfo;", "processRoutineArgumentsV2", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineArgumentInfoV2;", "processConstants", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstantInfo;", "processSynonyms", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SynonymInfo;", "processViewSources", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SourceInfo;", "processTriggerSources", "processEnumValues", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$EnumValueInfo;", "processRowFields", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RowFieldInfo;", "processArrayElements", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ArrayElementInfo;", "DbInfo", "UserInfo", "RoleInfo", "SchemaInfo", "TableInfo", "TypedObjectInfo", "ColumnInfo", "IndexInfo", "IndexColumnInfo", "ConstraintInfo", "CheckInfo", "ForeignKeyInfo", "ForeignKeyColumnInfo", "TriggerInfo", "SequenceLikeInfo", "SequenceInfo", "DomainInfo", "DomainCheckInfo", "RoutineInfo", "RoutineInfoV2", "RoutineArgumentInfo", "RoutineArgumentInfoV2", "ConstantInfo", "SynonymInfo", "SourceInfo", "EnumValueInfo", "RowFieldInfo", "ArrayElementInfo", "intellij.database.dialects.h2"})
@SourceDebugExtension(value={"SMAP\nH2IntroQueries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2IntroQueries.kt\ncom/intellij/database/dialects/h2/introspector/H2IntroQueries\n+ 2 BaseIntroQueries.kt\ncom/intellij/database/dialects/base/introspector/BaseIntroQueries\n*L\n1#1,890:1\n55#2,3:891\n24#2,2:894\n43#2:896\n24#2,2:897\n44#2:899\n43#2:900\n24#2,2:901\n44#2:903\n55#2,3:904\n24#2,2:907\n55#2,3:909\n24#2,2:912\n43#2:914\n24#2,2:915\n44#2:917\n43#2:918\n24#2,2:919\n44#2:921\n43#2:922\n24#2,2:923\n44#2:925\n43#2:926\n24#2,2:927\n44#2:929\n43#2:930\n24#2,2:931\n44#2:933\n43#2:934\n24#2,2:935\n44#2:937\n43#2:938\n24#2,2:939\n44#2:941\n43#2:942\n24#2,2:943\n44#2:945\n43#2:946\n24#2,2:947\n44#2:949\n43#2:950\n24#2,2:951\n44#2:953\n43#2:954\n24#2,2:955\n44#2:957\n43#2:958\n24#2,2:959\n44#2:961\n43#2:962\n24#2,2:963\n44#2:965\n43#2:966\n24#2,2:967\n44#2:969\n43#2:970\n24#2,2:971\n44#2:973\n43#2:974\n24#2,2:975\n44#2:977\n43#2:978\n24#2,2:979\n44#2:981\n43#2:982\n24#2,2:983\n44#2:985\n43#2:986\n24#2,2:987\n44#2:989\n43#2:990\n24#2,2:991\n44#2:993\n43#2:994\n24#2,2:995\n44#2:997\n43#2:998\n24#2,2:999\n44#2:1001\n43#2:1002\n24#2,2:1003\n44#2:1005\n43#2:1006\n24#2,2:1007\n44#2:1009\n43#2:1010\n24#2,2:1011\n44#2:1013\n43#2:1014\n24#2,2:1015\n44#2:1017\n*S KotlinDebug\n*F\n+ 1 H2IntroQueries.kt\ncom/intellij/database/dialects/h2/introspector/H2IntroQueries\n*L\n29#1:891,3\n29#1:894,2\n39#1:896\n39#1:897,2\n39#1:899\n52#1:900\n52#1:901,2\n52#1:903\n60#1:904,3\n60#1:907,2\n74#1:909,3\n74#1:912,2\n91#1:914\n91#1:915,2\n91#1:917\n197#1:918\n197#1:919,2\n197#1:921\n248#1:922\n248#1:923,2\n248#1:925\n269#1:926\n269#1:927,2\n269#1:929\n292#1:930\n292#1:931,2\n292#1:933\n306#1:934\n306#1:935,2\n306#1:937\n325#1:938\n325#1:939,2\n325#1:941\n346#1:942\n346#1:943,2\n346#1:945\n360#1:946\n360#1:947,2\n360#1:949\n381#1:950\n381#1:951,2\n381#1:953\n403#1:954\n403#1:955,2\n403#1:957\n463#1:958\n463#1:959,2\n463#1:961\n520#1:962\n520#1:963,2\n520#1:965\n534#1:966\n534#1:967,2\n534#1:969\n552#1:970\n552#1:971,2\n552#1:973\n577#1:974\n577#1:975,2\n577#1:977\n626#1:978\n626#1:979,2\n626#1:981\n665#1:982\n665#1:983,2\n665#1:985\n713#1:986\n713#1:987,2\n713#1:989\n733#1:990\n733#1:991,2\n733#1:993\n752#1:994\n752#1:995,2\n752#1:997\n769#1:998\n769#1:999,2\n769#1:1001\n778#1:1002\n778#1:1003,2\n778#1:1005\n792#1:1006\n792#1:1007,2\n792#1:1009\n837#1:1010\n837#1:1011,2\n837#1:1013\n882#1:1014\n882#1:1015,2\n882#1:1017\n*E\n"})
public final class H2IntroQueries
extends BaseIntroQueries {
    @NotNull
    public static final H2IntroQueries INSTANCE = new H2IntroQueries();

    private H2IntroQueries() {
        super(null, 1, null);
    }

    private final boolean isAtLeast(BasicElement $this$isAtLeast, int ... than) {
        Object object = DasUtil.getParentOfClass($this$isAtLeast, H2Root.class, false);
        return object != null && (object = object.getServerVersion()) != null ? ((Version)object).isOrGreater(Arrays.copyOf(than, than.length)) : false;
    }

    private final boolean isLess(BasicElement $this$isLess, int ... than) {
        Object object = DasUtil.getParentOfClass($this$isLess, H2Root.class, false);
        return object != null && (object = object.getServerVersion()) != null ? ((Version)object).less(Arrays.copyOf(than, than.length)) : false;
    }

    private final boolean isV2(BasicElement $this$isV2) {
        int[] nArray = new int[]{2};
        return this.isAtLeast($this$isV2, nArray);
    }

    @NotNull
    public final List<DbInfo> retrieveDatabases(@NotNull DBTransaction transaction, boolean isNewSchema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String query$iv = "select CATALOG_NAME from INFORMATION_SCHEMA." + (isNewSchema ? "INFORMATION_SCHEMA_CATALOG_NAME" : "CATALOGS");
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        return (List)BaseIntroQueries.access$retrieve(this, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this, DbInfo.class, expandMaps$iv$iv))), transaction, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processUsers(@NotNull DBTransaction transaction, boolean isNewSchema, @NotNull Function1<? super UserInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String name2 = isNewSchema ? "USER_NAME" : "NAME";
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "select " + name2 + " as NAME, " + (isNewSchema ? "IS_ADMIN" : "ADMIN = 'true'") + " as IS_ADMIN, REMARKS from INFORMATION_SCHEMA.USERS where TRIM(" + name2 + ") != ''";
        Object var8_8 = null;
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, UserInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoles(@NotNull DBTransaction transaction, boolean isNewSchema, @NotNull Function1<? super RoleInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "select " + (isNewSchema ? "ROLE_NAME" : "") + " NAME, REMARKS from INFORMATION_SCHEMA.ROLES";
        Object var7_7 = null;
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, RoleInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    @NotNull
    public final List<String> retrieveCollations(@NotNull DBTransaction transaction, boolean isNewSchema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String query$iv = "\n      select \n        " + (isNewSchema ? "COLLATION_NAME" : "") + " NAME \n      from INFORMATION_SCHEMA.COLLATIONS \n      where " + (isNewSchema ? "COLLATION_NAME" : "NAME") + " != ''\n    ";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        return (List)BaseIntroQueries.access$retrieve(this, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this, String.class, expandMaps$iv$iv))), transaction, parameters$iv);
    }

    @NotNull
    public final List<SchemaInfo> retrieveSchemas(@NotNull DBTransaction transaction, boolean isNewSchema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String query$iv = "\n      select\n        SCHEMA_NAME,\n       " + (isNewSchema ? " SCHEMA_NAME = current_schema" : "") + " IS_DEFAULT,\n        REMARKS\n      from INFORMATION_SCHEMA.SCHEMATA\n    ";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        return (List)BaseIntroQueries.access$retrieve(this, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this, SchemaInfo.class, expandMaps$iv$iv))), transaction, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTables(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super TableInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select\n          TABLE_NAME,\n          TABLE_TYPE = 'VIEW' as is_view,\n          STORAGE_TYPE in ('LOCAL TEMPORARY', 'GLOBAL TEMPORARY') as is_temp,\n          " + (isNewSchema ? "null" : "") + " SQL,\n          REMARKS\n        from INFORMATION_SCHEMA.TABLES\n        where TABLE_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, TableInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    private final String dataTypeQueryColumns(boolean isNewSchema) {
        return StringsKt.trimIndent((String)("\n      " + (isNewSchema ? "DATA_TYPE" : "TYPE_NAME") + " _TYPE_NAME,\n      " + (isNewSchema ? "INTERVAL_TYPE" : "null") + " _INTERVAL_TYPE,\n      " + (isNewSchema ? "COALESCE(NUMERIC_PRECISION, DATETIME_PRECISION, CHARACTER_MAXIMUM_LENGTH)" : "NUMERIC_PRECISION") + " _PRECISION,\n      NUMERIC_SCALE _SCALE,\n      " + (isNewSchema ? "INTERVAL_PRECISION" : "null") + " _INTERVAL_PRECISION,\n      " + (isNewSchema ? "GEOMETRY_TYPE" : "null") + " _GEOMETRY_TYPE,\n      " + (isNewSchema ? "GEOMETRY_SRID" : "null") + " _GEOMETRY_SRID,\n      " + (isNewSchema ? "MAXIMUM_CARDINALITY" : "null") + " _MAXIMUM_CARDINALITY,\n      " + (isNewSchema ? "DTD_IDENTIFIER" : "null") + " _DTD_IDENTIFIER\n    "));
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super ColumnInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = this.dataTypeQueryColumns(isNewSchema);
        Object object2 = new int[]{1, 4, 198};
        String string2 = this.isLess(schema, (int)object2) ? "TRUE " : (isNewSchema && this.isAtLeast(schema, (int)(object2 = new int[]{2, 0, 202})) ? " " : "IS_VISIBLE = 'TRUE' ");
        String string3 = isNewSchema ? "DOMAIN_SCHEMA" : "null";
        String string4 = isNewSchema ? "DOMAIN_NAME" : "null";
        String string5 = isNewSchema ? "COALESCE(COLUMN_DEFAULT, GENERATION_EXPRESSION)" : "";
        String string6 = isNewSchema ? "IS_GENERATED = 'ALWAYS'" : "IS_COMPUTED";
        String string7 = isNewSchema ? "" : "null";
        if (isNewSchema) {
            object = "";
        } else {
            object2 = new int[]{1, 4, 197};
            object = "\n          SEQUENCE_NAME,\n          " + (this.isAtLeast(schema, (int)object2) ? "COLUMN_TYPE" : "null") + " _COLUMN_TYPE,\n          ";
        }
        object2 = "\n        select\n          TABLE_NAME,\n          COLUMN_NAME,\n          ORDINAL_POSITION,\n          " + string + ",\n          " + string2 + " IS_VISIBLE,\n          " + string3 + " _DOMAIN_SCHEMA,\n          " + string4 + " _DOMAIN_NAME,\n          " + string5 + " COLUMN_DEFAULT,\n          " + string6 + " as IS_GENERATED,\n          " + string7 + " COLUMN_ON_UPDATE,\n          IS_NULLABLE = 'YES' as is_nullable,\n          " + (String)object + "\n          " + (isNewSchema ? "IS_IDENTITY = 'YES'" : "SEQUENCE_NAME IS NOT NULL") + " IS_IDENTITY,\n          " + (isNewSchema ? "\n            IDENTITY_GENERATION, \n            IDENTITY_START,\n            IDENTITY_INCREMENT,\n            IDENTITY_MAXIMUM,\n            IDENTITY_MINIMUM,\n            IDENTITY_CYCLE = 'YES' as IDENTITY_CYCLED,\n            IDENTITY_BASE,\n            IDENTITY_CACHE,\n            " : "") + "\n          REMARKS\n        from INFORMATION_SCHEMA.COLUMNS\n        where TABLE_SCHEMA = ?\n        order by TABLE_NAME, ORDINAL_POSITION\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, ColumnInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndexes(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super IndexInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n      select \n          TABLE_NAME,\n          INDEX_NAME,\n          " + (isNewSchema ? "not (INDEX_TYPE_NAME like 'PRIMARY %' or INDEX_TYPE_NAME like 'UNIQUE %')" : "") + " NON_UNIQUE,\n          IS_GENERATED,\n          " + (isNewSchema ? "null" : "") + " SQL,\n          REMARKS \n      from INFORMATION_SCHEMA.INDEXES \n      where TABLE_SCHEMA = ?\n      order by TABLE_NAME\n    ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, IndexInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndexColumns(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super IndexColumnInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            TABLE_NAME,\n            INDEX_NAME,\n            COLUMN_NAME,\n            " + (isNewSchema ? "ORDERING_SPECIFICATION = 'DESC'" : "ASC_OR_DESC = 'D'") + " as is_desc\n        from INFORMATION_SCHEMA." + (isNewSchema ? "INDEX_COLUMNS" : "INDEXES") + " \n        where TABLE_SCHEMA = ?\n        order by TABLE_NAME, INDEX_NAME, ORDINAL_POSITION\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, IndexColumnInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    public final void processConstraints(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super ConstraintInfo, Unit> action) {
        Object[] parameters$iv;
        DBTransaction $this$processList$iv;
        String query$iv;
        BaseIntroQueries this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            TABLE_NAME,\n            CONSTRAINT_NAME,\n            CONSTRAINT_TYPE,\n            " + (isNewSchema ? "INDEX_NAME" : "CHECK_EXPRESSION,\n            COLUMN_LIST,\n            ") + " UNIQUE_INDEX_NAME,\n            REMARKS\n        from INFORMATION_SCHEMA." + (isNewSchema ? "TABLE_CONSTRAINTS" : "CONSTRAINTS") + " \n        where TABLE_SCHEMA = ?\n        order by TABLE_NAME\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList(this_$iv, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this_$iv, ConstraintInfo.class, expandMaps$iv$iv))), $this$processList$iv, parameters$iv, null, null, action);
        if (!isNewSchema) {
            this_$iv = this;
            $this$processList$iv = transaction;
            query$iv = "\n        select\n          TABLE_NAME,\n          'CHECK' CONSTRAINT_TYPE,\n          CHECK_CONSTRAINT CHECK_EXPRESSION,\n          COLUMN_NAME COLUMN_LIST\n        from INFORMATION_SCHEMA.COLUMNS\n        where TABLE_SCHEMA = ? and CHECK_CONSTRAINT != ''\n        order by TABLE_NAME\n      ";
            parameters$iv = new String[]{schema.getName()};
            $i$f$processList = false;
            expandMaps$iv$iv = false;
            $i$f$listQuery = false;
            BaseIntroQueries.access$processList(this_$iv, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this_$iv, ConstraintInfo.class, expandMaps$iv$iv))), $this$processList$iv, parameters$iv, null, null, action);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processCheckConstraints(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super CheckInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            CONSTRAINT_NAME,\n            CHECK_CLAUSE\n        from INFORMATION_SCHEMA.CHECK_CONSTRAINTS \n        where CONSTRAINT_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, CheckInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processForeignKeys(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super ForeignKeyInfo, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (isNewSchema) {
            void parameters$iv;
            void $this$processList$iv;
            void query$iv;
            void this_$iv;
            BaseIntroQueries baseIntroQueries = this;
            DBTransaction dBTransaction = transaction;
            String string = "\n        select \n            TABLE_NAME FKTABLE_NAME,\n            REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME FK_NAME,\n            UNIQUE_CONSTRAINT_NAME PK_NAME,\n            UNIQUE_CONSTRAINT_SCHEMA PKTABLE_SCHEMA,\n            null PKTABLE_NAME,\n            UPDATE_RULE,\n            DELETE_RULE\n        from INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS natural join INFORMATION_SCHEMA.TABLE_CONSTRAINTS \n        where REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA = ?\n      ";
            String[] stringArray = new String[]{schema.getName()};
            boolean $i$f$processList = false;
            boolean expandMaps$iv$iv = false;
            boolean $i$f$listQuery = false;
            BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, ForeignKeyInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
        } else {
            BaseIntroQueries this_$iv = this;
            DBTransaction $this$processList$iv = transaction;
            String query$iv = "\n        select \n            FKTABLE_NAME,\n            FK_NAME,\n            PK_NAME,\n            PKTABLE_SCHEMA,\n            PKTABLE_NAME,\n            UPDATE_RULE,\n            DELETE_RULE\n        from INFORMATION_SCHEMA.CROSS_REFERENCES C  \n        where FKTABLE_SCHEMA = ? and C.ORDINAL_POSITION = 1\n      ";
            Object[] parameters$iv = new String[]{schema.getName()};
            boolean $i$f$processList = false;
            boolean expandMaps$iv$iv = false;
            boolean $i$f$listQuery = false;
            BaseIntroQueries.access$processList(this_$iv, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this_$iv, ForeignKeyInfo.class, expandMaps$iv$iv))), $this$processList$iv, parameters$iv, null, null, action);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processKeyColumnsV2(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super ForeignKeyColumnInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            CONSTRAINT_NAME,\n            COLUMN_NAME            \n        from INFORMATION_SCHEMA.KEY_COLUMN_USAGE\n        where CONSTRAINT_SCHEMA = ?\n        order by ORDINAL_POSITION\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, ForeignKeyColumnInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTriggers(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super TriggerInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            TRIGGER_SCHEMA,\n            TRIGGER_NAME,\n            " + (isNewSchema ? "EVENT_OBJECT_TABLE" : "") + " TABLE_NAME,\n            " + (isNewSchema ? "EVENT_MANIPULATION" : "") + " TRIGGER_TYPE,\n            " + (isNewSchema ? "" : "case when BEFORE then 'BEFORE' else 'AFTER' end") + " ACTION_TIMING, //todo: supports INSTEAD, but need to parse src for 1.4\n            " + (isNewSchema ? "" : "'STATEMENT'") + " ACTION_ORIENTATION, //todo: supports ROW, but need to parse src for 1.4\n            " + (isNewSchema ? "null" : "") + " SQL,\n            REMARKS \n        from INFORMATION_SCHEMA.TRIGGERS \n        where " + (isNewSchema ? "EVENT_OBJECT_SCHEMA" : "TABLE_SCHEMA") + " = ?\n        order by " + (isNewSchema ? "EVENT_OBJECT_TABLE" : "TABLE_NAME") + "\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, TriggerInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processSequences(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super SequenceInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            SEQUENCE_NAME,\n            " + (this.isV2(schema) ? "\n              DATA_TYPE _SEQ_TYPE_NAME,\n              NUMERIC_PRECISION _SEQ_NUMERIC_PRECISION,\n              NUMERIC_SCALE _SEQ_NUMERIC_SCALE,\n            " : "") + "\n            " + (isNewSchema ? "START_VALUE _START_VALUE," : "") + "\n            " + (isNewSchema ? "BASE_VALUE _NEXT_VALUE" : "CURRENT_VALUE _LAST_VALUE") + ",\n            INCREMENT _INCREMENT,\n            " + (isNewSchema ? "false" : "") + " IS_GENERATED,\n            CACHE _CACHE,\n            " + (isNewSchema ? "MINIMUM_VALUE" : "MIN_VALUE") + " _MIN_VALUE,\n            " + (isNewSchema ? "MAXIMUM_VALUE" : "MAX_VALUE") + " _MAX_VALUE,\n            " + (isNewSchema ? "CYCLE_OPTION = 'YES'" : "IS_CYCLE") + " _IS_CYCLE,\n            REMARKS\n        from INFORMATION_SCHEMA.SEQUENCES \n        where SEQUENCE_SCHEMA = ? " + (isNewSchema ? "" : " ORDER BY ID") + "\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, SequenceInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processDomains(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super DomainInfo, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (isNewSchema) {
            void parameters$iv;
            void $this$processList$iv;
            void query$iv;
            void this_$iv;
            BaseIntroQueries baseIntroQueries = this;
            DBTransaction dBTransaction = transaction;
            String string = "\n        select \n            DOMAIN_NAME NAME,\n            " + this.dataTypeQueryColumns(true) + ",\n            PARENT_DOMAIN_SCHEMA _DOMAIN_SCHEMA,\n            PARENT_DOMAIN_NAME _DOMAIN_NAME,\n            DOMAIN_DEFAULT,\n            DOMAIN_ON_UPDATE,\n            REMARKS\n        from INFORMATION_SCHEMA.DOMAINS\n        where DOMAIN_SCHEMA = ?\n      ";
            String[] stringArray = new String[]{schema.getName()};
            boolean $i$f$processList = false;
            boolean expandMaps$iv$iv = false;
            boolean $i$f$listQuery = false;
            BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, DomainInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
        } else {
            BaseIntroQueries this_$iv = this;
            DBTransaction $this$processList$iv = transaction;
            String query$iv = "\n        select \n            DOMAIN_NAME NAME,\n            SQL,\n            REMARKS\n        from INFORMATION_SCHEMA.DOMAINS \n        where DOMAIN_SCHEMA = ?\n      ";
            Object[] parameters$iv = new String[]{schema.getName()};
            boolean $i$f$processList = false;
            boolean expandMaps$iv$iv = false;
            boolean $i$f$listQuery = false;
            BaseIntroQueries.access$processList(this_$iv, new SqlQuery(query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout(this_$iv, DomainInfo.class, expandMaps$iv$iv))), $this$processList$iv, parameters$iv, null, null, action);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processDomainChecks(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super DomainCheckInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            DC.DOMAIN_NAME DOMAIN_NAME,\n            DC.CONSTRAINT_NAME CONSTRAINT_NAME,\n            CC.CHECK_CLAUSE CHECK_CLAUSE\n        from INFORMATION_SCHEMA.DOMAIN_CONSTRAINTS DC \n            join INFORMATION_SCHEMA.CHECK_CONSTRAINTS CC \n                on CC.CONSTRAINT_SCHEMA = DC.CONSTRAINT_SCHEMA and CC.CONSTRAINT_NAME = DC.CONSTRAINT_NAME\n        where DC.DOMAIN_SCHEMA = ?\n        order by DC.DOMAIN_NAME\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, DomainCheckInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutines(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super RoutineInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            ALIAS_NAME,\n            COLUMN_COUNT,\n            JAVA_CLASS,\n            JAVA_METHOD,\n            SOURCE,\n            DATA_TYPE != 0 as IS_FUNC,\n            REMARKS\n        from INFORMATION_SCHEMA.FUNCTION_ALIASES \n        where ALIAS_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, RoutineInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutinesV2(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super RoutineInfoV2, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            ROUTINE_NAME,\n            SPECIFIC_NAME,\n            EXTERNAL_NAME,\n            ROUTINE_DEFINITION,\n            ROUTINE_TYPE,\n            " + this.dataTypeQueryColumns(isNewSchema) + ",\n            REMARKS\n        from INFORMATION_SCHEMA.ROUTINES \n        where ROUTINE_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, RoutineInfoV2.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutineArguments(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super RoutineArgumentInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            ALIAS_NAME,\n            COLUMN_COUNT,\n            COLUMN_NAME,\n            POS,\n            TYPE_NAME _TYPE_NAME,\n            PRECISION _PRECISION,\n            SCALE _SCALE,\n            COLUMN_TYPE _COLUMN_TYPE\n        from INFORMATION_SCHEMA.FUNCTION_COLUMNS \n        where ALIAS_SCHEMA = ?\n        order by ALIAS_NAME, COLUMN_COUNT, POS\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, RoutineArgumentInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutineArgumentsV2(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super RoutineArgumentInfoV2, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            SPECIFIC_NAME,\n            PARAMETER_NAME,\n            ORDINAL_POSITION,\n            " + this.dataTypeQueryColumns(isNewSchema) + "\n        from INFORMATION_SCHEMA.PARAMETERS \n        where SPECIFIC_SCHEMA = ?\n        order by SPECIFIC_NAME, ORDINAL_POSITION\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, RoutineArgumentInfoV2.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processConstants(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super ConstantInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            CONSTANT_NAME,\n            DATA_TYPE,\n            " + (isNewSchema ? "VALUE_DEFINITION" : "") + " SQL,\n            REMARKS\n        from INFORMATION_SCHEMA.CONSTANTS \n        where CONSTANT_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, ConstantInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processSynonyms(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super SynonymInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select \n            SYNONYM_NAME,\n            SYNONYM_FOR_SCHEMA,\n            SYNONYM_FOR,\n            REMARKS\n        from INFORMATION_SCHEMA.SYNONYMS \n        where SYNONYM_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, SynonymInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processViewSources(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super SourceInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n      SELECT \n        TABLE_NAME AS NAME, \n        DB_OBJECT_SQL('TABLE', ?, TABLE_NAME) AS SQL \n      FROM INFORMATION_SCHEMA.VIEWS\n    ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, SourceInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTriggerSources(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super SourceInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n      SELECT \n        TRIGGER_NAME AS NAME, \n        DB_OBJECT_SQL('TRIGGER', ?, TRIGGER_NAME) AS SQL \n      FROM INFORMATION_SCHEMA.TRIGGERS\n    ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, SourceInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processEnumValues(@NotNull DBTransaction transaction, @NotNull H2Schema schema, @NotNull Function1<? super EnumValueInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        SELECT \n            ENUM_IDENTIFIER,\n            ARRAY_AGG('''' || VALUE_NAME || '''' ORDER BY VALUE_ORDINAL) ENUM_VALUES\n        FROM INFORMATION_SCHEMA.ENUM_VALUES \n        WHERE OBJECT_SCHEMA = ?\n        GROUP BY ENUM_IDENTIFIER\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, EnumValueInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRowFields(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super RowFieldInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select\n          ROW_IDENTIFIER,\n          FIELD_NAME,\n          ORDINAL_POSITION,\n          " + this.dataTypeQueryColumns(isNewSchema) + "\n        from INFORMATION_SCHEMA.FIELDS\n        where OBJECT_SCHEMA = ?\n        order by ORDINAL_POSITION\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, RowFieldInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processArrayElements(@NotNull DBTransaction transaction, @NotNull H2Schema schema, boolean isNewSchema, @NotNull Function1<? super ArrayElementInfo, Unit> action) {
        void parameters$iv;
        void $this$processList$iv;
        void query$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BaseIntroQueries baseIntroQueries = this;
        DBTransaction dBTransaction = transaction;
        String string = "\n        select\n          COLLECTION_TYPE_IDENTIFIER,\n          " + this.dataTypeQueryColumns(isNewSchema) + "\n        from INFORMATION_SCHEMA.ELEMENT_TYPES\n        where OBJECT_SCHEMA = ?\n      ";
        String[] stringArray = new String[]{schema.getName()};
        boolean $i$f$processList = false;
        boolean expandMaps$iv$iv = false;
        boolean $i$f$listQuery = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, new SqlQuery((String)query$iv, Layouts.listOf((RowLayout)BaseIntroQueries.access$rowLayout((BaseIntroQueries)this_$iv, ArrayElementInfo.class, expandMaps$iv$iv))), (DBTransaction)$this$processList$iv, (Object[])parameters$iv, null, null, action);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0012\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010,R\u0014\u0010.\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ArrayElementInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "collection_type_identifier", "_type_name", "_interval_type", "_precision", "_interval_precision", "_scale", "_column_type", "_geometry_type", "_geometry_srid", "Ljava/lang/Integer;", "_maximum_cardinality", "_dtd_identifier", "intellij.database.dialects.h2"})
    public static final class ArrayElementInfo
    implements TypedObjectInfo {
        @JvmField
        @NotNull
        public String collection_type_identifier = "";
        @JvmField
        @Nullable
        public String _type_name;
        @JvmField
        @Nullable
        public String _interval_type;
        @JvmField
        public long _precision;
        @JvmField
        public int _interval_precision;
        @JvmField
        public int _scale;
        @JvmField
        @Nullable
        public String _column_type;
        @JvmField
        @Nullable
        public String _geometry_type;
        @JvmField
        @Nullable
        public Integer _geometry_srid;
        @JvmField
        @Nullable
        public Integer _maximum_cardinality;
        @JvmField
        @Nullable
        public String _dtd_identifier;

        @Override
        @Nullable
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return this._interval_type;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._interval_precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return this._column_type;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return this._geometry_type;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return this._geometry_srid;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return this._maximum_cardinality;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return null;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return null;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return this._dtd_identifier;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$CheckInfo;", "", "<init>", "()V", "constraint_name", "", "check_clause", "intellij.database.dialects.h2"})
    public static final class CheckInfo {
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @NotNull
        public String check_clause = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b)\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u001f\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u0016\u0010 \u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\bR\u0016\u0010\"\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\bR\u0016\u0010$\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\bR\u0014\u0010&\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0012R\u0014\u0010(\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u0016\u0010*\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010-\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u0016\u0010/\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010,R\u0014\u00101\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010,R\u0014\u00103\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010,R\u0014\u00105\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010,R\u0014\u00107\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u000eR\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010;R\u0012\u0010<\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010=\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010>\u001a\u00020?8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010B\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010C\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010D\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010F\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010G\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010HR\u0016\u0010I\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010HR\u0014\u0010J\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010K\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010L\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010M\u001a\u00020:8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010N\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010P\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Q\u001a\u00020:8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010R\u001a\u00020:8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010S\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010T\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010UR\u0016\u0010V\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010UR\u0012\u0010W\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010X\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Y\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Z\u001a\u00020:8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010[\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\\\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010]\u001a\u00020:8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ColumnInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceLikeInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "seq_type_name", "getSeq_type_name", "seq_numeric_precision", "getSeq_numeric_precision", "seq_numeric_scale", "getSeq_numeric_scale", "start_value", "getStart_value", "()Ljava/lang/Long;", "last_value", "getLast_value", "next_value", "getNext_value", "increment", "getIncrement", "min_value", "getMin_value", "max_value", "getMax_value", "cache", "getCache", "is_cycle", "", "()Z", "table_name", "column_name", "ordinal_position", "", "_type_name", "_interval_type", "_precision", "_interval_precision", "_scale", "_column_type", "_geometry_type", "_geometry_srid", "Ljava/lang/Integer;", "_maximum_cardinality", "_domain_schema", "_domain_name", "_dtd_identifier", "is_nullable", "column_default", "column_on_update", "sequence_name", "is_generated", "is_identity", "identity_generation", "identity_start", "Ljava/lang/Long;", "identity_base", "identity_increment", "identity_maximum", "identity_minimum", "identity_cycled", "identity_cache", "remarks", "is_visible", "intellij.database.dialects.h2"})
    public static final class ColumnInfo
    implements TypedObjectInfo,
    SequenceLikeInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        public short ordinal_position;
        @JvmField
        @Nullable
        public String _type_name;
        @JvmField
        @Nullable
        public String _interval_type;
        @JvmField
        public long _precision;
        @JvmField
        public int _interval_precision;
        @JvmField
        public int _scale;
        @JvmField
        @Nullable
        public String _column_type;
        @JvmField
        @Nullable
        public String _geometry_type;
        @JvmField
        @Nullable
        public Integer _geometry_srid;
        @JvmField
        @Nullable
        public Integer _maximum_cardinality;
        @JvmField
        @Nullable
        public String _domain_schema;
        @JvmField
        @Nullable
        public String _domain_name;
        @JvmField
        @Nullable
        public String _dtd_identifier;
        @JvmField
        public boolean is_nullable = true;
        @JvmField
        @Nullable
        public String column_default;
        @JvmField
        @Nullable
        public String column_on_update;
        @JvmField
        @Nullable
        public String sequence_name;
        @JvmField
        public boolean is_generated;
        @JvmField
        public boolean is_identity;
        @JvmField
        @NotNull
        public String identity_generation = "";
        @JvmField
        @Nullable
        public Long identity_start;
        @JvmField
        @Nullable
        public Long identity_base;
        @JvmField
        public long identity_increment;
        @JvmField
        public long identity_maximum;
        @JvmField
        public long identity_minimum;
        @JvmField
        public boolean identity_cycled;
        @JvmField
        public long identity_cache;
        @JvmField
        @Nullable
        public String remarks;
        @JvmField
        public boolean is_visible = true;

        @Override
        @Nullable
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return this._interval_type;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._interval_precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return this._column_type;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return this._geometry_type;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return this._geometry_srid;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return this._maximum_cardinality;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return this._domain_schema;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return this._domain_name;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return this._dtd_identifier;
        }

        @Override
        @Nullable
        public String getSeq_type_name() {
            return this._type_name;
        }

        @Override
        public int getSeq_numeric_precision() {
            return (int)this._precision;
        }

        @Override
        public int getSeq_numeric_scale() {
            return this._scale;
        }

        @Override
        @Nullable
        public Long getStart_value() {
            return this.identity_start;
        }

        @Override
        @Nullable
        public Long getLast_value() {
            return null;
        }

        @Override
        @Nullable
        public Long getNext_value() {
            return this.identity_base;
        }

        @Override
        @NotNull
        public Long getIncrement() {
            return this.identity_increment;
        }

        @Override
        @NotNull
        public Long getMin_value() {
            return this.identity_minimum;
        }

        @Override
        @NotNull
        public Long getMax_value() {
            return this.identity_maximum;
        }

        @Override
        public long getCache() {
            return this.identity_cache;
        }

        @Override
        public boolean is_cycle() {
            return this.identity_cycled;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstantInfo;", "", "<init>", "()V", "constant_name", "", "data_type", "sql", "remarks", "intellij.database.dialects.h2"})
    public static final class ConstantInfo {
        @JvmField
        @NotNull
        public String constant_name = "";
        @JvmField
        @NotNull
        public String data_type = "";
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ConstraintInfo;", "", "<init>", "()V", "table_name", "", "constraint_name", "constraint_type", "check_expression", "column_list", "unique_index_name", "remarks", "intellij.database.dialects.h2"})
    public static final class ConstraintInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @NotNull
        public String constraint_type = "";
        @JvmField
        @Nullable
        public String check_expression;
        @JvmField
        @Nullable
        public String column_list;
        @JvmField
        @Nullable
        public String unique_index_name;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DbInfo;", "", "<init>", "()V", "catalog_name", "", "intellij.database.dialects.h2"})
    public static final class DbInfo {
        @JvmField
        @Nullable
        public String catalog_name;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DomainCheckInfo;", "", "<init>", "()V", "domain_name", "", "constraint_name", "check_clause", "intellij.database.dialects.h2"})
    public static final class DomainCheckInfo {
        @JvmField
        @NotNull
        public String domain_name = "";
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @Nullable
        public String check_clause;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0014\u0010#\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u0016\u0010,\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010+R\u0014\u0010-\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00100\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$DomainInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "_type_name", "_interval_type", "_precision", "_interval_precision", "_scale", "_column_type", "_geometry_type", "_geometry_srid", "Ljava/lang/Integer;", "_maximum_cardinality", "_dtd_identifier", "_domain_schema", "_domain_name", "name", "domain_default", "domain_on_update", "sql", "remarks", "intellij.database.dialects.h2"})
    public static final class DomainInfo
    implements TypedObjectInfo {
        @JvmField
        @Nullable
        public String _type_name;
        @JvmField
        @Nullable
        public String _interval_type;
        @JvmField
        public long _precision;
        @JvmField
        public int _interval_precision;
        @JvmField
        public int _scale;
        @JvmField
        @Nullable
        public String _column_type;
        @JvmField
        @Nullable
        public String _geometry_type;
        @JvmField
        @Nullable
        public Integer _geometry_srid;
        @JvmField
        @Nullable
        public Integer _maximum_cardinality;
        @JvmField
        @Nullable
        public String _dtd_identifier;
        @JvmField
        @Nullable
        public String _domain_schema;
        @JvmField
        @Nullable
        public String _domain_name;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String domain_default;
        @JvmField
        @Nullable
        public String domain_on_update;
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;

        @Override
        @Nullable
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return this._interval_type;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._interval_precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return this._column_type;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return this._geometry_type;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return this._geometry_srid;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return this._maximum_cardinality;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return this._domain_schema;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return this._domain_name;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return this._dtd_identifier;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$EnumValueInfo;", "", "<init>", "()V", "enum_identifier", "", "enum_values", "", "[Ljava/lang/String;", "intellij.database.dialects.h2"})
    public static final class EnumValueInfo {
        @JvmField
        @NotNull
        public String enum_identifier = "";
        @JvmField
        @NotNull
        public String[] enum_values;

        public EnumValueInfo() {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            this.enum_values = ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyColumnInfo;", "", "<init>", "()V", "constraint_name", "", "column_name", "intellij.database.dialects.h2"})
    public static final class ForeignKeyColumnInfo {
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @NotNull
        public String column_name = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ForeignKeyInfo;", "", "<init>", "()V", "fktable_name", "", "fk_name", "pk_name", "pktable_schema", "pktable_name", "update_rule", "delete_rule", "intellij.database.dialects.h2"})
    public static final class ForeignKeyInfo {
        @JvmField
        @NotNull
        public String fktable_name = "";
        @JvmField
        @NotNull
        public String fk_name = "";
        @JvmField
        @NotNull
        public String pk_name = "";
        @JvmField
        @NotNull
        public String pktable_schema = "";
        @JvmField
        @NotNull
        public String pktable_name = "";
        @JvmField
        @NotNull
        public String update_rule = "";
        @JvmField
        @NotNull
        public String delete_rule = "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "", "<init>", "()V", "table_name", "", "index_name", "column_name", "is_desc", "", "intellij.database.dialects.h2"})
    public static final class IndexColumnInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String index_name = "";
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        public boolean is_desc;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexInfo;", "", "<init>", "()V", "table_name", "", "index_name", "non_unique", "", "is_generated", "sql", "remarks", "intellij.database.dialects.h2"})
    public static final class IndexInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String index_name = "";
        @JvmField
        public boolean non_unique;
        @JvmField
        public boolean is_generated;
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoleInfo;", "", "<init>", "()V", "name", "", "remarks", "intellij.database.dialects.h2"})
    public static final class RoleInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0012\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020'8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineArgumentInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "alias_name", "column_count", "column_name", "pos", "", "_type_name", "_precision", "_scale", "_column_type", "intellij.database.dialects.h2"})
    public static final class RoutineArgumentInfo
    implements TypedObjectInfo {
        @JvmField
        @NotNull
        public String alias_name = "";
        @JvmField
        public int column_count;
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        public short pos;
        @JvmField
        @NotNull
        public String _type_name = "";
        @JvmField
        public int _precision;
        @JvmField
        public int _scale;
        @JvmField
        public int _column_type;

        @Override
        @NotNull
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return null;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return null;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return null;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return null;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return null;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return null;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return null;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\n\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0012\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0016\u00100\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010/R\u0014\u00101\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineArgumentInfoV2;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "specific_name", "parameter_name", "ordinal_position", "", "_type_name", "_interval_type", "_precision", "_interval_precision", "_scale", "_column_type", "_geometry_type", "_geometry_srid", "Ljava/lang/Integer;", "_maximum_cardinality", "_domain_schema", "_domain_name", "_dtd_identifier", "intellij.database.dialects.h2"})
    public static final class RoutineArgumentInfoV2
    implements TypedObjectInfo {
        @JvmField
        @NotNull
        public String specific_name = "";
        @JvmField
        @NotNull
        public String parameter_name = "";
        @JvmField
        public short ordinal_position;
        @JvmField
        @Nullable
        public String _type_name;
        @JvmField
        @Nullable
        public String _interval_type;
        @JvmField
        public long _precision;
        @JvmField
        public int _interval_precision;
        @JvmField
        public int _scale;
        @JvmField
        @Nullable
        public String _column_type;
        @JvmField
        @Nullable
        public String _geometry_type;
        @JvmField
        @Nullable
        public Integer _geometry_srid;
        @JvmField
        @Nullable
        public Integer _maximum_cardinality;
        @JvmField
        @Nullable
        public String _domain_schema;
        @JvmField
        @Nullable
        public String _domain_name;
        @JvmField
        @Nullable
        public String _dtd_identifier;

        @Override
        @Nullable
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return this._interval_type;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._interval_precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return this._column_type;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return this._geometry_type;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return this._geometry_srid;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return this._maximum_cardinality;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return this._domain_schema;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return this._domain_name;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return this._dtd_identifier;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfo;", "", "<init>", "()V", "alias_name", "", "column_count", "", "java_class", "java_method", "source", "is_func", "", "routine_type", "remarks", "intellij.database.dialects.h2"})
    public static final class RoutineInfo {
        @JvmField
        @NotNull
        public String alias_name = "";
        @JvmField
        public int column_count;
        @JvmField
        @Nullable
        public String java_class;
        @JvmField
        @Nullable
        public String java_method;
        @JvmField
        @Nullable
        public String source;
        @JvmField
        public boolean is_func;
        @JvmField
        @Nullable
        public String routine_type;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0012\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u00101R\u0016\u00102\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u00101R\u0014\u00103\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfoV2;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "routine_name", "specific_name", "external_name", "routine_definition", "routine_type", "remarks", "_type_name", "_interval_type", "_precision", "_interval_precision", "_scale", "_column_type", "_geometry_type", "_geometry_srid", "Ljava/lang/Integer;", "_maximum_cardinality", "_domain_schema", "_domain_name", "_dtd_identifier", "intellij.database.dialects.h2"})
    public static final class RoutineInfoV2
    implements TypedObjectInfo {
        @JvmField
        @NotNull
        public String routine_name = "";
        @JvmField
        @Nullable
        public String specific_name;
        @JvmField
        @Nullable
        public String external_name;
        @JvmField
        @Nullable
        public String routine_definition;
        @JvmField
        @Nullable
        public String routine_type;
        @JvmField
        @Nullable
        public String remarks;
        @JvmField
        @Nullable
        public String _type_name;
        @JvmField
        @Nullable
        public String _interval_type;
        @JvmField
        public long _precision;
        @JvmField
        public int _interval_precision;
        @JvmField
        public int _scale;
        @JvmField
        @Nullable
        public String _column_type;
        @JvmField
        @Nullable
        public String _geometry_type;
        @JvmField
        @Nullable
        public Integer _geometry_srid;
        @JvmField
        @Nullable
        public Integer _maximum_cardinality;
        @JvmField
        @Nullable
        public String _domain_schema;
        @JvmField
        @Nullable
        public String _domain_name;
        @JvmField
        @Nullable
        public String _dtd_identifier;

        @Override
        @Nullable
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return this._interval_type;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._interval_precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return this._column_type;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return this._geometry_type;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return this._geometry_srid;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return this._maximum_cardinality;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return this._domain_schema;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return this._domain_name;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return this._dtd_identifier;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0016\u0010!\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0007R\u0012\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010)\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010.R\u0016\u0010/\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010.R\u0014\u00100\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RowFieldInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "<init>", "()V", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "row_identifier", "field_name", "ordinal_position", "_type_name", "_interval_type", "_precision", "_interval_precision", "_scale", "_column_type", "_geometry_type", "_geometry_srid", "Ljava/lang/Integer;", "_maximum_cardinality", "_dtd_identifier", "intellij.database.dialects.h2"})
    public static final class RowFieldInfo
    implements TypedObjectInfo {
        @JvmField
        @NotNull
        public String row_identifier = "";
        @JvmField
        @NotNull
        public String field_name = "";
        @JvmField
        public int ordinal_position;
        @JvmField
        @Nullable
        public String _type_name;
        @JvmField
        @Nullable
        public String _interval_type;
        @JvmField
        public long _precision;
        @JvmField
        public int _interval_precision;
        @JvmField
        public int _scale;
        @JvmField
        @Nullable
        public String _column_type;
        @JvmField
        @Nullable
        public String _geometry_type;
        @JvmField
        @Nullable
        public Integer _geometry_srid;
        @JvmField
        @Nullable
        public Integer _maximum_cardinality;
        @JvmField
        @Nullable
        public String _dtd_identifier;

        @Override
        @Nullable
        public String getType_name() {
            return this._type_name;
        }

        @Override
        @Nullable
        public String getInterval_type() {
            return this._interval_type;
        }

        @Override
        public long getPrecision() {
            return this._precision;
        }

        @Override
        public int getInterval_precision() {
            return this._interval_precision;
        }

        @Override
        public int getScale() {
            return this._scale;
        }

        @Override
        @Nullable
        public String getColumn_type() {
            return this._column_type;
        }

        @Override
        @Nullable
        public String getGeometry_type() {
            return this._geometry_type;
        }

        @Override
        @Nullable
        public Integer getGeometry_srid() {
            return this._geometry_srid;
        }

        @Override
        @Nullable
        public Integer getMaximum_cardinality() {
            return this._maximum_cardinality;
        }

        @Override
        @Nullable
        public String getDomain_schema() {
            return null;
        }

        @Override
        @Nullable
        public String getDomain_name() {
            return null;
        }

        @Override
        @Nullable
        public String getDtd_identifier() {
            return this._dtd_identifier;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SchemaInfo;", "", "<init>", "()V", "schema_name", "", "is_default", "", "remarks", "intellij.database.dialects.h2"})
    public static final class SchemaInfo {
        @JvmField
        @NotNull
        public String schema_name = "";
        @JvmField
        public boolean is_default;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0012\u0010\"\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0016\u0010)\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0016\u0010*\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0016\u0010+\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0016\u0010,\u001a\u0004\u0018\u00010\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0012\u0010-\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010.\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceInfo;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceLikeInfo;", "<init>", "()V", "seq_type_name", "", "getSeq_type_name", "()Ljava/lang/String;", "seq_numeric_precision", "", "getSeq_numeric_precision", "()I", "seq_numeric_scale", "getSeq_numeric_scale", "start_value", "", "getStart_value", "()Ljava/lang/Long;", "last_value", "getLast_value", "next_value", "getNext_value", "increment", "getIncrement", "min_value", "getMin_value", "max_value", "getMax_value", "cache", "getCache", "()J", "is_cycle", "", "()Z", "sequence_name", "_seq_type_name", "_seq_numeric_precision", "_seq_numeric_scale", "_start_value", "Ljava/lang/Long;", "_last_value", "_next_value", "_increment", "_min_value", "_max_value", "is_generated", "_cache", "_is_cycle", "remarks", "intellij.database.dialects.h2"})
    public static final class SequenceInfo
    implements SequenceLikeInfo {
        @JvmField
        @NotNull
        public String sequence_name = "";
        @JvmField
        @NotNull
        public String _seq_type_name = "";
        @JvmField
        public int _seq_numeric_precision;
        @JvmField
        public int _seq_numeric_scale;
        @JvmField
        @Nullable
        public Long _start_value;
        @JvmField
        @Nullable
        public Long _last_value;
        @JvmField
        @Nullable
        public Long _next_value;
        @JvmField
        @Nullable
        public Long _increment;
        @JvmField
        @Nullable
        public Long _min_value;
        @JvmField
        @Nullable
        public Long _max_value;
        @JvmField
        public boolean is_generated;
        @JvmField
        public long _cache;
        @JvmField
        public boolean _is_cycle;
        @JvmField
        @Nullable
        public String remarks;

        @Override
        @NotNull
        public String getSeq_type_name() {
            return this._seq_type_name;
        }

        @Override
        public int getSeq_numeric_precision() {
            return this._seq_numeric_precision;
        }

        @Override
        public int getSeq_numeric_scale() {
            return this._seq_numeric_scale;
        }

        @Override
        @Nullable
        public Long getStart_value() {
            return this._start_value;
        }

        @Override
        @Nullable
        public Long getLast_value() {
            return this._last_value;
        }

        @Override
        @Nullable
        public Long getNext_value() {
            return this._next_value;
        }

        @Override
        @Nullable
        public Long getIncrement() {
            return this._increment;
        }

        @Override
        @Nullable
        public Long getMin_value() {
            return this._min_value;
        }

        @Override
        @Nullable
        public Long getMax_value() {
            return this._max_value;
        }

        @Override
        public long getCache() {
            return this._cache;
        }

        @Override
        public boolean is_cycle() {
            return this._is_cycle;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceLikeInfo;", "", "seq_type_name", "", "getSeq_type_name", "()Ljava/lang/String;", "seq_numeric_precision", "", "getSeq_numeric_precision", "()I", "seq_numeric_scale", "getSeq_numeric_scale", "start_value", "", "getStart_value", "()Ljava/lang/Long;", "last_value", "getLast_value", "next_value", "getNext_value", "increment", "getIncrement", "min_value", "getMin_value", "max_value", "getMax_value", "cache", "getCache", "()J", "is_cycle", "", "()Z", "intellij.database.dialects.h2"})
    public static interface SequenceLikeInfo {
        @Nullable
        public String getSeq_type_name();

        public int getSeq_numeric_precision();

        public int getSeq_numeric_scale();

        @Nullable
        public Long getStart_value();

        @Nullable
        public Long getLast_value();

        @Nullable
        public Long getNext_value();

        @Nullable
        public Long getIncrement();

        @Nullable
        public Long getMin_value();

        @Nullable
        public Long getMax_value();

        public long getCache();

        public boolean is_cycle();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SourceInfo;", "", "<init>", "()V", "name", "", "sql", "intellij.database.dialects.h2"})
    public static final class SourceInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String sql;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SynonymInfo;", "", "<init>", "()V", "synonym_name", "", "synonym_for_schema", "synonym_for", "remarks", "intellij.database.dialects.h2"})
    public static final class SynonymInfo {
        @JvmField
        @NotNull
        public String synonym_name = "";
        @JvmField
        @NotNull
        public String synonym_for_schema = "";
        @JvmField
        @NotNull
        public String synonym_for = "";
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TableInfo;", "", "<init>", "()V", "table_name", "", "is_view", "", "is_temp", "sql", "remarks", "intellij.database.dialects.h2"})
    public static final class TableInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        public boolean is_view;
        @JvmField
        public boolean is_temp;
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TriggerInfo;", "", "<init>", "()V", "trigger_schema", "", "trigger_name", "table_name", "trigger_type", "action_timing", "action_orientation", "sql", "remarks", "intellij.database.dialects.h2"})
    public static final class TriggerInfo {
        @JvmField
        @NotNull
        public String trigger_schema = "";
        @JvmField
        @NotNull
        public String trigger_name = "";
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String trigger_type = "";
        @JvmField
        @NotNull
        public String action_timing = "";
        @JvmField
        @NotNull
        public String action_orientation = "";
        @JvmField
        @Nullable
        public String sql;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0005R\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0005R\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "", "type_name", "", "getType_name", "()Ljava/lang/String;", "interval_type", "getInterval_type", "precision", "", "getPrecision", "()J", "interval_precision", "", "getInterval_precision", "()I", "scale", "getScale", "column_type", "getColumn_type", "geometry_type", "getGeometry_type", "geometry_srid", "getGeometry_srid", "()Ljava/lang/Integer;", "maximum_cardinality", "getMaximum_cardinality", "domain_schema", "getDomain_schema", "domain_name", "getDomain_name", "dtd_identifier", "getDtd_identifier", "intellij.database.dialects.h2"})
    public static interface TypedObjectInfo {
        @Nullable
        public String getType_name();

        @Nullable
        public String getInterval_type();

        public long getPrecision();

        public int getInterval_precision();

        public int getScale();

        @Nullable
        public String getColumn_type();

        @Nullable
        public String getGeometry_type();

        @Nullable
        public Integer getGeometry_srid();

        @Nullable
        public Integer getMaximum_cardinality();

        @Nullable
        public String getDomain_schema();

        @Nullable
        public String getDomain_name();

        @Nullable
        public String getDtd_identifier();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$UserInfo;", "", "<init>", "()V", "name", "", "is_admin", "", "remarks", "intellij.database.dialects.h2"})
    public static final class UserInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        public boolean is_admin;
        @JvmField
        @Nullable
        public String remarks;
    }
}

