/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.db2.model.Db2Index;
import com.intellij.database.dialects.db2.model.Db2IndexExtension;
import com.intellij.database.dialects.db2.model.Db2IndexExtensionArgument;
import com.intellij.database.dialects.db2.model.Db2Table;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/db2/model/Db2DescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "shouldAutoDescribe", "", "property", "Lcom/intellij/database/model/meta/BasicMetaField;", "describeTable", "Lcom/intellij/database/dialects/db2/model/Db2Table;", "describeTableColumn", "Lcom/intellij/database/dialects/db2/model/Db2TableColumn;", "describeIndexExtension", "Lcom/intellij/database/dialects/db2/model/Db2IndexExtension;", "intellij.database.dialects.db2"})
public final class Db2DescriptionService
extends DescriptionService {
    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (o instanceof Db2IndexExtension) {
            this.describeIndexExtension(project, (Db2IndexExtension)o, presentation);
        } else {
            super.updatePresentation(project, o, viewOptions, presentation);
        }
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof Db2Table ? this.describeTable((Db2Table)e, context) : (basicElement instanceof Db2TableColumn ? this.describeTableColumn((Db2TableColumn)e, context) : super.content(e, context));
    }

    @Override
    protected boolean shouldAutoDescribe(@NotNull BasicMetaField<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return Intrinsics.areEqual((Object)property.getId(), Db2Index.INDEX_SCHEMA_REF) || Intrinsics.areEqual((Object)property.getId(), Db2Index.COL_VIEW_REF) || super.shouldAutoDescribe(property);
    }

    private final String describeTable(Db2Table o, DescriptionService.Context context) {
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicTable");
        Object res2 = this.describeTable((BasicTable)o, context);
        ((Collection)context.getDescribed()).add(Db2Table.CLUSTERING_INDEX_NAMES);
        List<String> list = o.getClusteringIndexNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getClusteringIndexNames(...)");
        List<String> ci = list;
        if (!((Collection)ci).isEmpty()) {
            res2 = (String)res2 + " clustering indices (" + CollectionsKt.joinToString$default((Iterable)ci, null, null, null, (int)0, null, arg_0 -> Db2DescriptionService.describeTable$lambda$0(this, o, context, arg_0), (int)31, null) + ")";
        }
        return res2;
    }

    private final String describeTableColumn(Db2TableColumn o, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(Db2TableColumn.SEQUENCE_REF);
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicTableOrViewColumn");
        return this.describeTableOrViewColumn(o, context);
    }

    private final void describeIndexExtension(Project project, Db2IndexExtension o, PresentationData presentation) {
        Dbms dbms = DbImplUtilCore.getDbms(o);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, DbSqlUtilCore.getSqlDialect(dbms2)).withDialect(DbImplUtilCore.getDatabaseDialect(dbms2));
        builder.symbol("(");
        boolean first2 = true;
        for (Db2IndexExtensionArgument db2IndexExtensionArgument : o.getIndexExtensionArguments()) {
            if (first2) {
                first2 = false;
                v1 = Unit.INSTANCE;
            } else {
                DdlBuilder ddlBuilder = builder.symbol(",").space();
                v1 = ddlBuilder;
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            }
            builder.type(db2IndexExtensionArgument.getDasType().toDataType());
        }
        builder.symbol(")");
        presentation.addText(builder.getStatement(), DbPresentationCore.INFO_ATTRS);
    }

    private static final CharSequence describeTable$lambda$0(Db2DescriptionService this$0, Db2Table $o, DescriptionService.Context $context, String it) {
        String string = this$0.objectName(it, (BasicElement)$o.getIndices().get(it), $context);
        return string != null ? (CharSequence)string : (CharSequence)"";
    }
}

