/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.LogViewHolder;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridSessionClient
extends DatabaseTableGridDataHookUp
implements DatabaseSessionClientWithFile,
LogViewHolder<DatabaseSessionClientWithFile>,
DataRequest.CrossSessionOwner,
Disposable.Parent {
    private final LogView<DatabaseSessionClientWithFile> myView;
    private volatile Disposable myTxParent;
    private boolean myDisposed;

    DataGridSessionClient(@NotNull Project project, @NotNull DatabaseSession session, @NotNull VirtualFile file) {
        if (project == null) {
            DataGridSessionClient.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DataGridSessionClient.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DataGridSessionClient.$$$reportNull$$$0(2);
        }
        super(project, session, file, new DGDepartment.DataEditor(SessionsUtil.getQualifiedClientTitle(project, session.getConnectionPoint().getDataSource(), file)));
        LanguageConsoleImpl console = new LanguageConsoleImpl(this.getProject(), this.getDisplayName(), (Language)DbSqlUtilCore.getSqlDialect(this.getDbms()));
        this.myView = new DatabaseClientLogView((LanguageConsoleView)console, this);
        Disposer.register((Disposable)this, this.myView);
        this.mySession.attach(this);
        new StateWatcher.ClientWatcher(this);
        this.updateTxParent();
    }

    @Override
    public boolean getAutoClose() {
        return true;
    }

    @Override
    @NotNull
    public Disposable getTxDisposable() {
        Disposable disposable = this.myTxParent;
        if (disposable == null) {
            DataGridSessionClient.$$$reportNull$$$0(3);
        }
        return disposable;
    }

    @Override
    @NotNull
    public DataRequest.Owner getParentOwner() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            DataGridSessionClient.$$$reportNull$$$0(4);
        }
        return databaseSession;
    }

    @Override
    public void setSession(@NotNull DatabaseSession session) {
        if (session == null) {
            DataGridSessionClient.$$$reportNull$$$0(5);
        }
        this.updateTxParent();
        DatabaseSession oldSession = this.mySession;
        super.setSession(session);
        oldSession.exchange(this, session);
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = SessionsUtil.getClientTitle(this.myFile);
        if (string == null) {
            DataGridSessionClient.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseSession getSession() {
        DatabaseSession databaseSession = super.getSession();
        if (databaseSession == null) {
            DataGridSessionClient.$$$reportNull$$$0(7);
        }
        return databaseSession;
    }

    @Override
    public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger2) {
        if (trigger2 == null) {
            DataGridSessionClient.$$$reportNull$$$0(8);
        }
        if (trigger2 == DatabaseSessionClient.DetachTrigger.USER_REQUEST) {
            FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myFile);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean getShowOnActivity() {
        return false;
    }

    @Override
    public boolean focusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataGridSessionClient.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Override
    public boolean showOnAttention(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataGridSessionClient.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    @Nullable
    public SearchPath getSearchPath() {
        SearchPath path = SearchPath.of(ObjectPaths.of(this.getDatabaseTable()));
        if (path == null) {
            return null;
        }
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        return dialect.supportsQualificationBySchema() ? DbImplUtil.getDatabaseToSwitch(path) : DbImplUtil.getSchemaToSwitch(path);
    }

    @Override
    public boolean cleanup() {
        return false;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)this.myFile, DatabaseElementVirtualFileImpl.class));
        DbElement element = file == null ? null : file.findElement(this.getProject());
        Icon icon = element == null ? null : element.getIcon();
        Icon icon2 = (Icon)ObjectUtils.notNull((Object)icon, (Object)AllIcons.Nodes.DataTables);
        if (icon2 == null) {
            DataGridSessionClient.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    @Override
    public boolean isValid() {
        return !this.myDisposed && this.myView.isValid() && DataSourceUtil.isDataSourceValid(DbPsiFacade.getInstance(this.getProject()), ((DatabaseConnectionPoint)this.getSession().getTarget()).getDataSource());
    }

    @Override
    @NotNull
    public LogView<DatabaseSessionClientWithFile> getView() {
        LogView<DatabaseSessionClientWithFile> logView = this.myView;
        if (logView == null) {
            DataGridSessionClient.$$$reportNull$$$0(12);
        }
        return logView;
    }

    public void beforeTreeDispose() {
        this.myDisposed = true;
    }

    private void updateTxParent() {
        if (this.myTxParent != null) {
            Disposer.dispose((Disposable)this.myTxParent);
        }
        this.myTxParent = Disposer.newDisposable();
        Disposer.register((Disposable)this, (Disposable)this.myTxParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridSessionClient";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridSessionClient";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxDisposable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentOwner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detached";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "focusOnError";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showOnAttention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 11, 12 -> new IllegalStateException(string);
        };
    }
}

