/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.workspace;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePrefixTree;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.prefixTree.set.MutablePrefixTreeSet;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.UnityPackage;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.UnityPackageSource;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspaceExtensionsKt;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspacePackageUpdater;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.RiderEntitySource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001c\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initialEntityStorage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "sourceRootsTree", "Lcom/intellij/util/containers/prefixTree/set/MutablePrefixTreeSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSourceRootsTree", "()Lcom/intellij/util/containers/prefixTree/set/MutablePrefixTreeSet;", "addPackage", "", "unityPackage", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/UnityPackage;", "packageFolder", "entityStorage", "removePackage", "updateWorkspaceModel", "action", "Lkotlin/Function1;", "syncInitialEntityStorage", "Companion", "ProtocolListener", "RiderUnityPackageEntitySource", "intellij.rider.plugins.unity"})
public final class UnityWorkspacePackageUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private MutableEntityStorage initialEntityStorage;
    @NotNull
    private final MutablePrefixTreeSet<VirtualFile> sourceRootsTree;
    @NotNull
    private static final Logger logger;

    public UnityWorkspacePackageUpdater(@NotNull Project project) {
        VirtualFile assets;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.initialEntityStorage = MutableEntityStorage.Companion.create();
        this.sourceRootsTree = VirtualFilePrefixTree.INSTANCE.createSet();
        VirtualFile virtualFile = DocumentUtilKt.toVirtualFile((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.project), (boolean)false);
        Object object = assets = virtualFile != null ? virtualFile.findChild("Assets") : null;
        if (assets != null) {
            this.sourceRootsTree.add((Object)assets);
        } else {
            logger.warn("No `Assets` folder in the Unity project");
        }
    }

    @NotNull
    public final MutablePrefixTreeSet<VirtualFile> getSourceRootsTree() {
        return this.sourceRootsTree;
    }

    private final void addPackage(UnityPackage unityPackage, VirtualFile packageFolder, MutableEntityStorage entityStorage) {
        logger.trace("Adding Unity package: " + unityPackage.getId());
        if (packageFolder != null && unityPackage.getSource() != UnityPackageSource.Unknown) {
            UnityPackageEntity entity = (UnityPackageEntity)entityStorage.addEntity((WorkspaceEntity.Builder)UnityPackageEntity.Companion.create(unityPackage, (EntitySource)RiderUnityPackageEntitySource.INSTANCE, (Function1<? super UnityPackageEntity.Builder, Unit>)((Function1)arg_0 -> UnityWorkspacePackageUpdater.addPackage$lambda$0(unityPackage, arg_0))));
            MutableExternalEntityMapping mapping = entityStorage.getMutableExternalMapping(UnityWorkspaceExtensionsKt.getUNITY_PACKAGE_ID_MAPPING());
            mapping.addMapping((WorkspaceEntity)entity, (Object)unityPackage.getId());
        }
    }

    private final void removePackage(UnityPackage unityPackage, MutableEntityStorage entityStorage) {
        logger.trace("Removing Unity package: " + unityPackage.getId());
        ExternalEntityMapping mapping = entityStorage.getExternalMapping(UnityWorkspaceExtensionsKt.getUNITY_PACKAGE_ID_MAPPING());
        for (WorkspaceEntity entity : mapping.getEntities((Object)unityPackage.getId())) {
            entityStorage.removeEntity(entity);
        }
    }

    private final void updateWorkspaceModel(Function1<? super MutableEntityStorage, Unit> action) {
        ApplicationKt.getApplication().runWriteAction(() -> UnityWorkspacePackageUpdater.updateWorkspaceModel$lambda$1(this, action));
    }

    private final void syncInitialEntityStorage() {
        MutableEntityStorage mutableEntityStorage = this.initialEntityStorage;
        if (mutableEntityStorage == null) {
            return;
        }
        MutableEntityStorage initialEntityStorage = mutableEntityStorage;
        logger.trace("Sync Unity packages after startup...");
        ApplicationKt.getApplication().runWriteAction(() -> UnityWorkspacePackageUpdater.syncInitialEntityStorage$lambda$4(this, initialEntityStorage));
    }

    private static final Unit addPackage$lambda$0(UnityPackage $unityPackage, UnityPackageEntity.Builder $this$UnityPackageEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$UnityPackageEntity, (String)"$this$UnityPackageEntity");
        $this$UnityPackageEntity.setDescriptor($unityPackage);
        return Unit.INSTANCE;
    }

    private static final void updateWorkspaceModel$lambda$1(UnityWorkspacePackageUpdater this$0, Function1 $action) {
        MutableEntityStorage entityStorage = this$0.initialEntityStorage;
        if (entityStorage != null) {
            $action.invoke((Object)entityStorage);
        } else {
            WorkspaceModel.Companion.getInstance(this$0.project).updateProjectModel("Unity: update packages", $action);
        }
    }

    private static final boolean syncInitialEntityStorage$lambda$4$lambda$3$lambda$2(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof RiderUnityPackageEntitySource;
    }

    private static final Unit syncInitialEntityStorage$lambda$4$lambda$3(MutableEntityStorage $initialEntityStorage, MutableEntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        entityStorage.replaceBySource(UnityWorkspacePackageUpdater::syncInitialEntityStorage$lambda$4$lambda$3$lambda$2, (EntityStorage)$initialEntityStorage);
        return Unit.INSTANCE;
    }

    private static final void syncInitialEntityStorage$lambda$4(UnityWorkspacePackageUpdater this$0, MutableEntityStorage $initialEntityStorage) {
        this$0.initialEntityStorage = null;
        WorkspaceModel.Companion.getInstance(this$0.project).updateProjectModel("Unity: sync packages", arg_0 -> UnityWorkspacePackageUpdater.syncInitialEntityStorage$lambda$4$lambda$3($initialEntityStorage, arg_0));
    }

    public static final /* synthetic */ void access$updateWorkspaceModel(UnityWorkspacePackageUpdater $this, Function1 action) {
        $this.updateWorkspaceModel((Function1<? super MutableEntityStorage, Unit>)action);
    }

    public static final /* synthetic */ void access$addPackage(UnityWorkspacePackageUpdater $this, UnityPackage unityPackage, VirtualFile packageFolder, MutableEntityStorage entityStorage) {
        $this.addPackage(unityPackage, packageFolder, entityStorage);
    }

    public static final /* synthetic */ void access$removePackage(UnityWorkspacePackageUpdater $this, UnityPackage unityPackage, MutableEntityStorage entityStorage) {
        $this.removePackage(unityPackage, entityStorage);
    }

    static {
        Logger logger = Logger.getInstance(UnityWorkspacePackageUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityWorkspacePackageUpdater.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityWorkspacePackageUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityWorkspacePackageUpdater.kt\ncom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n31#2,2:139\n*S KotlinDebug\n*F\n+ 1 UnityWorkspacePackageUpdater.kt\ncom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$Companion\n*L\n37#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnityWorkspacePackageUpdater getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UnityWorkspacePackageUpdater> serviceClass$iv = UnityWorkspacePackageUpdater.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnityWorkspacePackageUpdater)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/plugins/unity/model/frontendBackend/FrontendBackendModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.unity"})
    public static final class ProtocolListener
    implements SolutionExtListener<FrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull FrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            model.getPackages().adviseAddRemove(lifetime, (arg_0, arg_1, arg_2) -> ProtocolListener.extensionCreated$lambda$0(session, lifetime, arg_0, arg_1, arg_2));
            SourceExKt.adviseUntil((ISource)((ISource)model.getPackagesUpdating()), (Lifetime)lifetime, arg_0 -> ProtocolListener.extensionCreated$lambda$1(session, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, Lifetime $lifetime, AddRemove action, String string, UnityPackage unityPackage) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)unityPackage, (String)"unityPackage");
            ThreadingAssertions.assertEventDispatchThread();
            UnityWorkspacePackageUpdater updater = Companion.getInstance($session.getProject());
            LifetimeCoroutineUtilKt.async$default((Lifetime)$lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Deferred<? extends Unit>>, Object>(unityPackage, $lifetime, action, $session, updater, null){
                int label;
                final /* synthetic */ UnityPackage $unityPackage;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ AddRemove $action;
                final /* synthetic */ ClientProjectSession $session;
                final /* synthetic */ UnityWorkspacePackageUpdater $updater;
                {
                    this.$unityPackage = $unityPackage;
                    this.$lifetime = $lifetime;
                    this.$action = $action;
                    this.$session = $session;
                    this.$updater = $updater;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            VirtualFile virtualFile;
                            ResultKt.throwOnFailure((Object)object);
                            String string = this.$unityPackage.getPackageFolderPath();
                            if (string != null) {
                                String it = string;
                                boolean bl = false;
                                virtualFile = VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)true);
                            } else {
                                virtualFile = null;
                            }
                            VirtualFile packageFolder = virtualFile;
                            return LifetimeCoroutineUtilKt.async$default((Lifetime)this.$lifetime, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$action, this.$session, packageFolder, this.$updater, this.$unityPackage, null){
                                int label;
                                final /* synthetic */ AddRemove $action;
                                final /* synthetic */ ClientProjectSession $session;
                                final /* synthetic */ VirtualFile $packageFolder;
                                final /* synthetic */ UnityWorkspacePackageUpdater $updater;
                                final /* synthetic */ UnityPackage $unityPackage;
                                {
                                    this.$action = $action;
                                    this.$session = $session;
                                    this.$packageFolder = $packageFolder;
                                    this.$updater = $updater;
                                    this.$unityPackage = $unityPackage;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            switch (extensionCreated.1.WhenMappings.$EnumSwitchMapping$0[this.$action.ordinal()]) {
                                                case 1: {
                                                    UnityWorkspacePackageUpdater.access$updateWorkspaceModel(UnityWorkspacePackageUpdater.Companion.getInstance(this.$session.getProject()), arg_0 -> extensionCreated.1.1.invokeSuspend$lambda$0(this.$packageFolder, this.$updater, this.$unityPackage, arg_0));
                                                    break;
                                                }
                                                case 2: {
                                                    UnityWorkspacePackageUpdater.access$updateWorkspaceModel(UnityWorkspacePackageUpdater.Companion.getInstance(this.$session.getProject()), arg_0 -> extensionCreated.1.1.invokeSuspend$lambda$1(this.$packageFolder, this.$updater, this.$unityPackage, arg_0));
                                                    break;
                                                }
                                                default: {
                                                    throw new NoWhenBranchMatchedException();
                                                }
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(VirtualFile $packageFolder, UnityWorkspacePackageUpdater $updater, UnityPackage $unityPackage, MutableEntityStorage entityStorage) {
                                    if ($packageFolder != null) {
                                        $updater.getSourceRootsTree().add((Object)$packageFolder);
                                    }
                                    UnityWorkspacePackageUpdater.access$addPackage($updater, $unityPackage, $packageFolder, entityStorage);
                                    return Unit.INSTANCE;
                                }

                                private static final Unit invokeSuspend$lambda$1(VirtualFile $packageFolder, UnityWorkspacePackageUpdater $updater, UnityPackage $unityPackage, MutableEntityStorage entityStorage) {
                                    if ($packageFolder != null) {
                                        $updater.getSourceRootsTree().remove((Object)$packageFolder);
                                    }
                                    UnityWorkspacePackageUpdater.access$removePackage($updater, $unityPackage, entityStorage);
                                    return Unit.INSTANCE;
                                }
                            }), (int)2, null);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Deferred<Unit>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return Unit.INSTANCE;
        }

        private static final boolean extensionCreated$lambda$1(ClientProjectSession $session, Boolean updating) {
            if (Intrinsics.areEqual((Object)updating, (Object)false)) {
                Companion.getInstance($session.getProject()).syncInitialEntityStorage();
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspacePackageUpdater$RiderUnityPackageEntitySource;", "Lcom/jetbrains/rider/projectView/workspace/RiderEntitySource;", "<init>", "()V", "intellij.rider.plugins.unity"})
    public static final class RiderUnityPackageEntitySource
    implements RiderEntitySource {
        @NotNull
        public static final RiderUnityPackageEntitySource INSTANCE = new RiderUnityPackageEntitySource();

        private RiderUnityPackageEntitySource() {
        }
    }
}

