/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.workspace;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleOrLibrarySourceRootData;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.projectView.indexing.RiderModuleRootData;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.workspaceModel.RiderModuleTypeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspaceFileIndexContributor;", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileIndexContributor;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "<init>", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "registerFileSets", "", "entity", "registrar", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetRegistrar;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "UnityAssetsModulesFileSetData", "intellij.rider.plugins.unity"})
public final class UnityWorkspaceFileIndexContributor
implements WorkspaceFileIndexContributor<ProjectModelEntity> {
    @NotNull
    public Class<ProjectModelEntity> getEntityClass() {
        return ProjectModelEntity.class;
    }

    public void registerFileSets(@NotNull ProjectModelEntity entity, @NotNull WorkspaceFileSetRegistrar registrar, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (entity.getDescriptor() instanceof RdSolutionDescriptor) {
            VirtualFile userSettingsDir;
            VirtualFile projectSettingsDir;
            VirtualFileUrl virtualFileUrl = entity.getUrl();
            if (virtualFileUrl == null) {
                return;
            }
            VirtualFileUrl url = virtualFileUrl;
            ModuleEntity moduleEntity = RiderModuleTypeKt.getRiderModuleEntity((EntityStorage)storage);
            Intrinsics.checkNotNull((Object)moduleEntity);
            ModuleBridge moduleBridge = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)storage);
            Intrinsics.checkNotNull((Object)moduleBridge);
            ModuleBridge module = moduleBridge;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFileUrlManager virtualFileManager = WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager();
            VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)url);
            if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
                return;
            }
            VirtualFile solFolder = virtualFile;
            VirtualFile packagesFolder = solFolder.findChild("Packages");
            if (packagesFolder != null) {
                VirtualFile packagesLockJson;
                VirtualFile manifestJson = packagesFolder.findChild("manifest.json");
                if (manifestJson != null) {
                    registrar.registerNonRecursiveFileSet(VirtualFileUrls.toVirtualFileUrl((VirtualFile)manifestJson, (VirtualFileUrlManager)virtualFileManager), WorkspaceFileKind.CONTENT, (WorkspaceEntity)entity, (WorkspaceFileSetData)new RiderModuleRootData((Module)module));
                }
                if ((packagesLockJson = packagesFolder.findChild("packages-lock.json")) != null) {
                    registrar.registerNonRecursiveFileSet(VirtualFileUrls.toVirtualFileUrl((VirtualFile)packagesLockJson, (VirtualFileUrlManager)virtualFileManager), WorkspaceFileKind.CONTENT, (WorkspaceEntity)entity, (WorkspaceFileSetData)new RiderModuleRootData((Module)module));
                }
            }
            if ((projectSettingsDir = solFolder.findChild("ProjectSettings")) != null) {
                registrar.registerFileSet(VirtualFileUrls.toVirtualFileUrl((VirtualFile)projectSettingsDir, (VirtualFileUrlManager)virtualFileManager), WorkspaceFileKind.EXTERNAL_SOURCE, (WorkspaceEntity)entity, (WorkspaceFileSetData)new UnityAssetsModulesFileSetData());
            }
            if ((userSettingsDir = solFolder.findChild("UserSettings")) != null) {
                registrar.registerFileSet(VirtualFileUrls.toVirtualFileUrl((VirtualFile)userSettingsDir, (VirtualFileUrlManager)virtualFileManager), WorkspaceFileKind.EXTERNAL_SOURCE, (WorkspaceEntity)entity, (WorkspaceFileSetData)new UnityAssetsModulesFileSetData());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/plugins/unity/workspace/UnityWorkspaceFileIndexContributor$UnityAssetsModulesFileSetData;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ModuleOrLibrarySourceRootData;", "<init>", "()V", "intellij.rider.plugins.unity"})
    private static final class UnityAssetsModulesFileSetData
    implements ModuleOrLibrarySourceRootData {
    }
}

