/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.util;

import com.google.gson.Gson;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.jetbrains.rider.plugins.unity.run.UnityRunUtil;
import com.jetbrains.rider.plugins.unity.util.EditorInstanceJsonStatus;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\f\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson;", "", "status", "Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJsonStatus;", "contents", "Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson$EditorInstanceJsonContents;", "<init>", "(Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJsonStatus;Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson$EditorInstanceJsonContents;)V", "getStatus", "()Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJsonStatus;", "getContents", "()Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson$EditorInstanceJsonContents;", "validateStatus", "processList", "", "Lcom/intellij/execution/process/ProcessInfo;", "([Lcom/intellij/execution/process/ProcessInfo;)Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJsonStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "EditorInstanceJsonContents", "intellij.rider.plugins.unity"})
public final class EditorInstanceJson {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorInstanceJsonStatus status;
    @Nullable
    private final EditorInstanceJsonContents contents;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<EditorInstanceJson> INSTANCE_KEY;
    @NotNull
    private static final Key<AsyncFileListener> LISTENER_KEY;
    @NotNull
    private static final String editorInstanceJsonRelPath = "Library/EditorInstance.json";

    public EditorInstanceJson(@NotNull EditorInstanceJsonStatus status, @Nullable EditorInstanceJsonContents contents) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.status = status;
        this.contents = contents;
    }

    @NotNull
    public final EditorInstanceJsonStatus getStatus() {
        return this.status;
    }

    @Nullable
    public final EditorInstanceJsonContents getContents() {
        return this.contents;
    }

    @NotNull
    public final EditorInstanceJsonStatus validateStatus(@NotNull ProcessInfo[] processList) {
        Intrinsics.checkNotNullParameter((Object)processList, (String)"processList");
        if (this.status == EditorInstanceJsonStatus.Valid && this.contents != null && !UnityRunUtil.INSTANCE.isValidUnityEditorProcess(this.contents.getProcess_id(), processList)) {
            return EditorInstanceJsonStatus.Outdated;
        }
        return this.status;
    }

    @NotNull
    public final EditorInstanceJsonStatus component1() {
        return this.status;
    }

    @Nullable
    public final EditorInstanceJsonContents component2() {
        return this.contents;
    }

    @NotNull
    public final EditorInstanceJson copy(@NotNull EditorInstanceJsonStatus status, @Nullable EditorInstanceJsonContents contents) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return new EditorInstanceJson(status, contents);
    }

    public static /* synthetic */ EditorInstanceJson copy$default(EditorInstanceJson editorInstanceJson, EditorInstanceJsonStatus editorInstanceJsonStatus, EditorInstanceJsonContents editorInstanceJsonContents, int n, Object object) {
        if ((n & 1) != 0) {
            editorInstanceJsonStatus = editorInstanceJson.status;
        }
        if ((n & 2) != 0) {
            editorInstanceJsonContents = editorInstanceJson.contents;
        }
        return editorInstanceJson.copy(editorInstanceJsonStatus, editorInstanceJsonContents);
    }

    @NotNull
    public String toString() {
        return "EditorInstanceJson(status=" + this.status + ", contents=" + this.contents + ")";
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = result * 31 + (this.contents == null ? 0 : this.contents.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EditorInstanceJson)) {
            return false;
        }
        EditorInstanceJson editorInstanceJson = (EditorInstanceJson)other;
        if (this.status != editorInstanceJson.status) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.contents, (Object)editorInstanceJson.contents);
    }

    static {
        Logger logger = Logger.getInstance(EditorInstanceJson.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EditorInstanceJson.logger = logger;
        INSTANCE_KEY = new Key("Unity::EditorInstanceJson");
        LISTENER_KEY = new Key("Unity::EditorInstanceJson::Listener");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "INSTANCE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson;", "LISTENER_KEY", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "editorInstanceJsonRelPath", "", "getInstance", "project", "Lcom/intellij/openapi/project/Project;", "load", "empty", "status", "Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJsonStatus;", "initFileListener", "", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorInstanceJson getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.initFileListener(project);
            EditorInstanceJson editorInstanceJson = (EditorInstanceJson)project.getUserData(INSTANCE_KEY);
            if (editorInstanceJson != null) {
                return editorInstanceJson;
            }
            editorInstanceJson = this.load(project);
            if (editorInstanceJson.getStatus() != EditorInstanceJsonStatus.Valid) {
                project.putUserData(INSTANCE_KEY, (Object)editorInstanceJson);
            }
            return editorInstanceJson;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final EditorInstanceJson load(Project project) {
            Object object;
            if (project.isDefault()) {
                return this.empty(EditorInstanceJsonStatus.Missing);
            }
            File file = FilesKt.resolve((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)project), (String)EditorInstanceJson.editorInstanceJsonRelPath);
            if (!file.exists()) {
                return this.empty(EditorInstanceJsonStatus.Missing);
            }
            try {
                EditorInstanceJson editorInstanceJson;
                object = new FileReader(file);
                Throwable throwable = null;
                try {
                    EditorInstanceJson editorInstanceJson2;
                    FileReader it = (FileReader)object;
                    boolean bl = false;
                    EditorInstanceJsonContents contents = (EditorInstanceJsonContents)new Gson().fromJson((Reader)it, EditorInstanceJsonContents.class);
                    if (contents != null) {
                        editorInstanceJson2 = new EditorInstanceJson(EditorInstanceJsonStatus.Valid, contents);
                    } else {
                        logger.error("Error reading EditorInstance.json");
                        editorInstanceJson2 = Companion.empty(EditorInstanceJsonStatus.Error);
                    }
                    editorInstanceJson = editorInstanceJson2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = editorInstanceJson;
            }
            catch (IOException e) {
                logger.error("Error reading EditorInstance.json", (Throwable)e);
                object = this.empty(EditorInstanceJsonStatus.Error);
            }
            catch (Throwable t) {
                logger.error("Error parsing EditorInstance.json", t);
                object = this.empty(EditorInstanceJsonStatus.Error);
            }
            return object;
        }

        private final EditorInstanceJson empty(EditorInstanceJsonStatus status) {
            return new EditorInstanceJson(status, null);
        }

        private final void initFileListener(Project project) {
            File fullEditorInstancePath = FilesKt.resolve((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)project), (String)EditorInstanceJson.editorInstanceJsonRelPath);
            AsyncFileListener listener2 = (AsyncFileListener)project.getUserData(LISTENER_KEY);
            if (listener2 == null) {
                listener2 = new AsyncFileListener(project, fullEditorInstancePath){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ File $fullEditorInstancePath;
                    {
                        this.$project = $project;
                        this.$fullEditorInstancePath = $fullEditorInstancePath;
                    }

                    public AsyncFileListener.ChangeApplier prepareChange(List<? extends VFileEvent> events) {
                        boolean bl;
                        block4: {
                            Intrinsics.checkNotNullParameter(events, (String)"events");
                            Iterable $this$any$iv = events;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    VFileEvent it = (VFileEvent)element$iv;
                                    boolean bl2 = false;
                                    String string = it.getPath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                    if (!this.isEditorInstanceJson(string)) continue;
                                    bl = true;
                                    break block4;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            return new AsyncFileListener.ChangeApplier(this.$project){
                                final /* synthetic */ Project $project;
                                {
                                    this.$project = $project;
                                }

                                public void afterVfsChange() {
                                    this.$project.putUserData(EditorInstanceJson.access$getINSTANCE_KEY$cp(), null);
                                }
                            };
                        }
                        return null;
                    }

                    private final boolean isEditorInstanceJson(String path) {
                        return Intrinsics.areEqual((Object)this.$fullEditorInstancePath, (Object)new File(path));
                    }
                };
                VirtualFileManager.getInstance().addAsyncFileListener(listener2, (Disposable)project);
                project.putUserData(LISTENER_KEY, (Object)listener2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/unity/util/EditorInstanceJson$EditorInstanceJsonContents;", "", "process_id", "", "version", "", "<init>", "(ILjava/lang/String;)V", "getProcess_id", "()I", "getVersion", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rider.plugins.unity"})
    public static final class EditorInstanceJsonContents {
        private final int process_id;
        @NotNull
        private final String version;

        public EditorInstanceJsonContents(int process_id, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.process_id = process_id;
            this.version = version;
        }

        public final int getProcess_id() {
            return this.process_id;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public final int component1() {
            return this.process_id;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final EditorInstanceJsonContents copy(int process_id, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new EditorInstanceJsonContents(process_id, version);
        }

        public static /* synthetic */ EditorInstanceJsonContents copy$default(EditorInstanceJsonContents editorInstanceJsonContents, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = editorInstanceJsonContents.process_id;
            }
            if ((n2 & 2) != 0) {
                string = editorInstanceJsonContents.version;
            }
            return editorInstanceJsonContents.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "EditorInstanceJsonContents(process_id=" + this.process_id + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.process_id);
            result = result * 31 + this.version.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EditorInstanceJsonContents)) {
                return false;
            }
            EditorInstanceJsonContents editorInstanceJsonContents = (EditorInstanceJsonContents)other;
            if (this.process_id != editorInstanceJsonContents.process_id) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)editorInstanceJsonContents.version);
        }
    }
}

