/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui.vcs;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.ui.UnityUIBundle;
import com.jetbrains.rider.plugins.unity.ui.vcs.UnsavedCheckinState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/UnresolvedMergeCheckHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "settings", "Lcom/jetbrains/rider/plugins/unity/ui/vcs/UnsavedCheckinState;", "isEnabled", "", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "UnsavedSceneCommitProblem", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnsavedSceneCheckinHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsavedSceneCheckinHandlerFactory.kt\ncom/jetbrains/rider/plugins/unity/ui/vcs/UnresolvedMergeCheckHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n25#2:76\n25#2:77\n*S KotlinDebug\n*F\n+ 1 UnsavedSceneCheckinHandlerFactory.kt\ncom/jetbrains/rider/plugins/unity/ui/vcs/UnresolvedMergeCheckHandler\n*L\n43#1:76\n46#1:77\n*E\n"})
final class UnresolvedMergeCheckHandler
extends CheckinHandler
implements CommitCheck,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final UnsavedCheckinState settings;
    @NotNull
    private static final String UNSAVED_SCENE_HELP_LINK = "https://github.com/JetBrains/resharper-unity/wiki/Pre%E2%80%90commit-checks-for-Unity#unsaved-changes-check";

    public UnresolvedMergeCheckHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.settings = UnsavedCheckinState.Companion.getService(this.project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.LATE;
    }

    public boolean isEnabled() {
        return this.settings.getCheckUnsavedState() && (Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue() != false;
    }

    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        if (this.settings.getCheckUnsavedState() && ((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            boolean providerResult = false;
            try {
                providerResult = (Boolean)FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getHasUnsavedState().sync((Object)Unit.INSTANCE, new RpcTimeouts(200L, 200L));
            }
            catch (CancellationException t) {
                UnresolvedMergeCheckHandler $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(UnresolvedMergeCheckHandler.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Unable to fetch hasUnsavedScenes", (Throwable)t);
            }
            catch (Throwable t) {
                UnresolvedMergeCheckHandler $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(UnresolvedMergeCheckHandler.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Unable to fetch hasUnsavedScenes", t);
            }
            if (providerResult) {
                return new UnsavedSceneCommitProblem(UnityUIBundle.Companion.message("dialog.unsaved.message.changes.in.unity.state.will.not.be.included.in.commit", new Object[0]));
            }
        }
        return null;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            return null;
        }
        return BooleanCommitOption.Companion.create(this.project, (CheckinHandler)this, false, UnityUIBundle.Companion.message("commitOption.check.unsaved.unity.state", new Object[0]), (KMutableProperty0)new MutablePropertyReference0Impl(this.settings){

            public Object get() {
                return ((UnsavedCheckinState)this.receiver).getCheckUnsavedState();
            }

            public void set(Object value) {
                ((UnsavedCheckinState)this.receiver).setCheckUnsavedState((Boolean)value);
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/UnresolvedMergeCheckHandler$Companion;", "", "<init>", "()V", "UNSAVED_SCENE_HELP_LINK", "", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/UnresolvedMergeCheckHandler$UnsavedSceneCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "message", "", "<init>", "(Ljava/lang/String;)V", "showDetailsAction", "getShowDetailsAction", "()Ljava/lang/String;", "text", "getText", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unity"})
    public static final class UnsavedSceneCommitProblem
    implements CommitProblemWithDetails {
        @NotNull
        private final String showDetailsAction;
        @NotNull
        private final String text;

        public UnsavedSceneCommitProblem(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.showDetailsAction = UnityUIBundle.Companion.message("unity.before.check.in.show.details", new Object[0]);
            this.text = message;
        }

        @NotNull
        public String getShowDetailsAction() {
            return this.showDetailsAction;
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        public void showDetails(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BrowserUtil.browse((String)UnresolvedMergeCheckHandler.UNSAVED_SCENE_HELP_LINK);
        }
    }
}

