/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui.vcs;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.ui.UnityUIBundle;
import com.jetbrains.rider.plugins.unity.ui.vcs.MetaFilesCheckinState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCommitCheck;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "settings", "Lcom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCheckinState;", "isEnabled", "", "getBeforeCheckinConfigurationPanel", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMetaFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "EmptyFoldersCommitProblem", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nMetaFilesCheckinHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaFilesCheckinHandlerFactory.kt\ncom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCommitCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n774#2:92\n865#2,2:93\n*S KotlinDebug\n*F\n+ 1 MetaFilesCheckinHandlerFactory.kt\ncom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCommitCheck\n*L\n51#1:92\n51#1:93,2\n*E\n"})
final class MetaFilesCommitCheck
extends CheckinHandler
implements CommitCheck,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MetaFilesCheckinState settings;
    @NotNull
    private static final String EMPTY_FOLDERS_HELP_LINK = "https://github.com/JetBrains/resharper-unity/wiki/Pre%E2%80%90commit-checks-for-Unity#empty-folder-with-meta-file-check";

    public MetaFilesCommitCheck(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.settings = MetaFilesCheckinState.Companion.getService(this.project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.LATE;
    }

    public boolean isEnabled() {
        return this.settings.getCheckMetaFiles() && (Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue() != false;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            return null;
        }
        return BooleanCommitOption.Companion.create(this.project, (CheckinHandler)this, false, UnityUIBundle.Companion.message("check.redundant.meta.files", new Object[0]), (KMutableProperty0)new MutablePropertyReference0Impl(this.settings){

            public Object get() {
                return ((MetaFilesCheckinState)this.receiver).getCheckMetaFiles();
            }

            public void set(Object value) {
                ((MetaFilesCheckinState)this.receiver).setCheckMetaFiles((Boolean)value);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        if (this.settings.getCheckMetaFiles() && ((Boolean)UnityProjectDiscovererKt.isUnityProject(this.project).getValue()).booleanValue()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = commitInfo.getCommittedChanges();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile folder;
                VirtualFile virtualFile;
                boolean bl;
                Change it = (Change)element$iv$iv;
                boolean bl2 = false;
                if (it.getVirtualFile() == null) {
                    bl = false;
                } else if (!Intrinsics.areEqual((Object)it.getFileStatus(), (Object)FileStatus.ADDED) || !this.isMetaFile(it.getVirtualFile())) {
                    bl = false;
                } else if (virtualFile.getParent().findChild(virtualFile.getNameWithoutExtension()) == null) {
                    bl = false;
                } else if (!folder.isDirectory()) {
                    bl = false;
                } else {
                    VirtualFile[] virtualFileArray = folder.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    bl = !ArraysKt.any((Object[])virtualFileArray);
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List emptyFolders = (List)destination$iv$iv;
            if (!CollectionsKt.any((Iterable)emptyFolders)) {
                return null;
            }
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)emptyFolders, (int)3), (CharSequence)", ", null, null, (int)0, null, arg_0 -> MetaFilesCommitCheck.runCheck$lambda$1(this, arg_0), (int)30, null) + (((Collection)emptyFolders).size() > 3 ? ", \u2026" : "")};
            String message = UnityUIBundle.Companion.message("notification.content.empty.folders.so.meta.files.should.not.be.committed", objectArray);
            return new EmptyFoldersCommitProblem(message);
        }
        return null;
    }

    private final boolean isMetaFile(VirtualFile file) {
        Object object = file;
        if (object == null || (object = object.getExtension()) == null) {
            return false;
        }
        Object extension = object;
        return StringsKt.equals((String)"meta", (String)extension, (boolean)true);
    }

    private static final CharSequence runCheck$lambda$1(MetaFilesCommitCheck this$0, Change it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = SolutionHostExtensionsKt.getSolutionDirectory((Project)this$0.project).toPath();
        VirtualFile virtualFile = it.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        Path path2 = path.relativize(virtualFile.toNioPath());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
        return ((Object)path2).toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCommitCheck$Companion;", "", "<init>", "()V", "EMPTY_FOLDERS_HELP_LINK", "", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/vcs/MetaFilesCommitCheck$EmptyFoldersCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "message", "", "<init>", "(Ljava/lang/String;)V", "showDetailsAction", "getShowDetailsAction", "()Ljava/lang/String;", "text", "getText", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unity"})
    public static final class EmptyFoldersCommitProblem
    implements CommitProblemWithDetails {
        @NotNull
        private final String showDetailsAction;
        @NotNull
        private final String text;

        public EmptyFoldersCommitProblem(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.showDetailsAction = UnityUIBundle.Companion.message("unity.before.check.in.show.details", new Object[0]);
            this.text = message;
        }

        @NotNull
        public String getShowDetailsAction() {
            return this.showDetailsAction;
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        public void showDetails(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BrowserUtil.browse((String)MetaFilesCommitCheck.EMPTY_FOLDERS_HELP_LINK);
        }
    }
}

