/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui.profilerIntegration;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpFileType;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.model.ProfilerSnapshotRequest;
import com.jetbrains.rider.plugins.unity.model.SnapshotStatus;
import com.jetbrains.rider.plugins.unity.model.UnityProfilerSnapshotStatus;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendProfilerModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendProfilerModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.ui.UnityUIBundle;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateDataIsUpToDate;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateDisabled;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateDisconnected;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateFetchingInProgress;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateHasDataToFetch;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateNoDataAvailable;
import com.jetbrains.rider.plugins.unity.ui.profilerIntegration.ProfilerActionStateSetup;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/profilerIntegration/ProfilerIntegrationWidgetAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "isUnityScriptFile", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "updatePresentation", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "snapshotStateSetup", "Lcom/jetbrains/rider/plugins/unity/ui/profilerIntegration/ProfilerActionStateSetup;", "intellij.rider.plugins.unity"})
public final class ProfilerIntegrationWidgetAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            FrontendBackendProfilerModel model = FrontendBackendProfilerModel_PregeneratedKt.getFrontendBackendProfilerModel(FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project2)));
            UnityProfilerSnapshotStatus unityProfilerSnapshotStatus = (UnityProfilerSnapshotStatus)model.getProfilerSnapshotStatus().getValueOrNull();
            if (unityProfilerSnapshotStatus == null) break block1;
            UnityProfilerSnapshotStatus it = unityProfilerSnapshotStatus;
            boolean bl = false;
            model.getUpdateUnityProfilerSnapshotData().fire((Object)new ProfilerSnapshotRequest(it.getFrameIndex(), it.getThreadIndex()));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || !((Boolean)UnityProjectDiscovererKt.getHasUnityReference(project).getValue()).booleanValue()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (editor2.isViewer()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!this.isUnityScriptFile(project, editor2)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        FrontendBackendModel model = FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project));
        UnityProfilerSnapshotStatus profilerStatus = (UnityProfilerSnapshotStatus)FrontendBackendProfilerModel_PregeneratedKt.getFrontendBackendProfilerModel(model).getProfilerSnapshotStatus().getValueOrNull();
        if (!((Boolean)InterfacesKt.valueOrDefault(model.getUnityEditorConnected(), (Object)false)).booleanValue()) {
            ProfilerIntegrationWidgetAction.update$refreshPresentationState(this, e, editor2, new ProfilerActionStateDisconnected());
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        UnityProfilerSnapshotStatus unityProfilerSnapshotStatus = profilerStatus;
        SnapshotStatus snapshotStatus = unityProfilerSnapshotStatus != null ? unityProfilerSnapshotStatus.getStatus() : null;
        switch (snapshotStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[snapshotStatus.ordinal()]) {
            case -1: 
            case 1: {
                ProfilerIntegrationWidgetAction.update$refreshPresentationState(this, e, editor2, new ProfilerActionStateDisabled());
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            case 2: {
                ProfilerIntegrationWidgetAction.update$refreshPresentationState(this, e, editor2, new ProfilerActionStateNoDataAvailable());
                break;
            }
            case 3: {
                ProfilerIntegrationWidgetAction.update$refreshPresentationState(this, e, editor2, new ProfilerActionStateHasDataToFetch(profilerStatus));
                break;
            }
            case 4: {
                ProfilerIntegrationWidgetAction.update$refreshPresentationState(this, e, editor2, new ProfilerActionStateFetchingInProgress(profilerStatus));
                break;
            }
            case 5: {
                ProfilerIntegrationWidgetAction.update$refreshPresentationState(this, e, editor2, new ProfilerActionStateDataIsUpToDate(profilerStatus));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnityScriptFile(Project project, Editor editor) {
        if ((Boolean)UnityProjectDiscovererKt.isUnityProject(project).getValue() == false) return false;
        VirtualFile virtualFile = editor.getVirtualFile();
        if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getFileType() : null), (Object)CSharpFileType.INSTANCE)) return false;
        return true;
    }

    private final void updatePresentation(Presentation presentation, Editor editor, ProfilerActionStateSetup snapshotStateSetup) {
        presentation.setIcon(snapshotStateSetup.getIcon());
        HelpTooltip tooltip = new HelpTooltip().setTitle(snapshotStateSetup.getTooltipTitle()).setDescription(snapshotStateSetup.getTooltipDescription()).setLink(UnityUIBundle.Companion.message("unity.profiler.integration.widget.setting", new Object[0]), () -> ProfilerIntegrationWidgetAction.updatePresentation$lambda$1(editor));
        presentation.putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, (Object)tooltip);
    }

    private static final void update$refreshPresentationState(ProfilerIntegrationWidgetAction this$0, AnActionEvent $e, Editor editor, ProfilerActionStateSetup stateNoDataAvailable) {
        Presentation presentation = $e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        this$0.updatePresentation(presentation, editor, stateNoDataAvailable);
    }

    private static final void updatePresentation$lambda$1(Editor $editor) {
        ShowSettingsUtilImpl.Companion.showSettingsDialog($editor.getProject(), "preferences.build.unityPlugin", UnityUIBundle.Companion.message("unity.profiler.integration.widget.setting.filter", new Object[0]));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SnapshotStatus.values().length];
            try {
                nArray[SnapshotStatus.Disabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SnapshotStatus.NoSnapshotDataAvailable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SnapshotStatus.HasNewSnapshotDataToFetch.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SnapshotStatus.SnapshotDataFetchingInProgress.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SnapshotStatus.SnapshotDataIsUpToDate.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

