/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ui;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.ui.UnityUIBundle;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/UssDisabledEditorNotification;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUssFileSafe", "", "Companion", "intellij.rider.plugins.unity"})
public final class UssDisabledEditorNotification
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DO_NOT_SHOW_AGAIN_KEY = "unity.uss.css.plugin.disabled.do.not.show";
    @NotNull
    private static final String CSS_PLUGIN_ID = "com.intellij.css";

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (((Boolean)UnityProjectDiscovererKt.isUnityProject(project).getValue()).booleanValue() && this.isUssFileSafe(file)) {
            PluginId pluginId = PluginId.getId((String)CSS_PLUGIN_ID);
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
            if (PluginManagerCore.isDisabled((PluginId)pluginId)) {
                if (PropertiesComponent.getInstance((Project)project).getBoolean(DO_NOT_SHOW_AGAIN_KEY, false)) {
                    return null;
                }
                return arg_0 -> UssDisabledEditorNotification.collectNotificationData$lambda$3(project, arg_0);
            }
        }
        return null;
    }

    private final boolean isUssFileSafe(VirtualFile file) {
        return StringsKt.equals((String)file.getExtension(), (String)"uss", (boolean)true);
    }

    private static final void collectNotificationData$lambda$3$lambda$2$lambda$0(Project $project) {
        PluginId pluginId = PluginId.getId((String)CSS_PLUGIN_ID);
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginManagerCore.enablePlugin((PluginId)pluginId);
        PluginManagerMain.notifyPluginsUpdated((Project)$project);
        EditorNotifications.getInstance((Project)$project).updateAllNotifications();
    }

    private static final void collectNotificationData$lambda$3$lambda$2$lambda$1(Project $project) {
        PropertiesComponent.getInstance((Project)$project).setValue(DO_NOT_SHOW_AGAIN_KEY, true);
        EditorNotifications.getInstance((Project)$project).updateAllNotifications();
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$3(Project $project, FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel panel2 = editorNotificationPanel = new EditorNotificationPanel();
        boolean bl = false;
        panel2.text(UnityUIBundle.Companion.message("uss.disabled.editor.notification.panel.text", new Object[0]));
        panel2.createActionLabel(UnityUIBundle.Companion.message("uss.disabled.editor.notification.enable.css.plugin", new Object[0]), () -> UssDisabledEditorNotification.collectNotificationData$lambda$3$lambda$2$lambda$0($project));
        panel2.createActionLabel(UnityUIBundle.Companion.message("don.t.show.again", new Object[0]), () -> UssDisabledEditorNotification.collectNotificationData$lambda$3$lambda$2$lambda$1($project));
        return editorNotificationPanel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/unity/ui/UssDisabledEditorNotification$Companion;", "", "<init>", "()V", "DO_NOT_SHOW_AGAIN_KEY", "", "CSS_PLUGIN_ID", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

