/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.toolWindow.log;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.plugins.unity.toolWindow.log.UnityLogTokenType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J>\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenizer;", "", "<init>", "()V", "validTokens", "", "", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenType;", "startToEndMapping", "tokenize", "", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenizer$Token;", "fullString", "generateStyles", "", "tokens", "", "colorizeTokens", "i", "", "token", "addTokens", "lastTokenIndex", "tokenString", "type", "getTokenValue", "checkToken", "expectedToken", "startIndex", "parseColor", "Ljava/awt/Color;", "color", "Token", "intellij.rider.plugins.unity"})
public final class UnityLogTokenizer {
    @NotNull
    private final Map<String, UnityLogTokenType> validTokens;
    @NotNull
    private final Map<UnityLogTokenType, UnityLogTokenType> startToEndMapping;

    public UnityLogTokenizer() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"<b>", (Object)((Object)UnityLogTokenType.Bold)), TuplesKt.to((Object)"</b>", (Object)((Object)UnityLogTokenType.BoldEnd)), TuplesKt.to((Object)"<i>", (Object)((Object)UnityLogTokenType.Italic)), TuplesKt.to((Object)"</i>", (Object)((Object)UnityLogTokenType.ItalicEnd)), TuplesKt.to((Object)"<color=*>", (Object)((Object)UnityLogTokenType.Color)), TuplesKt.to((Object)"</color>", (Object)((Object)UnityLogTokenType.ColorEnd)), TuplesKt.to((Object)"<size=*>", (Object)((Object)UnityLogTokenType.Size)), TuplesKt.to((Object)"</size>", (Object)((Object)UnityLogTokenType.SizeEnd)), TuplesKt.to((Object)"<material=*>", (Object)((Object)UnityLogTokenType.Material)), TuplesKt.to((Object)"</material>", (Object)((Object)UnityLogTokenType.MaterialEnd)), TuplesKt.to((Object)"<quad=*>", (Object)((Object)UnityLogTokenType.Quad))};
        this.validTokens = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)UnityLogTokenType.Bold), (Object)((Object)UnityLogTokenType.BoldEnd)), TuplesKt.to((Object)((Object)UnityLogTokenType.Italic), (Object)((Object)UnityLogTokenType.ItalicEnd)), TuplesKt.to((Object)((Object)UnityLogTokenType.Color), (Object)((Object)UnityLogTokenType.ColorEnd)), TuplesKt.to((Object)((Object)UnityLogTokenType.Size), (Object)((Object)UnityLogTokenType.SizeEnd)), TuplesKt.to((Object)((Object)UnityLogTokenType.Material), (Object)((Object)UnityLogTokenType.MaterialEnd))};
        this.startToEndMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final List<Token> tokenize(@NotNull String fullString) {
        Intrinsics.checkNotNullParameter((Object)fullString, (String)"fullString");
        List tokens = new ArrayList();
        int lastTokenIndex = 0;
        int n = fullString.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            fullString.charAt(i);
            for (Map.Entry<String, UnityLogTokenType> validToken : this.validTokens.entrySet()) {
                int lastIndex = this.checkToken(fullString, validToken.getKey(), i2);
                if (lastIndex == -1) continue;
                String string = fullString.substring(i2, lastIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.addTokens(i2, lastTokenIndex, tokens, fullString, string, validToken.getValue());
                lastTokenIndex = lastIndex + 1;
            }
        }
        String string = fullString.substring(lastTokenIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        tokens.add(new Token(string, UnityLogTokenType.String, false, false, false, null, 60, null));
        this.generateStyles(tokens);
        return tokens;
    }

    private final void generateStyles(List<Token> tokens) {
        Iterator iterator = ((Iterable)tokens).iterator();
        int n = 0;
        block0: while (iterator.hasNext()) {
            int y;
            int n2;
            int i = n++;
            Token token = (Token)iterator.next();
            if (token.getType() == UnityLogTokenType.Bold) {
                n2 = ((Collection)tokens).size();
                for (int x = i; x < n2; ++x) {
                    if (tokens.get(x).getType() != UnityLogTokenType.BoldEnd || tokens.get(x).getUsed()) continue;
                    token.setUsed(true);
                    tokens.get(x).setUsed(true);
                    for (y = i; y < x; ++y) {
                        tokens.get(y).setBold(true);
                    }
                    continue block0;
                }
                continue;
            }
            if (token.getType() == UnityLogTokenType.Italic) {
                n2 = ((Collection)tokens).size();
                for (int x = i; x < n2; ++x) {
                    if (tokens.get(x).getType() != UnityLogTokenType.ItalicEnd || tokens.get(x).getUsed()) continue;
                    token.setUsed(true);
                    tokens.get(x).setUsed(true);
                    for (y = i; y < x; ++y) {
                        tokens.get(y).setItalic(true);
                    }
                    continue block0;
                }
                continue;
            }
            if (token.getType() == UnityLogTokenType.Color) {
                this.colorizeTokens(i, tokens, token);
                continue;
            }
            if (token.getType() == UnityLogTokenType.Quad) {
                token.setUsed(true);
                continue;
            }
            if (!this.validTokens.containsValue((Object)token.getType()) || !this.startToEndMapping.containsKey((Object)token.getType())) continue;
            UnityLogTokenType endToken = this.startToEndMapping.get((Object)token.getType());
            int n3 = ((Collection)tokens).size();
            for (int x = i; x < n3; ++x) {
                if (tokens.get(x).getType() != endToken || tokens.get(x).getUsed()) continue;
                token.setUsed(true);
                tokens.get(x).setUsed(true);
            }
        }
    }

    private final void colorizeTokens(int i, List<Token> tokens, Token token) {
        int n = ((Collection)tokens).size();
        for (int x = i + 1; x < n; ++x) {
            if (tokens.get(x).getType() == UnityLogTokenType.Color && !tokens.get(x).getUsed()) {
                this.colorizeTokens(x, tokens, tokens.get(x));
            }
            if (tokens.get(x).getType() != UnityLogTokenType.ColorEnd || tokens.get(x).getUsed()) continue;
            token.setUsed(true);
            tokens.get(x).setUsed(true);
            Color color = this.parseColor(this.getTokenValue(token.getToken()));
            for (int y = i; y < x; ++y) {
                if (tokens.get(y).getColor() != null) continue;
                tokens.get(y).setColor(color);
            }
            break;
        }
    }

    private final void addTokens(int i, int lastTokenIndex, List<Token> tokens, String fullString, String tokenString, UnityLogTokenType type) {
        if (i > lastTokenIndex) {
            String string = fullString.substring(lastTokenIndex, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            tokens.add(new Token(string, UnityLogTokenType.String, false, false, false, null, 60, null));
        }
        tokens.add(new Token(tokenString, type, false, false, false, null, 60, null));
    }

    private final String getTokenValue(String tokenString) {
        if (!StringsKt.contains$default((CharSequence)tokenString, (char)'=', (boolean)false, (int)2, null)) {
            return "";
        }
        String cleanedToken = StringsKt.replace$default((String)tokenString, (String)">", (String)"", (boolean)false, (int)4, null);
        String string = cleanedToken.substring(StringsKt.indexOf$default((CharSequence)cleanedToken, (char)'=', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = new char[]{'\"'};
        return StringsKt.trim((String)string, (char[])cArray);
    }

    private final int checkToken(String fullString, String expectedToken, int startIndex) {
        int expectedTokenIndex = 0;
        int n = fullString.length();
        for (int i = startIndex; i < n; ++i) {
            char currentChar = Character.toLowerCase(fullString.charAt(i));
            char expectedChar = Character.toLowerCase(expectedToken.charAt(expectedTokenIndex));
            if (expectedChar == '*') {
                if (currentChar != Character.toLowerCase(expectedToken.charAt(expectedTokenIndex + 1))) continue;
                ++expectedTokenIndex;
            } else if (currentChar != expectedChar) {
                return -1;
            }
            if (expectedTokenIndex == expectedToken.length() - 1) {
                return i;
            }
            ++expectedTokenIndex;
        }
        return -1;
    }

    private final Color parseColor(String color) {
        try {
            String string = color;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            switch (string2) {
                case "aqua": {
                    return Color.decode("#00ffff");
                }
                case "black": {
                    return Color.decode("#000000");
                }
                case "blue": {
                    return Color.decode("#0000ff");
                }
                case "brown": {
                    return Color.decode("#a52a2a");
                }
                case "cyan": {
                    return Color.decode("#00ffff");
                }
                case "darkblue": {
                    return Color.decode("#0000a0");
                }
                case "fuchsia": {
                    return Color.decode("#ff00ff");
                }
                case "green": {
                    return Color.decode("#008000");
                }
                case "grey": {
                    return Color.decode("#808080");
                }
                case "lightblue": {
                    return Color.decode("#add8e6");
                }
                case "lime": {
                    return Color.decode("#00ff00");
                }
                case "magenta": {
                    return Color.decode("#ff00ff");
                }
                case "maroon": {
                    return Color.decode("#800000");
                }
                case "navy": {
                    return Color.decode("#000080");
                }
                case "olive": {
                    return Color.decode("#808000");
                }
                case "orange": {
                    return Color.decode("#ffa500");
                }
                case "purple": {
                    return Color.decode("#800080");
                }
                case "red": {
                    return Color.decode("#ff0000");
                }
                case "silver": {
                    return Color.decode("#c0c0c0");
                }
                case "teal": {
                    return Color.decode("#008080");
                }
                case "white": {
                    return Color.decode("#ffffff");
                }
                case "yellow": {
                    return Color.decode("#ffff00");
                }
            }
            return color.length() == 8 ? Color.decode(StringsKt.substring((String)color, (IntRange)new IntRange(0, 7))) : (color.length() == 7 ? Color.decode(color) : null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JG\u0010$\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenizer$Token;", "", "token", "", "type", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenType;", "bold", "", "italic", "used", "color", "Ljava/awt/Color;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenType;ZZZLjava/awt/Color;)V", "getToken", "()Ljava/lang/String;", "getType", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogTokenType;", "getBold", "()Z", "setBold", "(Z)V", "getItalic", "setItalic", "getUsed", "setUsed", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.plugins.unity"})
    public static final class Token {
        @NotNull
        private final String token;
        @NotNull
        private final UnityLogTokenType type;
        private boolean bold;
        private boolean italic;
        private boolean used;
        @Nullable
        private Color color;

        public Token(@NlsSafe @NotNull String token, @NotNull UnityLogTokenType type, boolean bold, boolean italic, boolean used, @Nullable Color color) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.token = token;
            this.type = type;
            this.bold = bold;
            this.italic = italic;
            this.used = used;
            this.color = color;
        }

        public /* synthetic */ Token(String string, UnityLogTokenType unityLogTokenType, boolean bl, boolean bl2, boolean bl3, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                color = null;
            }
            this(string, unityLogTokenType, bl, bl2, bl3, color);
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @NotNull
        public final UnityLogTokenType getType() {
            return this.type;
        }

        public final boolean getBold() {
            return this.bold;
        }

        public final void setBold(boolean bl) {
            this.bold = bl;
        }

        public final boolean getItalic() {
            return this.italic;
        }

        public final void setItalic(boolean bl) {
            this.italic = bl;
        }

        public final boolean getUsed() {
            return this.used;
        }

        public final void setUsed(boolean bl) {
            this.used = bl;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color) {
            this.color = color;
        }

        @NotNull
        public final String component1() {
            return this.token;
        }

        @NotNull
        public final UnityLogTokenType component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.bold;
        }

        public final boolean component4() {
            return this.italic;
        }

        public final boolean component5() {
            return this.used;
        }

        @Nullable
        public final Color component6() {
            return this.color;
        }

        @NotNull
        public final Token copy(@NlsSafe @NotNull String token, @NotNull UnityLogTokenType type, boolean bold, boolean italic, boolean used, @Nullable Color color) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new Token(token, type, bold, italic, used, color);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, UnityLogTokenType unityLogTokenType, boolean bl, boolean bl2, boolean bl3, Color color, int n, Object object) {
            if ((n & 1) != 0) {
                string = token.token;
            }
            if ((n & 2) != 0) {
                unityLogTokenType = token.type;
            }
            if ((n & 4) != 0) {
                bl = token.bold;
            }
            if ((n & 8) != 0) {
                bl2 = token.italic;
            }
            if ((n & 0x10) != 0) {
                bl3 = token.used;
            }
            if ((n & 0x20) != 0) {
                color = token.color;
            }
            return token.copy(string, unityLogTokenType, bl, bl2, bl3, color);
        }

        @NotNull
        public String toString() {
            return "Token(token=" + this.token + ", type=" + this.type + ", bold=" + this.bold + ", italic=" + this.italic + ", used=" + this.used + ", color=" + this.color + ")";
        }

        public int hashCode() {
            int result = this.token.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.bold);
            result = result * 31 + Boolean.hashCode(this.italic);
            result = result * 31 + Boolean.hashCode(this.used);
            result = result * 31 + (this.color == null ? 0 : this.color.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.token, (Object)token.token)) {
                return false;
            }
            if (this.type != token.type) {
                return false;
            }
            if (this.bold != token.bold) {
                return false;
            }
            if (this.italic != token.italic) {
                return false;
            }
            if (this.used != token.used) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.color, (Object)token.color);
        }
    }
}

