/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.toolWindow.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.plugins.unity.UnityProjectLifetimeService;
import com.jetbrains.rider.plugins.unity.model.LogEvent;
import com.jetbrains.rider.plugins.unity.model.LogEventMode;
import com.jetbrains.rider.plugins.unity.model.LogEventType;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.toolWindow.UnityToolWindowFactory;
import com.jetbrains.rider.plugins.unity.toolWindow.log.LogPanelItem;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 H2\u00020\u0001:\u0006HIJKLMB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002J\u0006\u0010A\u001a\u00020:R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001c\u001a\u00060\u001dR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0015\u0010 \u001a\u00060!R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0015\u0010$\u001a\u00060%R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0015\u0010(\u001a\u00060)R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170-\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u001e\u00102\u001a\u000603R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0017\u00108\u001a\b\u0012\u0004\u0012\u00020:09\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001d\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001b09\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010<R\u0017\u0010?\u001a\b\u0012\u0004\u0012\u00020:09\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010<R\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006N"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lock", "Ljava/lang/Object;", "maxItemsCount", "", "getMaxItemsCount", "()I", "mergingUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "mergingUpdateQueueAction", "Lcom/intellij/util/ui/update/Update;", "isVisibleEvent", "", "event", "Lcom/jetbrains/rider/plugins/unity/model/LogEvent;", "getVisibleEvents", "", "typeFilters", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TypeFilters;", "getTypeFilters", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TypeFilters;", "modeFilters", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$ModeFilters;", "getModeFilters", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$ModeFilters;", "textFilter", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TextFilter;", "getTextFilter", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TextFilter;", "events", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Events;", "getEvents", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Events;", "mergeSimilarItems", "Lcom/jetbrains/rd/util/reactive/Property;", "getMergeSimilarItems", "()Lcom/jetbrains/rd/util/reactive/Property;", "autoscroll", "getAutoscroll", "timeFilters", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TimeFilters;", "getTimeFilters", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TimeFilters;", "setTimeFilters", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TimeFilters;)V", "onFirstRemoved", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getOnFirstRemoved", "()Lcom/jetbrains/rd/util/reactive/Signal;", "onChanged", "getOnChanged", "onCleared", "getOnCleared", "queueUpdate", "selectedItem", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/LogPanelItem;", "getSelectedItem", "()Lcom/jetbrains/rider/plugins/unity/toolWindow/log/LogPanelItem;", "setSelectedItem", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/LogPanelItem;)V", "Companion", "TypeFilters", "ModeFilters", "TextFilter", "TimeFilters", "Events", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n774#2:224\n865#2,2:225\n*S KotlinDebug\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel\n*L\n178#1:224\n178#1:225,2\n*E\n"})
public final class UnityLogPanelModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final ToolWindow toolWindow;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Object lock;
    private final int maxItemsCount;
    @NotNull
    private final MergingUpdateQueue mergingUpdateQueue;
    @NotNull
    private final Update mergingUpdateQueueAction;
    @NotNull
    private final TypeFilters typeFilters;
    @NotNull
    private final ModeFilters modeFilters;
    @NotNull
    private final TextFilter textFilter;
    @NotNull
    private final Events events;
    @NotNull
    private final Property<Boolean> mergeSimilarItems;
    @NotNull
    private final Property<Boolean> autoscroll;
    @NotNull
    private TimeFilters timeFilters;
    @NotNull
    private final Signal<Unit> onFirstRemoved;
    @NotNull
    private final Signal<List<LogEvent>> onChanged;
    @NotNull
    private final Signal<Unit> onCleared;
    @Nullable
    private LogPanelItem selectedItem;

    public UnityLogPanelModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.toolWindow = UnityToolWindowFactory.Companion.getToolWindow(this.project);
        this.lifetime = UnityProjectLifetimeService.Companion.getLifetime(this.project);
        this.lock = new Object();
        this.maxItemsCount = 10000;
        ToolWindow toolWindow = this.toolWindow;
        this.mergingUpdateQueue = new MergingUpdateQueue("UnityLogPanelModel->onChanged", 250, true, toolWindow != null ? toolWindow.getComponent() : null, null, null, false, 112, null).setRestartTimerOnAdd(false);
        this.mergingUpdateQueueAction = new Update(this){
            final /* synthetic */ UnityLogPanelModel this$0;
            {
                this.this$0 = $receiver;
                super((Object)"UnityLogPanelView->onChanged", false, 0, 6, null);
            }

            public void run() {
                if (UnityLogPanelModel.access$getToolWindow$p(this.this$0) != null && UnityLogPanelModel.access$getToolWindow$p(this.this$0).isVisible()) {
                    this.this$0.getOnChanged().fire((Object)UnityLogPanelModel.access$getVisibleEvents(this.this$0));
                }
            }
        };
        this.typeFilters = new TypeFilters();
        this.modeFilters = new ModeFilters();
        this.textFilter = new TextFilter();
        this.events = new Events();
        this.mergeSimilarItems = new Property((Object)false);
        this.autoscroll = new Property((Object)false);
        this.timeFilters = new TimeFilters();
        this.onFirstRemoved = Signal.Companion.Void();
        this.onChanged = new Signal();
        this.onCleared = Signal.Companion.Void();
        this.typeFilters.getOnChanged().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$2(this, arg_0));
        this.modeFilters.getOnChanged().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$3(this, arg_0));
        this.textFilter.getOnChanged().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$4(this, arg_0));
        this.timeFilters.getOnChanged().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$5(this, arg_0));
        this.events.getOnChanged().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$6(this, arg_0));
        this.mergeSimilarItems.advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$7(this, arg_0));
        FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getConsoleLogging().getLastInitTime().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$8(this, arg_0));
        FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)this.project)).getConsoleLogging().getLastPlayTime().advise(this.lifetime, arg_0 -> UnityLogPanelModel._init_$lambda$9(this, arg_0));
        if (this.toolWindow != null) {
            MessageBus messageBus = this.project.getMessageBus();
            Disposable disposable = this.toolWindow.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            MessageBusConnection messageBusConnection = messageBus.connect(disposable);
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

                public void toolWindowShown(ToolWindow tw) {
                    Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
                    super.toolWindowShown(tw);
                    if (Intrinsics.areEqual((Object)tw.getId(), (Object)toolWindow.getId())) {
                        mergingUpdateQueueAction.run();
                    }
                }
            });
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final int getMaxItemsCount() {
        return this.maxItemsCount;
    }

    private final boolean isVisibleEvent(LogEvent event) {
        return this.typeFilters.getShouldBeShown(event.getType()) && this.modeFilters.getShouldBeShown(event.getMode()) && this.textFilter.getShouldBeShown(event.getMessage()) && this.timeFilters.getShouldBeShown(event.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<LogEvent> getVisibleEvents() {
        Object object = this.lock;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.events.getAllEvents();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LogEvent it = (LogEvent)element$iv$iv;
                boolean bl2 = false;
                if (!this.isVisibleEvent(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    @NotNull
    public final TypeFilters getTypeFilters() {
        return this.typeFilters;
    }

    @NotNull
    public final ModeFilters getModeFilters() {
        return this.modeFilters;
    }

    @NotNull
    public final TextFilter getTextFilter() {
        return this.textFilter;
    }

    @NotNull
    public final Events getEvents() {
        return this.events;
    }

    @NotNull
    public final Property<Boolean> getMergeSimilarItems() {
        return this.mergeSimilarItems;
    }

    @NotNull
    public final Property<Boolean> getAutoscroll() {
        return this.autoscroll;
    }

    @NotNull
    public final TimeFilters getTimeFilters() {
        return this.timeFilters;
    }

    public final void setTimeFilters(@NotNull TimeFilters timeFilters) {
        Intrinsics.checkNotNullParameter((Object)timeFilters, (String)"<set-?>");
        this.timeFilters = timeFilters;
    }

    @NotNull
    public final Signal<Unit> getOnFirstRemoved() {
        return this.onFirstRemoved;
    }

    @NotNull
    public final Signal<List<LogEvent>> getOnChanged() {
        return this.onChanged;
    }

    @NotNull
    public final Signal<Unit> getOnCleared() {
        return this.onCleared;
    }

    public final void queueUpdate() {
        this.mergingUpdateQueue.queue(this.mergingUpdateQueueAction);
    }

    @Nullable
    public final LogPanelItem getSelectedItem() {
        return this.selectedItem;
    }

    public final void setSelectedItem(@Nullable LogPanelItem logPanelItem) {
        this.selectedItem = logPanelItem;
    }

    private static final Unit _init_$lambda$2(UnityLogPanelModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(UnityLogPanelModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(UnityLogPanelModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(UnityLogPanelModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(UnityLogPanelModel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(UnityLogPanelModel this$0, boolean it) {
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(UnityLogPanelModel this$0, long it) {
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(UnityLogPanelModel this$0, long it) {
        this$0.queueUpdate();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getVisibleEvents(UnityLogPanelModel $this) {
        return $this.getVisibleEvents();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,223:1\n31#2,2:224\n*S KotlinDebug\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Companion\n*L\n25#1:224,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnityLogPanelModel getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UnityLogPanelModel> serviceClass$iv = UnityLogPanelModel.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UnityLogPanelModel)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Events;", "", "<init>", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;)V", "allEvents", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/plugins/unity/model/LogEvent;", "Lkotlin/collections/ArrayList;", "getAllEvents", "()Ljava/util/ArrayList;", "clear", "", "addEvent", "event", "onChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnChanged", "()Lcom/jetbrains/rd/util/reactive/Signal;", "onAutoscrollChanged", "", "getOnAutoscrollChanged", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$Events\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public final class Events {
        @NotNull
        private final ArrayList<LogEvent> allEvents = new ArrayList();
        @NotNull
        private final Signal<Unit> onChanged = Signal.Companion.Void();
        @NotNull
        private final Signal<Boolean> onAutoscrollChanged = new Signal();

        @NotNull
        public final ArrayList<LogEvent> getAllEvents() {
            return this.allEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            Object object = UnityLogPanelModel.this.lock;
            synchronized (object) {
                boolean bl = false;
                this.allEvents.clear();
                Unit unit = Unit.INSTANCE;
            }
            UnityLogPanelModel.this.setSelectedItem(null);
            InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
            InterfacesKt.fire((ISignal)((ISignal)UnityLogPanelModel.this.getOnCleared()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addEvent(@NotNull LogEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = UnityLogPanelModel.this.lock;
            UnityLogPanelModel unityLogPanelModel = UnityLogPanelModel.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (((Collection)this.allEvents).size() > unityLogPanelModel.getMaxItemsCount()) {
                    CollectionsKt.removeFirst((List)this.allEvents);
                    if (unityLogPanelModel.isVisibleEvent(event)) {
                        unityLogPanelModel.queueUpdate();
                    }
                }
                boolean bl2 = this.allEvents.add(event);
            }
            if (UnityLogPanelModel.this.isVisibleEvent(event)) {
                UnityLogPanelModel.this.queueUpdate();
            }
        }

        @NotNull
        public final Signal<Unit> getOnChanged() {
            return this.onChanged;
        }

        @NotNull
        public final Signal<Boolean> getOnAutoscrollChanged() {
            return this.onAutoscrollChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$ModeFilters;", "", "<init>", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;)V", "showEdit", "", "showPlay", "getShouldBeShown", "mode", "Lcom/jetbrains/rider/plugins/unity/model/LogEventMode;", "setShouldBeShown", "", "value", "onChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnChanged", "()Lcom/jetbrains/rd/util/reactive/Signal;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$ModeFilters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public final class ModeFilters {
        private boolean showEdit = true;
        private boolean showPlay = true;
        @NotNull
        private final Signal<Unit> onChanged = Signal.Companion.Void();

        public final boolean getShouldBeShown(@NotNull LogEventMode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1 -> this.showEdit;
                case 2 -> this.showPlay;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setShouldBeShown(@NotNull LogEventMode mode, boolean value) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    Object object = UnityLogPanelModel.this.lock;
                    synchronized (object) {
                        boolean $i$a$-synchronized-UnityLogPanelModel$ModeFilters$setShouldBeShown$32 = false;
                        this.showEdit = value;
                        Unit $i$a$-synchronized-UnityLogPanelModel$ModeFilters$setShouldBeShown$32 = Unit.INSTANCE;
                    }
                    InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
                    break;
                }
                case 2: {
                    Object object = UnityLogPanelModel.this.lock;
                    synchronized (object) {
                        boolean bl = false;
                        this.showPlay = value;
                        Unit unit = Unit.INSTANCE;
                    }
                    InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @NotNull
        public final Signal<Unit> getOnChanged() {
            return this.onChanged;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LogEventMode.values().length];
                try {
                    nArray[LogEventMode.Edit.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogEventMode.Play.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TextFilter;", "", "<init>", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;)V", "searchTerm", "", "getShouldBeShown", "", "text", "setPattern", "", "value", "onChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnChanged", "()Lcom/jetbrains/rd/util/reactive/Signal;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TextFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public final class TextFilter {
        @NotNull
        private String searchTerm = "";
        @NotNull
        private final Signal<Unit> onChanged = Signal.Companion.Void();

        public final boolean getShouldBeShown(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return StringsKt.contains((CharSequence)text, (CharSequence)this.searchTerm, (boolean)true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setPattern(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object object = UnityLogPanelModel.this.lock;
            synchronized (object) {
                boolean bl = false;
                this.searchTerm = value;
                Unit unit = Unit.INSTANCE;
            }
            InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
        }

        @NotNull
        public final Signal<Unit> getOnChanged() {
            return this.onChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TimeFilters;", "", "<init>", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;)V", "showBeforePlay", "", "showBeforeInit", "getShouldBeShown", "time", "", "getShouldBeShownBeforeInit", "getShouldBeShownBeforePlay", "setShowBeforePlay", "", "value", "setShowBeforeLastBuild", "onChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnChanged", "()Lcom/jetbrains/rd/util/reactive/Signal;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TimeFilters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public final class TimeFilters {
        private boolean showBeforePlay = true;
        private boolean showBeforeInit = true;
        @NotNull
        private final Signal<Unit> onChanged = Signal.Companion.Void();

        public final boolean getShouldBeShown(long time) {
            return !(!this.showBeforeInit && time <= ((Number)InterfacesKt.valueOrDefault(FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)UnityLogPanelModel.this.getProject())).getConsoleLogging().getLastInitTime(), (Object)0L)).longValue() || !this.showBeforePlay && time <= ((Number)InterfacesKt.valueOrDefault(FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)UnityLogPanelModel.this.getProject())).getConsoleLogging().getLastPlayTime(), (Object)0L)).longValue());
        }

        public final boolean getShouldBeShownBeforeInit() {
            return this.showBeforeInit;
        }

        public final boolean getShouldBeShownBeforePlay() {
            return this.showBeforePlay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setShowBeforePlay(boolean value) {
            Object object = UnityLogPanelModel.this.lock;
            synchronized (object) {
                boolean bl = false;
                this.showBeforePlay = value;
                Unit unit = Unit.INSTANCE;
            }
            InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setShowBeforeLastBuild(boolean value) {
            Object object = UnityLogPanelModel.this.lock;
            synchronized (object) {
                boolean bl = false;
                this.showBeforeInit = value;
                Unit unit = Unit.INSTANCE;
            }
            InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
        }

        @NotNull
        public final Signal<Unit> getOnChanged() {
            return this.onChanged;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TypeFilters;", "", "<init>", "(Lcom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel;)V", "showErrors", "", "showWarnings", "showMessages", "getShouldBeShown", "type", "Lcom/jetbrains/rider/plugins/unity/model/LogEventType;", "setShouldBeShown", "", "value", "onChanged", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnChanged", "()Lcom/jetbrains/rd/util/reactive/Signal;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nUnityLogPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityLogPanelModel.kt\ncom/jetbrains/rider/plugins/unity/toolWindow/log/UnityLogPanelModel$TypeFilters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
    public final class TypeFilters {
        private boolean showErrors = true;
        private boolean showWarnings = true;
        private boolean showMessages = true;
        @NotNull
        private final Signal<Unit> onChanged = Signal.Companion.Void();

        public final boolean getShouldBeShown(@NotNull LogEventType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> this.showErrors;
                case 2 -> this.showWarnings;
                case 3 -> this.showMessages;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setShouldBeShown(@NotNull LogEventType type, boolean value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Object object = UnityLogPanelModel.this.lock;
                    synchronized (object) {
                        boolean $i$a$-synchronized-UnityLogPanelModel$TypeFilters$setShouldBeShown$42 = false;
                        this.showErrors = value;
                        Unit $i$a$-synchronized-UnityLogPanelModel$TypeFilters$setShouldBeShown$42 = Unit.INSTANCE;
                    }
                    InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
                    break;
                }
                case 2: {
                    Object object = UnityLogPanelModel.this.lock;
                    synchronized (object) {
                        boolean $i$a$-synchronized-UnityLogPanelModel$TypeFilters$setShouldBeShown$52 = false;
                        this.showWarnings = value;
                        Unit $i$a$-synchronized-UnityLogPanelModel$TypeFilters$setShouldBeShown$52 = Unit.INSTANCE;
                    }
                    InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
                    break;
                }
                case 3: {
                    Object object = UnityLogPanelModel.this.lock;
                    synchronized (object) {
                        boolean bl = false;
                        this.showMessages = value;
                        Unit unit = Unit.INSTANCE;
                    }
                    InterfacesKt.fire((ISignal)((ISignal)this.onChanged));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @NotNull
        public final Signal<Unit> getOnChanged() {
            return this.onChanged;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LogEventType.values().length];
                try {
                    nArray[LogEventType.Error.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogEventType.Warning.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogEventType.Message.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

