/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run.configurations.unityExe;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.plugins.unity.run.configurations.unityExe.UnityExeDebugProfileState;
import com.jetbrains.rider.plugins.unity.ui.UnityUIManagerKt;
import com.jetbrains.rider.plugins.unity.util.UnityInstallationFinder;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.exe.ExeConfiguration;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationParameters;
import com.jetbrains.rider.run.configurations.remote.DotNetRemoteConfiguration;
import com.jetbrains.rider.run.configurations.remote.MonoRemoteConfigType;
import com.jetbrains.rider.run.configurations.remote.RemoteConfiguration;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreDebugProfile;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/configurations/unityExe/UnityExeConfiguration;", "Lcom/jetbrains/rider/run/configurations/exe/ExeConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "params", "Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationParameters;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationParameters;)V", "isNative", "", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "getRunProfileStateAsync", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/execution/Executor;Lcom/intellij/execution/runners/ExecutionEnvironment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDotNetCoreDebugProfile", "Lcom/jetbrains/rider/run/dotNetCore/DotNetCoreDebugProfile;", "toDotNetExecutable", "Lcom/jetbrains/rider/runtime/DotNetExecutable;", "getStateAsync", "Lorg/jetbrains/concurrency/Promise;", "intellij.rider.plugins.unity"})
public final class UnityExeConfiguration
extends ExeConfiguration {
    public UnityExeConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull ExeConfigurationParameters params) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super(name, project, factory, params);
    }

    public boolean isNative() {
        return false;
    }

    @NotNull
    public RunConfiguration clone() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        UnityExeConfiguration newConfiguration = new UnityExeConfiguration(string, project, configurationFactory, this.getParameters().copy());
        newConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        this.copyCopyableDataTo((UserDataHolderBase)newConfiguration);
        return (RunConfiguration)newConfiguration;
    }

    @Nullable
    public Object getRunProfileStateAsync(@NotNull Executor executor, @NotNull ExecutionEnvironment environment, @NotNull Continuation<? super RunProfileState> $completion) {
        String string = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String executorId = string;
        if (Intrinsics.areEqual((Object)executorId, (Object)"Debug")) {
            RunProfileState runProfileState;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (UnityUIManagerKt.hasTrueValue(UnityInstallationFinder.Companion.getInstance(project).isCoreCLR())) {
                runProfileState = (RunProfileState)this.getDotNetCoreDebugProfile(environment);
            } else {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                ConfigurationFactory configurationFactory = (ConfigurationFactory)((MonoRemoteConfigType)ConfigurationTypeUtil.findConfigurationType(MonoRemoteConfigType.class)).getFactory();
                String string2 = this.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                runProfileState = (RunProfileState)new UnityExeDebugProfileState(this, (RemoteConfiguration)new DotNetRemoteConfiguration(project2, configurationFactory, string2), environment, false, 8, null);
            }
            return runProfileState;
        }
        return super.getRunProfileStateAsync(executor, environment, $completion);
    }

    @NotNull
    public final DotNetCoreDebugProfile getDotNetCoreDebugProfile(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RiderDotNetActiveRuntimeHost activeRuntimeHost = RiderDotNetActiveRuntimeHost.Companion.getInstance(project);
        DotNetCoreRuntime dotNetCoreRuntime = (DotNetCoreRuntime)activeRuntimeHost.getDotNetCoreRuntime().getValue();
        if (dotNetCoreRuntime == null) {
            throw new CantRunException(RiderMultiPlatformBundle.Companion.message("rider.mac.unable.to.get.runtime.information.message", new Object[0]));
        }
        DotNetCoreRuntime dotNetCoreRuntime2 = dotNetCoreRuntime;
        return new DotNetCoreDebugProfile(dotNetCoreRuntime2, this.toDotNetExecutable(), environment, dotNetCoreRuntime2.getCliExePath());
    }

    private final DotNetExecutable toDotNetExecutable() {
        return new DotNetExecutable(this.getParameters().getExePath(), null, this.getParameters().getWorkingDirectory(), this.getParameters().getProgramParameters(), false, this.getParameters().getUseExternalConsole(), this.getParameters().getEnvs(), false, UnityExeConfiguration::toDotNetExecutable$lambda$0, null, "", true, null, null, false, 28672, null);
    }

    @Deprecated(message="Please, override 'getRunProfileStateAsync' instead")
    @NotNull
    public Promise<RunProfileState> getStateAsync(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Object[] objectArray = new Object[]{"getStateAsync"};
        throw new UnsupportedOperationException(RiderRunBundle.Companion.message("obsolete.synchronous.api.is.used.message", objectArray));
    }

    private static final Unit toDotNetExecutable$lambda$0(ExecutionEnvironment executionEnvironment, RunProfile runProfile, ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"<unused var>");
        return Unit.INSTANCE;
    }
}

