/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run.configurations;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.plugins.unity.UnityPluginEnvironment;
import com.jetbrains.rider.plugins.unity.model.debuggerWorker.UnityBundleInfo;
import com.jetbrains.rider.plugins.unity.run.DefaultRunConfigurationGenerator;
import com.jetbrains.rider.plugins.unity.run.UnityAndroidAdbProcess;
import com.jetbrains.rider.plugins.unity.run.UnityEditor;
import com.jetbrains.rider.plugins.unity.run.UnityEditorHelper;
import com.jetbrains.rider.plugins.unity.run.UnityIosUsbProcess;
import com.jetbrains.rider.plugins.unity.run.UnityLocalUwpPlayer;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.run.UnityVirtualPlayer;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachToEditorRunConfiguration;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityConfigurationFactoryBase;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityEditorDebugConfigurationType;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfiguration;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfigurationOptions;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfigurationType;
import com.jetbrains.rider.plugins.unity.util.EditorInstanceJson;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspaceExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a\"\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001a\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0019"}, d2={"isAttachedToUnityEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "attachToUnityEditor", "", "attachToUnityProcess", "process", "Lcom/jetbrains/rider/plugins/unity/run/UnityProcess;", "createAttachToUnityEditorConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "name", "", "play", "removeRunConfigurations", "predicate", "Lkotlin/Function1;", "getUnityEditorRunConfiguration", "isRunning", "configurationSettings", "startDebugRunConfiguration", "getUnityBundlesList", "", "Lcom/jetbrains/rider/plugins/unity/model/debuggerWorker/UnityBundleInfo;", "getUnityPackagesList", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationUtil.kt\ncom/jetbrains/rider/plugins/unity/run/configurations/RunConfigurationUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1755#2,3:181\n295#2,2:184\n774#2:186\n865#2,2:187\n1863#2,2:189\n295#2,2:191\n1557#2:193\n1628#2,3:194\n*S KotlinDebug\n*F\n+ 1 RunConfigurationUtil.kt\ncom/jetbrains/rider/plugins/unity/run/configurations/RunConfigurationUtilKt\n*L\n26#1:181,3\n64#1:184,2\n131#1:186\n131#1:187,2\n131#1:189,2\n142#1:191,2\n179#1:193\n179#1:194,3\n*E\n"})
public final class RunConfigurationUtilKt {
    public static final boolean isAttachedToUnityEditor(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            UnityEditorDebugConfigurationType configurationType = (UnityEditorDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityEditorDebugConfigurationType.class);
            Iterable $this$any$iv = RunManager.Companion.getInstance(project).getConfigurationSettingsList((ConfigurationType)configurationType);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl2 = false;
                    if (!RunConfigurationUtilKt.isRunning(project, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final void attachToUnityEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunConfigurationUtilKt.getUnityEditorRunConfiguration(project);
        if (runnerAndConfigurationSettings == null) {
            runnerAndConfigurationSettings = RunConfigurationUtilKt.createAttachToUnityEditorConfiguration(project, DefaultRunConfigurationGenerator.Companion.getATTACH_CONFIGURATION_NAME(), false);
        }
        RunnerAndConfigurationSettings configurationSettings = runnerAndConfigurationSettings;
        RunConfigurationUtilKt.startDebugRunConfiguration(project, configurationSettings);
    }

    public static final void attachToUnityProcess(@NotNull Project project, @NotNull UnityProcess process) {
        Object v4;
        Object object;
        RunManager runManager;
        block18: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            if (process instanceof UnityEditor) {
                EditorInstanceJson.EditorInstanceJsonContents editorInstanceJsonContents = EditorInstanceJson.Companion.getInstance(project).getContents();
                boolean bl = editorInstanceJsonContents != null ? editorInstanceJsonContents.getProcess_id() == ((UnityEditor)process).getPid() : false;
                if (bl) {
                    RunConfigurationUtilKt.attachToUnityEditor(project);
                    return;
                }
            }
            runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object object2;
                Object element$iv = object.next();
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                Object object3 = runConfiguration instanceof UnityPlayerDebugConfiguration ? (UnityPlayerDebugConfiguration)runConfiguration : null;
                if (!(Intrinsics.areEqual((Object)(object3 != null && (object3 = object3.getState()) != null ? ((UnityPlayerDebugConfigurationOptions)((Object)object3)).getPlayerId() : null), (Object)process.getId()) && Intrinsics.areEqual((Object)((object2 = (runConfiguration = it.getConfiguration()) instanceof UnityPlayerDebugConfiguration ? (UnityPlayerDebugConfiguration)runConfiguration : null) != null && (object2 = ((UnityPlayerDebugConfiguration)((Object)object2)).getState()) != null ? ((UnityPlayerDebugConfigurationOptions)((Object)object2)).getPlayerInstanceId() : null), (Object)process.getPlayerInstanceId()))) continue;
                v4 = element$iv;
                break block18;
            }
            v4 = null;
        }
        RunnerAndConfigurationSettings configurationSettings = v4;
        if (configurationSettings == null) {
            Object object4;
            UnityProcess $i$f$firstOrNull = process;
            if ($i$f$firstOrNull instanceof UnityEditor) {
                String string = process.getDisplayName();
                String string2 = process.getProjectName();
                if (string2 == null) {
                    string2 = "Unknown Project";
                }
                object4 = string + " (" + string2 + ")";
            } else {
                object4 = $i$f$firstOrNull instanceof UnityEditorHelper ? process.getDisplayName() + " (" + ((UnityEditorHelper)process).getRoleName() + ")" : ($i$f$firstOrNull instanceof UnityVirtualPlayer ? ((UnityVirtualPlayer)process).getPlayerName() : process.getDisplayName());
            }
            Object displayName = object4;
            UnityPlayerDebugConfigurationType configurationType = (UnityPlayerDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityPlayerDebugConfigurationType.class);
            configurationSettings = runManager.createConfiguration((String)displayName, (ConfigurationFactory)configurationType.getAttachToPlayerFactory());
            RunConfiguration runConfiguration = configurationSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfiguration");
            Object $this$attachToUnityProcess_u24lambda_u242 = object = (UnityPlayerDebugConfiguration)runConfiguration;
            boolean bl = false;
            ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPlayerId(process.getId());
            ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPlayerInstanceId(process.getPlayerInstanceId());
            ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setHost(process.getHost());
            ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPort(process.getPort());
            ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setProjectName(process.getProjectName());
            UnityProcess unityProcess = process;
            if (unityProcess instanceof UnityIosUsbProcess) {
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setDeviceId(((UnityIosUsbProcess)process).getDeviceId());
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setDeviceName(((UnityIosUsbProcess)process).getDeviceDisplayName());
            } else if (unityProcess instanceof UnityAndroidAdbProcess) {
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setDeviceId(((UnityAndroidAdbProcess)process).getDeviceId());
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setDeviceName(((UnityAndroidAdbProcess)process).getDeviceDisplayName());
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setAndroidPackageUid(((UnityAndroidAdbProcess)process).getPackageUid());
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPackageName(((UnityAndroidAdbProcess)process).getPackageName());
            } else if (unityProcess instanceof UnityLocalUwpPlayer) {
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPackageName(((UnityLocalUwpPlayer)process).getPackageName());
            } else if (unityProcess instanceof UnityEditor) {
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPid(((UnityEditor)process).getPid());
            } else if (unityProcess instanceof UnityEditorHelper) {
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setPid(((UnityEditorHelper)process).getPid());
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setRoleName(((UnityEditorHelper)process).getRoleName());
            } else if (unityProcess instanceof UnityVirtualPlayer) {
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setVirtualPlayerId(((UnityVirtualPlayer)process).getVirtualPlayerId());
                ((UnityPlayerDebugConfiguration)((Object)$this$attachToUnityProcess_u24lambda_u242)).getState().setVirtualPlayerName(((UnityVirtualPlayer)process).getPlayerName());
            }
            runManager.setTemporaryConfiguration(configurationSettings);
        }
        RunConfigurationUtilKt.startDebugRunConfiguration(project, configurationSettings);
    }

    @NotNull
    public static final RunnerAndConfigurationSettings createAttachToUnityEditorConfiguration(@NotNull Project project, @NotNull String name, boolean play) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RunManager runManager = RunManager.Companion.getInstance(project);
        UnityEditorDebugConfigurationType configurationType = (UnityEditorDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityEditorDebugConfigurationType.class);
        UnityConfigurationFactoryBase factory = play ? (UnityConfigurationFactoryBase)configurationType.getAttachToEditorAndPlayFactory() : (UnityConfigurationFactoryBase)configurationType.getAttachToEditorFactory();
        RunnerAndConfigurationSettings runConfiguration = runManager.createConfiguration(name, (ConfigurationFactory)factory);
        runConfiguration.storeInLocalWorkspace();
        runManager.addConfiguration(runConfiguration);
        return runConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public static final void removeRunConfigurations(@NotNull Project project, @NotNull Function1<? super RunnerAndConfigurationSettings, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        RunManager runManager = RunManager.Companion.getInstance(project);
        Iterable $this$filter$iv = runManager.getAllSettings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)predicate.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
            boolean bl = false;
            runManager.removeConfiguration(it);
        }
    }

    private static final RunnerAndConfigurationSettings getUnityEditorRunConfiguration(Project project) {
        RunManager runManager = RunManager.Companion.getInstance(project);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager.findConfigurationByTypeAndName("UNITY_DEBUG_RUN_CONFIGURATION", DefaultRunConfigurationGenerator.Companion.getATTACH_CONFIGURATION_NAME());
        if (runnerAndConfigurationSettings == null) {
            Object v2;
            block2: {
                UnityEditorDebugConfigurationType type = (UnityEditorDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityEditorDebugConfigurationType.class);
                boolean bl = false;
                Iterable $this$firstOrNull$iv = runManager.getConfigurationSettingsList((ConfigurationType)type);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                    boolean bl2 = false;
                    RunConfiguration runConfiguration = it.getConfiguration();
                    Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.unity.run.configurations.UnityAttachToEditorRunConfiguration");
                    if (!(!((UnityAttachToEditorRunConfiguration)runConfiguration).getPlay())) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            runnerAndConfigurationSettings = v2;
        }
        return runnerAndConfigurationSettings;
    }

    private static final boolean isRunning(Project project, RunnerAndConfigurationSettings configurationSettings) {
        return !((Collection)ExecutionManagerImpl.Companion.getInstance(project).getRunningDescriptors(arg_0 -> RunConfigurationUtilKt.isRunning$lambda$8(arg_0 -> RunConfigurationUtilKt.isRunning$lambda$7(configurationSettings, arg_0), arg_0))).isEmpty();
    }

    private static final void startDebugRunConfiguration(Project project, RunnerAndConfigurationSettings configurationSettings) {
        if (!RunConfigurationUtilKt.isRunning(project, configurationSettings)) {
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configurationSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
        }
        RunManager.Companion.getInstance(project).setSelectedConfiguration(configurationSettings);
        RunConfigurationStartHistory.Companion.getInstance(project).register(configurationSettings);
    }

    @NotNull
    public static final List<UnityBundleInfo> getUnityBundlesList() {
        String pausePointAssemblyName = "JetBrains.ReSharper.Plugins.Unity.Rider.Debugger.PausePoint.Helper";
        String[] stringArray = new String[]{"DotFiles"};
        File pauseBreakpointBundle = UnityPluginEnvironment.INSTANCE.getBundledFile(pausePointAssemblyName + ".dll", stringArray);
        String textureHelperAssemblyName = "JetBrains.ReSharper.Plugins.Unity.Rider.Debugger.Presentation.Texture";
        Object[] objectArray = new String[]{"DotFiles"};
        File textureHelperBundle = UnityPluginEnvironment.INSTANCE.getBundledFile(textureHelperAssemblyName + ".dll", (String[])objectArray);
        objectArray = new UnityBundleInfo[2];
        String string = pauseBreakpointBundle.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        objectArray[0] = new UnityBundleInfo(pausePointAssemblyName, string);
        String string2 = textureHelperBundle.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        objectArray[1] = new UnityBundleInfo(textureHelperAssemblyName, string2);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getUnityPackagesList(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<UnityPackageEntity> allPackages = UnityWorkspaceExtensionsKt.getPackages(WorkspaceModel.Companion.getInstance(project));
        Iterable $this$map$iv = allPackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UnityPackageEntity unityPackageEntity = (UnityPackageEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPackageId());
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isRunning$lambda$7(RunnerAndConfigurationSettings $configurationSettings, RunnerAndConfigurationSettings it) {
        return Intrinsics.areEqual((Object)it, (Object)$configurationSettings);
    }

    private static final boolean isRunning$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

