/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.rider.plugins.unity.EngineConstants;
import com.jetbrains.rider.plugins.unity.run.UnityLocalProcessExtraDetails;
import com.jetbrains.rider.plugins.unity.util.EditorInstanceJson;
import com.jetbrains.rider.plugins.unity.util.EditorInstanceJsonStatus;
import com.jetbrains.rider.run.configurations.remote.RemoteConfiguration;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ#\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\b\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u00192\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u001e\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010\tH\u0002J*\u0010'\u001a\u00020\u001c2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150)H\u0002J\u001e\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityRunUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "engineNames", "", "", "[Ljava/lang/String;", "isUnityEditorProcess", "", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "isValidUnityEditorProcess", "pid", "", "processList", "(I[Lcom/intellij/execution/process/ProcessInfo;)Z", "getUnityProcessInfo", "Lcom/jetbrains/rider/plugins/unity/run/UnityLocalProcessExtraDetails;", "project", "Lcom/intellij/openapi/project/Project;", "getAllUnityProcessInfo", "", "", "assertNotDispatchThread", "", "getProjectNameFromEditorInstanceJson", "parseProcessInfoFromCommandLine", "canonicalProjectName", "tokenizeCommandLine", "tokenizeQuotedCommandLine", "tokenizeUnquotedCommandLine", "getQuotedCommandLine", "getMainProjectNameFromPath", "projectPath", "virtualPlayerId", "fillProjectNamesFromWorkingDirectory", "projectNames", "", "isDebuggerAttached", "host", "port", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityRunUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityRunUtil.kt\ncom/jetbrains/rider/plugins/unity/run/UnityRunUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,329:1\n12567#2,2:330\n12567#2,2:343\n1863#3:332\n1864#3:334\n1863#3,2:338\n774#3:340\n865#3,2:341\n1#4:333\n188#5,3:335\n*S KotlinDebug\n*F\n+ 1 UnityRunUtil.kt\ncom/jetbrains/rider/plugins/unity/run/UnityRunUtil\n*L\n82#1:330,2\n319#1:343,2\n104#1:332\n104#1:334\n225#1:338,2\n288#1:340\n288#1:341,2\n115#1:335,3\n*E\n"})
public final class UnityRunUtil {
    @NotNull
    public static final UnityRunUtil INSTANCE = new UnityRunUtil();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String[] engineNames;

    private UnityRunUtil() {
    }

    public final boolean isUnityEditorProcess(@NotNull ProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        String string = processInfo.getExecutableDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
        String name = string;
        String canonicalName = processInfo.getExecutableCannonicalPath().isPresent() ? ((Object)Paths.get((String)processInfo.getExecutableCannonicalPath().get(), new String[0]).getFileName()).toString() : name;
        logger.debug("isUnityEditorProcess: '" + name + "', '" + canonicalName + "'");
        for (String engineName : engineNames) {
            if (!StringsKt.equals((String)name, (String)engineName, (boolean)true) && !StringsKt.equals((String)name, (String)(engineName + " Editor"), (boolean)true) && !StringsKt.equals((String)name, (String)(engineName + "_s.debug"), (boolean)true) && !StringsKt.equals((String)canonicalName, (String)engineName, (boolean)true) && !StringsKt.equals((String)canonicalName, (String)(engineName + " Editor"), (boolean)true) && !StringsKt.equals((String)canonicalName, (String)(engineName + "_s.debug"), (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public final boolean isValidUnityEditorProcess(int pid, @NotNull ProcessInfo[] processList) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)processList, (String)"processList");
            logger.trace("Checking Unity Process, current pid: " + pid + ". Process count: " + processList.length);
            ProcessInfo[] $this$any$iv = processList;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ProcessInfo element$iv;
                ProcessInfo it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it.getPid() == pid && INSTANCE.isUnityEditorProcess(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final UnityLocalProcessExtraDetails getUnityProcessInfo(@NotNull ProcessInfo processInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getAllUnityProcessInfo(CollectionsKt.listOf((Object)processInfo), project).get(processInfo.getPid());
    }

    @NotNull
    public final Map<Integer, UnityLocalProcessExtraDetails> getAllUnityProcessInfo(@NotNull List<? extends ProcessInfo> processList, @NotNull Project project) {
        Map processInfoMap;
        block12: {
            block11: {
                boolean bl;
                block10: {
                    Object it;
                    Intrinsics.checkNotNullParameter(processList, (String)"processList");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    this.assertNotDispatchThread();
                    processInfoMap = new LinkedHashMap();
                    Iterable $this$forEach$iv = processList;
                    boolean $i$f$forEach = false;
                    for (Object t : $this$forEach$iv) {
                        it = (ProcessInfo)t;
                        boolean bl2 = false;
                        try {
                            String projectName = INSTANCE.getProjectNameFromEditorInstanceJson((ProcessInfo)it, project);
                            UnityLocalProcessExtraDetails n = INSTANCE.parseProcessInfoFromCommandLine((ProcessInfo)it, projectName);
                            boolean bl3 = false;
                            processInfoMap.put(it.getPid(), n);
                        }
                        catch (Throwable t2) {
                            logger.warn("Error fetching Unity process info: " + it.getCommandLine(), t2);
                        }
                    }
                    if (processInfoMap.size() != processList.size()) break block11;
                    Map $this$any$iv = processInfoMap;
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        for (Map.Entry entry : $this$any$iv.entrySet()) {
                            it = entry;
                            boolean bl4 = false;
                            if (!(((UnityLocalProcessExtraDetails)it.getValue()).getProjectName() == null)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block12;
            }
            this.fillProjectNamesFromWorkingDirectory(processList, processInfoMap);
        }
        return processInfoMap;
    }

    private final void assertNotDispatchThread() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isInternal() && application.isDispatchThread()) {
            throw new RuntimeException("Access not allowed on event dispatch thread");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getProjectNameFromEditorInstanceJson(ProcessInfo processInfo, Project project) {
        EditorInstanceJson editorInstanceJson = EditorInstanceJson.Companion.getInstance(project);
        if (editorInstanceJson.getStatus() != EditorInstanceJsonStatus.Valid) return null;
        EditorInstanceJson.EditorInstanceJsonContents editorInstanceJsonContents = editorInstanceJson.getContents();
        if (editorInstanceJsonContents == null) return null;
        if (editorInstanceJsonContents.getProcess_id() != processInfo.getPid()) return null;
        boolean bl = true;
        if (!bl) return null;
        String string = project.getName();
        return string;
    }

    private final UnityLocalProcessExtraDetails parseProcessInfoFromCommandLine(ProcessInfo processInfo, String canonicalProjectName) {
        String string;
        String projectPath = null;
        String projectName = canonicalProjectName;
        String name = null;
        String umpProcessRole = null;
        String umpWindowTitle = null;
        String vpId = null;
        List<String> tokens = this.tokenizeCommandLine(processInfo);
        int i = 0;
        while (i < tokens.size()) {
            String token = tokens.get(i++);
            if (i < tokens.size() - 1) {
                if (projectPath == null && (StringsKt.equals((String)token, (String)"-projectPath", (boolean)true) || StringsKt.equals((String)token, (String)"-createProject", (boolean)true))) {
                    Object path;
                    Object lastValid = new File((String)(path = tokens.get(i++))).isDirectory() ? path : "";
                    int j = i;
                    while (j < tokens.size()) {
                        if (!new File((String)(path = (String)path + " " + tokens.get(j++))).isDirectory()) continue;
                        lastValid = path;
                        i = j;
                    }
                    projectPath = lastValid;
                    continue;
                }
                if (StringsKt.equals((String)token, (String)"-name", (boolean)true) && i < tokens.size() - 1) {
                    name = StringUtil.unquoteString((String)tokens.get(i++));
                    continue;
                }
                if (StringsKt.equals((String)token, (String)"-ump-process-role", (boolean)true) && i < tokens.size() - 1) {
                    umpProcessRole = StringUtil.unquoteString((String)tokens.get(i++));
                    continue;
                }
                if (!StringsKt.equals((String)token, (String)"-ump-window-title", (boolean)true) || i >= tokens.size() - 1) continue;
                umpWindowTitle = StringUtil.unquoteString((String)tokens.get(i++));
                continue;
            }
            if (!StringsKt.startsWith((String)token, (String)"-vpId=", (boolean)true)) continue;
            vpId = StringsKt.substringAfter$default((String)token, (String)"=", null, (int)2, null);
        }
        if (projectPath != null) {
            String string2 = StringUtil.unquoteString(projectPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteString(...)");
            projectName = this.getMainProjectNameFromPath(string2, vpId);
        }
        if ((string = name) == null && (string = umpWindowTitle) == null) {
            string = umpProcessRole;
        }
        return new UnityLocalProcessExtraDetails(projectName, string, vpId);
    }

    private final List<String> tokenizeCommandLine(ProcessInfo processInfo) {
        List<String> list = this.tokenizeQuotedCommandLine(processInfo);
        if (list == null) {
            list = this.tokenizeUnquotedCommandLine(processInfo);
        }
        return list;
    }

    private final List<String> tokenizeQuotedCommandLine(ProcessInfo processInfo) {
        List list;
        String string = this.getQuotedCommandLine(processInfo);
        if (string != null) {
            String it = string;
            boolean bl = false;
            List tokens = new ArrayList();
            CommandLineTokenizer tokenizer = new CommandLineTokenizer(it);
            while (tokenizer.hasMoreTokens()) {
                String string2 = tokenizer.nextToken();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextToken(...)");
                tokens.add(string2);
            }
            list = tokens;
        } else {
            list = null;
        }
        return list;
    }

    private final List<String> tokenizeUnquotedCommandLine(ProcessInfo processInfo) {
        List tokens = new ArrayList();
        String string = processInfo.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLine(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("(^|\\s)(?=-[^\\s])");
        int n = 0;
        Iterable $this$forEach$iv = regex.split(charSequence, n);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String it = (String)element$iv;
            boolean bl2 = false;
            int whitespace = StringsKt.indexOf$default((CharSequence)it, (char)' ', (int)0, (boolean)false, (int)6, null);
            if (whitespace == -1) {
                bl = tokens.add(it);
                continue;
            }
            String string2 = it.substring(0, whitespace);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            tokens.add(string2);
            String string3 = it.substring(whitespace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            bl = tokens.add(string3);
        }
        return tokens;
    }

    private final String getQuotedCommandLine(ProcessInfo processInfo) {
        String string;
        if (SystemInfo.isWindows) {
            string = processInfo.getCommandLine();
        } else if (SystemInfo.isMac) {
            string = null;
        } else {
            if (SystemInfo.isUnix) {
                try {
                    File procfsCmdline = new File("/proc/" + processInfo.getPid() + "/cmdline");
                    byte[] byArray = FileUtil.loadFileBytes((File)procfsCmdline);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadFileBytes(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    String cmdlineString = new String(byArray2, charset2);
                    List list = StringUtil.split((String)cmdlineString, (String)"\u0000");
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
                    List cmdlineParts = list;
                    return CollectionsKt.joinToString$default((Iterable)cmdlineParts, (CharSequence)" ", null, null, (int)0, null, UnityRunUtil::getQuotedCommandLine$lambda$6, (int)30, null);
                }
                catch (Throwable t) {
                    logger.warn("Error while quoting command line: " + processInfo.getCommandLine(), t);
                    return null;
                }
            }
            string = null;
        }
        return string;
    }

    private final String getMainProjectNameFromPath(String projectPath, String virtualPlayerId) {
        String path = virtualPlayerId != null ? StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)projectPath, (CharSequence)"/"), (CharSequence)("Library/VP/" + virtualPlayerId)) : projectPath;
        return ((Object)Paths.get(path, new String[0]).getFileName()).toString();
    }

    private final void fillProjectNamesFromWorkingDirectory(List<? extends ProcessInfo> processList, Map<Integer, UnityLocalProcessExtraDetails> projectNames) {
        if (SystemInfo.isWindows) {
            return;
        }
        try {
            String[] $this$filterTo$iv$iv;
            Iterable $this$filter$iv = processList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                ProcessInfo it = (ProcessInfo)t;
                boolean bl = false;
                if (!(!projectNames.containsKey(it.getPid()))) continue;
                destination$iv$iv.add(t);
            }
            String processIds = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, UnityRunUtil::fillProjectNamesFromWorkingDirectory$lambda$8, (int)30, null);
            String command = SystemInfo.isMac ? "/usr/sbin/lsof" : "/usr/bin/lsof";
            $this$filterTo$iv$iv = new String[]{command, "-a", "-p", processIds, "-d", "cwd", "-Fn"};
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine($this$filterTo$iv$iv));
            if (output.getExitCode() == 0) {
                List list = output.getStdoutLines();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
                List stdout = list;
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)stdout.size())), (int)3);
                int i = intProgression.getFirst();
                int n = intProgression.getLast();
                int n2 = intProgression.getStep();
                if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                    while (true) {
                        String cwd;
                        Object e = stdout.get(i);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                        String bl = (String)e;
                        int n3 = 1;
                        String string = bl.substring(n3);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        int pid = Integer.parseInt(string);
                        Object e2 = stdout.get(i + 2);
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                        String string2 = (String)e2;
                        int n4 = 1;
                        Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n4), (String)"substring(...)");
                        String projectName = this.getMainProjectNameFromPath(cwd, null);
                        UnityLocalProcessExtraDetails process = projectNames.get(pid);
                        Map<Integer, UnityLocalProcessExtraDetails> map = projectNames;
                        Integer n5 = pid;
                        UnityLocalProcessExtraDetails unityLocalProcessExtraDetails = process;
                        if (unityLocalProcessExtraDetails == null || (unityLocalProcessExtraDetails = UnityLocalProcessExtraDetails.copy$default(unityLocalProcessExtraDetails, projectName, null, null, 6, null)) == null) {
                            unityLocalProcessExtraDetails = new UnityLocalProcessExtraDetails(projectName, null, null);
                        }
                        UnityLocalProcessExtraDetails unityLocalProcessExtraDetails2 = unityLocalProcessExtraDetails;
                        map.put(n5, unityLocalProcessExtraDetails2);
                        if (i != n) {
                            i += n2;
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Error fetching current directory", t);
        }
    }

    public final boolean isDebuggerAttached(@NotNull String host, int port, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)project);
        XDebugSession[] xDebugSessionArray = debuggerManager.getDebugSessions();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
        Object[] $this$any$iv = xDebugSessionArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        if (n < n2) {
            Object element$iv = $this$any$iv[n];
            XDebugSession it = (XDebugSession)element$iv;
            boolean bl = false;
            RunProfile profile = it.getRunProfile();
            return profile instanceof RemoteConfiguration ? Intrinsics.areEqual((Object)((RemoteConfiguration)profile).getAddress(), (Object)host) && ((RemoteConfiguration)profile).getPort() == port : false;
        }
        return false;
    }

    private static final CharSequence getQuotedCommandLine$lambda$6(String it) {
        String string;
        String s = it;
        if (!StringUtil.isQuotedString((String)s)) {
            string = s;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (char)'\\', (boolean)false, (int)2, null)) {
                s = StringUtil.escapeBackSlashes((String)s);
            }
            string = s;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (char)'\"', (boolean)false, (int)2, null)) {
                s = StringUtil.escapeQuotes((String)s);
            }
            string = s;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.contains$default((CharSequence)string, (char)' ', (boolean)false, (int)2, null)) {
                s = StringUtil.wrapWithDoubleQuote((String)s);
            }
        }
        string = s;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final CharSequence fillProjectNamesFromWorkingDirectory$lambda$8(ProcessInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getPid());
    }

    static {
        Logger logger = Logger.getInstance(UnityRunUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityRunUtil.logger = logger;
        String[] stringArray = new String[]{EngineConstants.INSTANCE.getUnityEngineName(), EngineConstants.INSTANCE.getTuanjieEngineName()};
        engineNames = stringArray;
    }
}

