/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unity.run.UnityLocalPlayer;
import com.jetbrains.rider.plugins.unity.run.UnityLocalUwpPlayer;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.run.UnityRemotePlayer;
import com.jetbrains.rider.plugins.unity.util.UnityUtilsKt;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u001dJ,\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#0\u001dH\u0086@\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020\u000bH\u0002J0\u0010+\u001a\u00020\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityPlayerListener;", "", "<init>", "()V", "refreshPeriod", "", "defaultHeartbeat", "", "multicastPorts", "", "playerMulticastGroup", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "Ljava/net/InetAddress;", "selector", "Ljava/nio/channels/Selector;", "Ljava/nio/channels/Selector;", "unityPlayerDescriptorsHeartbeats", "", "", "unityProcesses", "Lcom/jetbrains/rider/plugins/unity/run/UnityProcess;", "syncLock", "Ljava/lang/Object;", "startListening", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onPlayerAdded", "Lkotlin/Function1;", "onPlayerRemoved", "getPlayer", "project", "Lcom/intellij/openapi/project/Project;", "predicate", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startListeningUdp", "parseUnityPlayer", "unityPlayerDescriptor", "packetSourceAddress", "isLocalAddress", "addr", "refreshUnityPlayersList", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityPlayerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityPlayerListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityPlayerListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n295#2,2:285\n1863#2,2:289\n1863#2:298\n1864#2:300\n1863#2,2:301\n1251#3,2:287\n503#4,7:291\n1#5:299\n*S KotlinDebug\n*F\n+ 1 UnityPlayerListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityPlayerListener\n*L\n106#1:285,2\n130#1:289,2\n233#1:298\n233#1:300\n149#1:301,2\n125#1:287,2\n233#1:291,7\n*E\n"})
public final class UnityPlayerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long refreshPeriod;
    private final int defaultHeartbeat;
    @NotNull
    private final List<Integer> multicastPorts;
    private final InetAddress playerMulticastGroup;
    private final Selector selector;
    @NotNull
    private final Map<String, Integer> unityPlayerDescriptorsHeartbeats;
    @NotNull
    private final Map<String, UnityProcess> unityProcesses;
    @NotNull
    private final Object syncLock;
    @NotNull
    private static final Logger logger;
    private static final Pattern unityPlayerDescriptorRegex;

    public UnityPlayerListener() {
        this.refreshPeriod = 1000L;
        this.defaultHeartbeat = 3;
        Object[] objectArray = new Integer[]{54997, 34997, 57997, 58997};
        this.multicastPorts = CollectionsKt.listOf((Object[])objectArray);
        this.playerMulticastGroup = InetAddress.getByName("225.0.0.222");
        this.selector = Selector.open();
        this.unityPlayerDescriptorsHeartbeats = new LinkedHashMap();
        this.unityProcesses = new LinkedHashMap();
        this.syncLock = new Object();
    }

    public final void startListening(@NotNull Lifetime lifetime, @NotNull Function1<? super UnityProcess, Unit> onPlayerAdded, @NotNull Function1<? super UnityProcess, Unit> onPlayerRemoved) {
        Timer timer2;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onPlayerAdded, (String)"onPlayerAdded");
        Intrinsics.checkNotNullParameter(onPlayerRemoved, (String)"onPlayerRemoved");
        this.startListeningUdp(lifetime);
        String string = "Listen for Unity Players";
        boolean bl = true;
        long l = 0L;
        long l2 = this.refreshPeriod;
        Timer timer3 = timer2 = TimersKt.timer((String)string, (boolean)bl);
        timer3.schedule(new TimerTask(this, onPlayerAdded, onPlayerRemoved){
            final /* synthetic */ UnityPlayerListener this$0;
            final /* synthetic */ Function1 $onPlayerAdded$inlined;
            final /* synthetic */ Function1 $onPlayerRemoved$inlined;
            {
                this.this$0 = unityPlayerListener;
                this.$onPlayerAdded$inlined = function1;
                this.$onPlayerRemoved$inlined = function12;
            }

            public void run() {
                TimerTask $this$startListening_u24lambda_u240 = this;
                boolean bl = false;
                UnityPlayerListener.access$refreshUnityPlayersList(this.this$0, this.$onPlayerAdded$inlined, this.$onPlayerRemoved$inlined);
            }
        }, l, l2);
        Timer refreshTimer = timer2;
        lifetime.onTermination(() -> UnityPlayerListener.startListening$lambda$1(refreshTimer));
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object getPlayer(@NotNull Project var1_1, @NotNull Function1<? super UnityProcess, Boolean> var2_2, @NotNull Continuation<? super UnityProcess> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void startListeningUdp(Lifetime lifetime) {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            boolean bl;
            NetworkInterface networkInterface;
            block5: {
                networkInterface = (NetworkInterface)iterator.next();
                logger.trace("Examine network interface " + networkInterface);
                if (!networkInterface.isUp() || !networkInterface.supportsMulticast()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"getInetAddresses(...)");
                Sequence $this$any$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    InetAddress it = (InetAddress)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof Inet4Address)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (!bl) continue;
            logger.trace("Attempt to open DatagramChannel with " + networkInterface);
            Iterable $this$forEach$iv = this.multicastPorts;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int port = ((Number)element$iv).intValue();
                boolean bl3 = false;
                try {
                    DatagramChannel channel = ((DatagramChannel)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, networkInterface)).bind(new InetSocketAddress(port));
                    channel.configureBlocking(false);
                    channel.join(this.playerMulticastGroup, networkInterface);
                    channel.register(this.selector, 1);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                }
            }
        }
        lifetime.onTermination(() -> UnityPlayerListener.startListeningUdp$lambda$8(this));
    }

    private final UnityProcess parseUnityPlayer(String unityPlayerDescriptor, InetAddress packetSourceAddress) {
        try {
            Matcher matcher = unityPlayerDescriptorRegex.matcher(unityPlayerDescriptor);
            if (matcher.find()) {
                UnityProcess unityProcess;
                String ipInMessage = matcher.group("ip");
                String id = matcher.group("id");
                String string = matcher.group("flags");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                int flags = Integer.parseInt(string);
                String string2 = matcher.group("debug");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                boolean allowDebugging = StringsKt.startsWith$default((String)string2, (String)"1", (boolean)false, (int)2, null);
                String string3 = matcher.group("guid");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                long guid = Long.parseLong(string3);
                Object object = matcher.group("debuggerPort");
                int debuggerPort = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : UnityUtilsKt.convertPidToDebuggerPort(guid);
                String packageName = matcher.group("packageName");
                String projectName = matcher.group("projectName");
                InetAddress hostAddress = Companion.UnityPlayerConnectionFlags.UseAlternateIP.isSet(flags) ? InetAddress.getByName(ipInMessage) : packetSourceAddress;
                Intrinsics.checkNotNull((Object)hostAddress);
                if (this.isLocalAddress(hostAddress)) {
                    UnityLocalPlayer unityLocalPlayer;
                    Intrinsics.checkNotNull((Object)id);
                    if (StringsKt.startsWith$default((String)id, (String)"UWPPlayer", (boolean)false, (int)2, null) && packageName != null) {
                        String string4 = hostAddress.getHostAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getHostAddress(...)");
                        unityLocalPlayer = new UnityLocalUwpPlayer(id, string4, debuggerPort, allowDebugging, projectName, packageName);
                    } else {
                        String string5 = hostAddress.getHostAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getHostAddress(...)");
                        unityLocalPlayer = new UnityLocalPlayer(id, string5, debuggerPort, allowDebugging, projectName);
                    }
                    unityProcess = unityLocalPlayer;
                } else {
                    Intrinsics.checkNotNull((Object)id);
                    String string6 = hostAddress.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getHostAddress(...)");
                    unityProcess = new UnityRemotePlayer(id, string6, debuggerPort, allowDebugging, projectName);
                }
                return unityProcess;
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return null;
    }

    private final boolean isLocalAddress(InetAddress addr) {
        boolean bl;
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            bl = true;
        } else {
            boolean bl2;
            try {
                bl2 = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshUnityPlayersList(Function1<? super UnityProcess, Unit> onPlayerAdded, Function1<? super UnityProcess, Unit> onPlayerRemoved) {
        Object object = this.syncLock;
        synchronized (object) {
            int readyChannels;
            boolean bl = false;
            long start = System.currentTimeMillis();
            logger.trace("Refreshing Unity players list...");
            Iterator<String> iterator = this.unityPlayerDescriptorsHeartbeats.keySet().iterator();
            while (iterator.hasNext()) {
                String playerDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                Integer n = this.unityPlayerDescriptorsHeartbeats.get(playerDescriptor);
                if (n == null) {
                    continue;
                }
                int currentPlayerTimeout = n;
                this.unityPlayerDescriptorsHeartbeats.put(playerDescriptor, currentPlayerTimeout - 1);
            }
            Map<String, Integer> $this$filterValues$iv = this.unityPlayerDescriptorsHeartbeats;
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, Integer> result$iv = new LinkedHashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry$iv : $this$filterValues$iv.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl2 = false;
                if (!(it <= 0)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$forEach$iv = ((Map)result$iv).keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UnityProcess it;
                String playerDescription = (String)element$iv;
                boolean bl3 = false;
                this.unityPlayerDescriptorsHeartbeats.remove(playerDescription);
                logger.trace("Removing old Unity player " + playerDescription);
                if (this.unityProcesses.remove(playerDescription) == null) continue;
                boolean bl4 = false;
                onPlayerRemoved.invoke((Object)it);
            }
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while ((readyChannels = this.selector.selectNow(arg_0 -> UnityPlayerListener.refreshUnityPlayersList$lambda$14$lambda$13(buffer, this, onPlayerAdded, arg_0))) != 0) {
            }
            if (logger.isTraceEnabled()) {
                long duration = System.currentTimeMillis() - start;
                logger.trace("Finished refreshing Unity players list. Took " + duration + "ms");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit startListening$lambda$1(Timer $refreshTimer) {
        $refreshTimer.cancel();
        return Unit.INSTANCE;
    }

    private static final Unit getPlayer$lambda$2(List $players, UnityProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $players.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit getPlayer$lambda$3(List $players, UnityProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $players.remove(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startListeningUdp$lambda$8(UnityPlayerListener this$0) {
        Object object = this$0.syncLock;
        synchronized (object) {
            boolean bl = false;
            Set<SelectionKey> set = this$0.selector.keys();
            Intrinsics.checkNotNullExpressionValue(set, (String)"keys(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SelectionKey it = (SelectionKey)element$iv;
                boolean bl2 = false;
                try {
                    it.channel().close();
                }
                catch (Throwable e) {
                    logger.warn(e);
                }
            }
            this$0.selector.close();
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final void refreshUnityPlayersList$lambda$14$lambda$13(ByteBuffer $buffer, UnityPlayerListener this$0, Function1 $onPlayerAdded, SelectionKey key) {
        try {
            $buffer.clear();
            SelectableChannel selectableChannel = key.channel();
            Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.DatagramChannel");
            DatagramChannel channel = (DatagramChannel)selectableChannel;
            SocketAddress socketAddress = channel.receive($buffer);
            Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            InetSocketAddress hostAddress = (InetSocketAddress)socketAddress;
            byte[] byArray = $buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            Object[] objectArray = byArray;
            int n = 0;
            int n2 = $buffer.position();
            String string = new String((byte[])objectArray, n, n2, Charsets.UTF_8);
            objectArray = new char[1];
            objectArray[0] = 0;
            String descriptor = StringsKt.trimEnd((String)string, (char[])objectArray);
            if (logger.isTraceEnabled()) {
                logger.trace("Got heartbeat on " + channel.getRemoteAddress() + " from " + hostAddress + ": " + descriptor);
            }
            if (!this$0.unityPlayerDescriptorsHeartbeats.containsKey(descriptor)) {
                InetAddress inetAddress = hostAddress.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
                UnityProcess unityProcess = this$0.parseUnityPlayer(descriptor, inetAddress);
                if (unityProcess != null) {
                    UnityProcess player = unityProcess;
                    boolean bl = false;
                    this$0.unityProcesses.put(descriptor, player);
                    $onPlayerAdded.invoke((Object)player);
                }
            }
            this$0.unityPlayerDescriptorsHeartbeats.put(descriptor, this$0.defaultHeartbeat);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static final /* synthetic */ void access$refreshUnityPlayersList(UnityPlayerListener $this, Function1 onPlayerAdded, Function1 onPlayerRemoved) {
        $this.refreshUnityPlayersList((Function1<? super UnityProcess, Unit>)onPlayerAdded, (Function1<? super UnityProcess, Unit>)onPlayerRemoved);
    }

    static {
        Logger logger = Logger.getInstance(UnityPlayerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityPlayerListener.logger = logger;
        unityPlayerDescriptorRegex = Pattern.compile("\\[IP]\\s(?<ip>.*)\n\\s\\[Port]\\s(?<port>\\d+)\n\\s\\[Flags]\\s(?<flags>\\d+)\n\\s\\[Guid]\\s(?<guid>\\d+)\n\\s\\[EditorId]\\s(?<editorId>\\d+)\n\\s\\[Version]\\s(?<version>\\d+)\n\\s\\[Id]\\s(?<id>[^:]+)(:(?<debuggerPort>\\d+))?\n\\s\\[Debug]\\s(?<debug>\\d+)\n(\\s\\[PackageName]\\s(?<packageName>.*?)\n  (\\s\\[ProjectName]\\s(?<projectName>.*))\n)?\n", 4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u0012\u0004\b\n\u0010\u0003\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityPlayerListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "unityPlayerDescriptorRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getUnityPlayerDescriptorRegex$annotations", "Ljava/util/regex/Pattern;", "UnityPlayerConnectionFlags", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getUnityPlayerDescriptorRegex$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityPlayerListener$Companion$UnityPlayerConnectionFlags;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "getValue", "()I", "RequestImmediateConnect", "SupportsProfile", "CustomMessage", "UseAlternateIP", "isSet", "", "intellij.rider.plugins.unity"})
        public static final class UnityPlayerConnectionFlags
        extends Enum<UnityPlayerConnectionFlags> {
            private final int value;
            public static final /* enum */ UnityPlayerConnectionFlags RequestImmediateConnect = new UnityPlayerConnectionFlags(1);
            public static final /* enum */ UnityPlayerConnectionFlags SupportsProfile = new UnityPlayerConnectionFlags(2);
            public static final /* enum */ UnityPlayerConnectionFlags CustomMessage = new UnityPlayerConnectionFlags(4);
            public static final /* enum */ UnityPlayerConnectionFlags UseAlternateIP = new UnityPlayerConnectionFlags(8);
            private static final /* synthetic */ UnityPlayerConnectionFlags[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private UnityPlayerConnectionFlags(int value) {
                this.value = value;
            }

            public final int getValue() {
                return this.value;
            }

            public final boolean isSet(int value) {
                return (this.value & value) != 0;
            }

            public static UnityPlayerConnectionFlags[] values() {
                return (UnityPlayerConnectionFlags[])$VALUES.clone();
            }

            public static UnityPlayerConnectionFlags valueOf(String value) {
                return Enum.valueOf(UnityPlayerConnectionFlags.class, value);
            }

            @NotNull
            public static EnumEntries<UnityPlayerConnectionFlags> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = unityPlayerConnectionFlagsArray = new UnityPlayerConnectionFlags[]{UnityPlayerConnectionFlags.RequestImmediateConnect, UnityPlayerConnectionFlags.SupportsProfile, UnityPlayerConnectionFlags.CustomMessage, UnityPlayerConnectionFlags.UseAlternateIP};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

