/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.plugins.unity.UnityProjectLifetimeService;
import com.jetbrains.rider.plugins.unity.run.UnityLocalProcess;
import com.jetbrains.rider.plugins.unity.run.UnityLocalProcessExtraDetails;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.run.UnityRunUtil;
import com.jetbrains.rider.plugins.unity.run.UnityRunUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\f\u001a\u00020\rJ8\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityEditorListener;", "", "<init>", "()V", "refreshPeriod", "", "editorProcesses", "", "", "Lcom/jetbrains/rider/plugins/unity/run/UnityLocalProcess;", "startListening", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onEditorAdded", "Lkotlin/Function1;", "Lcom/jetbrains/rider/plugins/unity/run/UnityProcess;", "onEditorRemoved", "getEditorProcesses", "", "refreshUnityEditorProcesses", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityEditorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityEditorListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityEditorListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n3829#2:83\n4344#2,2:84\n827#3:86\n855#3:87\n1755#3,3:88\n856#3:91\n1863#3,2:92\n774#3:94\n865#3,2:95\n1863#3,2:97\n*S KotlinDebug\n*F\n+ 1 UnityEditorListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityEditorListener\n*L\n52#1:83\n52#1:84,2\n56#1:86\n56#1:87\n57#1:88,3\n56#1:91\n58#1:92,2\n65#1:94\n65#1:95,2\n67#1:97,2\n*E\n"})
public final class UnityEditorListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long refreshPeriod;
    @NotNull
    private final Map<Integer, UnityLocalProcess> editorProcesses = new LinkedHashMap();
    @NotNull
    private static final Logger logger;

    public UnityEditorListener() {
        this.refreshPeriod = 1000L;
    }

    public final void startListening(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull Function1<? super UnityProcess, Unit> onEditorAdded, @NotNull Function1<? super UnityProcess, Unit> onEditorRemoved) {
        Timer timer2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onEditorAdded, (String)"onEditorAdded");
        Intrinsics.checkNotNullParameter(onEditorRemoved, (String)"onEditorRemoved");
        String string = "Listen for Unity Editor processes";
        boolean bl = true;
        long l = 0L;
        long l2 = this.refreshPeriod;
        Timer timer3 = timer2 = TimersKt.timer((String)string, (boolean)bl);
        timer3.schedule(new TimerTask(this, project, onEditorAdded, onEditorRemoved){
            final /* synthetic */ UnityEditorListener this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Function1 $onEditorAdded$inlined;
            final /* synthetic */ Function1 $onEditorRemoved$inlined;
            {
                this.this$0 = unityEditorListener;
                this.$project$inlined = project;
                this.$onEditorAdded$inlined = function1;
                this.$onEditorRemoved$inlined = function12;
            }

            public void run() {
                TimerTask $this$startListening_u24lambda_u240 = this;
                boolean bl = false;
                UnityEditorListener.access$refreshUnityEditorProcesses(this.this$0, this.$project$inlined, this.$onEditorAdded$inlined, this.$onEditorRemoved$inlined);
            }
        }, l, l2);
        Timer refreshTimer = timer2;
        lifetime.onTermination(() -> UnityEditorListener.startListening$lambda$1(refreshTimer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<UnityProcess> getEditorProcesses(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LifetimeDefinition lifetime = UnityProjectLifetimeService.Companion.getLifetime(project).createNested();
        try {
            List editors = new ArrayList();
            this.refreshUnityEditorProcesses(project, (Function1<? super UnityProcess, Unit>)((Function1)arg_0 -> UnityEditorListener.getEditorProcesses$lambda$2(editors, arg_0)), (Function1<? super UnityProcess, Unit>)((Function1)arg_0 -> UnityEditorListener.getEditorProcesses$lambda$3(editors, arg_0)));
            List list = editors;
            return list;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetime, (boolean)false, (int)1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshUnityEditorProcesses(Project project, Function1<? super UnityProcess, Unit> onEditorAdded, Function1<? super UnityProcess, Unit> onEditorRemoved) {
        void $this$filterTo$iv$iv;
        Object element$iv3;
        void $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Iterable $this$filterTo$iv$iv2;
        long start = System.currentTimeMillis();
        logger.trace("Refreshing local editor processes...");
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Object[] $this$filter$iv = processInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv2) {
            ProcessInfo it = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!UnityRunUtil.INSTANCE.isUnityEditorProcess(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List processes2 = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = this.editorProcesses.keySet();
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv2 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block9: {
                element$iv$iv = iterator.next();
                int existingEditorPid = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                Iterable $this$any$iv = processes2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ProcessInfo p = (ProcessInfo)element$iv2;
                        boolean bl3 = false;
                        if (!(p.getPid() == existingEditorPid)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            UnityLocalProcess it;
            int p = ((Number)element$iv3).intValue();
            boolean bl = false;
            if (this.editorProcesses.remove(p) == null) continue;
            boolean bl4 = false;
            logger.trace("Removing old Unity editor " + it.getDisplayName() + ":" + it.getPid());
            onEditorRemoved.invoke((Object)it);
        }
        Iterable $this$filter$iv2 = processes2;
        boolean $i$f$filter2 = false;
        element$iv3 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProcessInfo it = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            if (!(!this.editorProcesses.containsKey(it.getPid()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newProcesses = (List)destination$iv$iv2;
        Map<Integer, UnityLocalProcessExtraDetails> unityProcessInfoMap = UnityRunUtil.INSTANCE.getAllUnityProcessInfo(newProcesses, project);
        Iterable $this$forEach$iv2 = newProcesses;
        boolean $i$f$forEach2 = false;
        for (Object element$iv4 : $this$forEach$iv2) {
            ProcessInfo processInfo = (ProcessInfo)element$iv4;
            boolean bl = false;
            UnityLocalProcessExtraDetails unityProcessInfo = unityProcessInfoMap.get(processInfo.getPid());
            Intrinsics.checkNotNull((Object)processInfo);
            UnityLocalProcess editorProcess = UnityRunUtilKt.toUnityProcess(processInfo, unityProcessInfo);
            logger.trace("Adding Unity editor process " + editorProcess.getDisplayName() + ":" + editorProcess.getPid());
            this.editorProcesses.put(processInfo.getPid(), editorProcess);
            onEditorAdded.invoke((Object)editorProcess);
        }
        if (logger.isTraceEnabled()) {
            long duration = System.currentTimeMillis() - start;
            logger.trace("Finished refreshing local editor processes. Took " + duration + "ms");
        }
    }

    private static final Unit startListening$lambda$1(Timer $refreshTimer) {
        $refreshTimer.cancel();
        return Unit.INSTANCE;
    }

    private static final Unit getEditorProcesses$lambda$2(List $editors, UnityProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editors.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit getEditorProcesses$lambda$3(List $editors, UnityProcess it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editors.remove(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$refreshUnityEditorProcesses(UnityEditorListener $this, Project project, Function1 onEditorAdded, Function1 onEditorRemoved) {
        $this.refreshUnityEditorProcesses(project, (Function1<? super UnityProcess, Unit>)onEditorAdded, (Function1<? super UnityProcess, Unit>)onEditorRemoved);
    }

    static {
        Logger logger = Logger.getInstance(UnityEditorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityEditorListener.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityEditorListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

