/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.run.AndroidDeviceListener;
import com.jetbrains.rider.plugins.unity.run.AppleDeviceListener;
import com.jetbrains.rider.plugins.unity.run.UnityCustomPlayer;
import com.jetbrains.rider.plugins.unity.run.UnityEditorListener;
import com.jetbrains.rider.plugins.unity.run.UnityPlayerListener;
import com.jetbrains.rider.plugins.unity.run.UnityProcess;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfiguration;
import com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfigurationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\r\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityDebuggableProcessListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "onProcessAdded", "Lkotlin/Function1;", "Lcom/jetbrains/rider/plugins/unity/run/UnityProcess;", "", "onProcessRemoved", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "enumerateCustomPlayers", "Companion", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityDebuggableProcessListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityDebuggableProcessListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityDebuggableProcessListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1863#2,2:54\n*S KotlinDebug\n*F\n+ 1 UnityDebuggableProcessListener.kt\ncom/jetbrains/rider/plugins/unity/run/UnityDebuggableProcessListener\n*L\n34#1:54,2\n*E\n"})
public final class UnityDebuggableProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public UnityDebuggableProcessListener(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull Function1<? super UnityProcess, Unit> onProcessAdded, @NotNull Function1<? super UnityProcess, Unit> onProcessRemoved) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onProcessAdded, (String)"onProcessAdded");
        Intrinsics.checkNotNullParameter(onProcessRemoved, (String)"onProcessRemoved");
        new UnityEditorListener().startListening(project, lifetime, onProcessAdded, onProcessRemoved);
        new UnityPlayerListener().startListening(lifetime, onProcessAdded, onProcessRemoved);
        new AppleDeviceListener(project, lifetime, onProcessAdded, onProcessRemoved);
        new AndroidDeviceListener().startListening(project, lifetime, onProcessAdded, onProcessRemoved);
        this.enumerateCustomPlayers(project, onProcessAdded);
    }

    private final void enumerateCustomPlayers(Project project, Function1<? super UnityProcess, Unit> onProcessAdded) {
        logger.trace("Looking for custom players in run configurations");
        try {
            UnityPlayerDebugConfigurationType configurationType = (UnityPlayerDebugConfigurationType)ConfigurationTypeUtil.findConfigurationType(UnityPlayerDebugConfigurationType.class);
            List customPlayers = RunManager.Companion.getInstance(project).getConfigurationSettingsList((ConfigurationType)configurationType);
            Iterable $this$forEach$iv = customPlayers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.unity.run.configurations.UnityPlayerDebugConfiguration");
                UnityPlayerDebugConfiguration configuration = (UnityPlayerDebugConfiguration)runConfiguration;
                String string = configuration.getState().getPlayerId();
                Intrinsics.checkNotNull((Object)string);
                if (!Intrinsics.areEqual((Object)UnityProcess.Companion.typeFromId(string), (Object)"CustomPlayer")) continue;
                String string2 = configuration.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String string3 = configuration.getState().getHost();
                if (string3 == null) {
                    string3 = "localhost";
                }
                int n = configuration.getState().getPort();
                String string4 = configuration.getState().getProjectName();
                if (string4 == null) {
                    string4 = UnityBundle.Companion.message("project.name.custom", new Object[0]);
                }
                UnityCustomPlayer player = new UnityCustomPlayer(string2, string3, n, string4);
                onProcessAdded.invoke((Object)player);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    static {
        Logger logger = Logger.getInstance(UnityDebuggableProcessListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnityDebuggableProcessListener.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/unity/run/UnityDebuggableProcessListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

