/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.ideaInterop.fileTypes.unityPackages.spellchecker;

import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonSpellcheckerStrategy;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unity/ideaInterop/fileTypes/unityPackages/spellchecker/UnityPackagesSpellcheckerStrategy;", "Lcom/intellij/json/JsonSpellcheckerStrategy;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "MANIFEST_DEFAULT_FILENAME", "", "PACKAGE_LOCK_DEFAULT_FILENAME", "PACKAGES_FOLDER_NAME", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lcom/intellij/psi/PsiElement;", "element", "isMyContext", "", "intellij.rider.plugins.unity"})
public final class UnityPackagesSpellcheckerStrategy
extends JsonSpellcheckerStrategy
implements DumbAware {
    @NotNull
    private final String MANIFEST_DEFAULT_FILENAME;
    @NotNull
    private final String PACKAGE_LOCK_DEFAULT_FILENAME;
    @NotNull
    private final String PACKAGES_FOLDER_NAME;

    public UnityPackagesSpellcheckerStrategy() {
        this.MANIFEST_DEFAULT_FILENAME = "manifest.json";
        this.PACKAGE_LOCK_DEFAULT_FILENAME = "packages-lock.json";
        this.PACKAGES_FOLDER_NAME = "Packages";
    }

    @NotNull
    public Tokenizer<PsiElement> getTokenizer(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Tokenizer tokenizer = JsonSpellcheckerStrategy.EMPTY_TOKENIZER;
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
        return tokenizer;
    }

    public boolean isMyContext(@NotNull PsiElement element) {
        String parentFolderName;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (!Intrinsics.areEqual((Object)this.MANIFEST_DEFAULT_FILENAME, (Object)fileName) && !Intrinsics.areEqual((Object)this.PACKAGE_LOCK_DEFAULT_FILENAME, (Object)fileName)) {
            return false;
        }
        PsiDirectory psiDirectory = file.getParent();
        String string2 = parentFolderName = psiDirectory != null ? psiDirectory.getName() : null;
        if (!Intrinsics.areEqual((Object)parentFolderName, (Object)this.PACKAGES_FOLDER_NAME)) {
            return false;
        }
        return JsonDialectUtil.isStandardJson((PsiElement)element);
    }
}

