/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.projectView.ProjectElementView;
import com.jetbrains.rider.projectView.ProjectEntityView;
import com.jetbrains.rider.projectView.ProjectModelViewExtensions;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/UnityProjectModelViewExtensions;", "Lcom/jetbrains/rider/projectView/ProjectModelViewExtensions;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getBestProjectModelElement", "Lcom/jetbrains/rider/projectView/ProjectElementView;", "targetLocation", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBestParentProjectModelNode", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "filterProjectModelNodesBeforeOperation", "", "entities", "recursiveSearch", "isHiddenFolder", "", "filterOutItemsFromNonPrimaryProjects", "items", "shouldShowSolutionConfigurationsGotIt", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nUnityProjectModelViewExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnityProjectModelViewExtensions.kt\ncom/jetbrains/rider/plugins/unity/explorer/UnityProjectModelViewExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1755#2,3:123\n774#2:126\n865#2:127\n1755#2,3:128\n866#2:131\n774#2:132\n865#2,2:133\n774#2:135\n865#2,2:136\n774#2:138\n865#2,2:139\n774#2:141\n865#2,2:142\n1863#2:144\n1755#2,3:145\n1864#2:148\n*S KotlinDebug\n*F\n+ 1 UnityProjectModelViewExtensions.kt\ncom/jetbrains/rider/plugins/unity/explorer/UnityProjectModelViewExtensions\n*L\n54#1:123,3\n79#1:126\n79#1:127\n79#1:128,3\n79#1:131\n97#1:132\n97#1:133,2\n98#1:135\n98#1:136,2\n99#1:138\n99#1:139,2\n100#1:141\n100#1:142,2\n107#1:144\n108#1:145,3\n107#1:148\n*E\n"})
public final class UnityProjectModelViewExtensions
extends ProjectModelViewExtensions {
    public UnityProjectModelViewExtensions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Nullable
    public ProjectElementView getBestProjectModelElement(@NotNull VirtualFile targetLocation) {
        Intrinsics.checkNotNullParameter((Object)targetLocation, (String)"targetLocation");
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.getProject()).getValue()).booleanValue()) {
            return null;
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.getProject());
        List<ProjectModelEntity> items = this.filterOutItemsFromNonPrimaryProjects(CollectionsKt.toList((Iterable)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)targetLocation, (Project)this.getProject())));
        if (((Collection)items).size() == 1) {
            return (ProjectElementView)new ProjectEntityView(this.getProject(), (ProjectModelEntity)CollectionsKt.single(items));
        }
        return null;
    }

    @Nullable
    public ProjectModelEntity getBestParentProjectModelNode(@NotNull VirtualFile targetLocation) {
        Intrinsics.checkNotNullParameter((Object)targetLocation, (String)"targetLocation");
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.getProject()).getValue()).booleanValue()) {
            return null;
        }
        if (targetLocation.isDirectory()) {
            ProjectModelEntity projectModelEntity = this.recursiveSearch(targetLocation);
            if (projectModelEntity == null) {
                projectModelEntity = super.getBestParentProjectModelNode(targetLocation);
            }
            return projectModelEntity;
        }
        ProjectModelEntity projectModelEntity = this.recursiveSearch(targetLocation.getParent());
        if (projectModelEntity == null) {
            projectModelEntity = super.getBestParentProjectModelNode(targetLocation);
        }
        return projectModelEntity;
    }

    @NotNull
    public List<ProjectModelEntity> filterProjectModelNodesBeforeOperation(@NotNull List<? extends ProjectModelEntity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(this.getProject()).getValue()).booleanValue()) {
            return entities;
        }
        return this.filterOutItemsFromNonPrimaryProjects(entities);
    }

    private final ProjectModelEntity recursiveSearch(VirtualFile targetLocation) {
        boolean bl;
        List<ProjectModelEntity> items;
        block14: {
            if (targetLocation == null) {
                return null;
            }
            items = this.filterOutItemsFromNonPrimaryProjects(WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.getProject()), (VirtualFile)targetLocation, (Project)this.getProject()));
            Iterable $this$any$iv = items;
            int $i$f$any = 0;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t : $this$any$iv) {
                    ProjectModelEntity it = (ProjectModelEntity)t;
                    boolean bl2 = false;
                    if (!(ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)it) || ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)it) || !ProjectModelEntityExtensionsKt.isProjectFolder((ProjectModelEntity)it))) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        if (this.isHiddenFolder(targetLocation)) {
            return null;
        }
        if (((Collection)items).size() > 1) {
            String[] $i$f$any = new String[]{"Assembly-CSharp", "Assembly-CSharp-firstpass", "Assembly-CSharp-Editor", "Assembly-CSharp-Editor-firstpass"};
            for (String string : $i$f$any) {
                for (ProjectModelEntity node : items) {
                    ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)node);
                    if (!StringsKt.equals$default((String)(projectModelEntity != null ? projectModelEntity.getName() : null), (String)string, (boolean)false, (int)2, null)) continue;
                    return node;
                }
            }
        }
        Iterable $this$filter$iv = items;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : iterable) {
            boolean bl2;
            block15: {
                ProjectModelEntity node = (ProjectModelEntity)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$any$iv = node.getChildrenEntities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ProjectModelEntity it = (ProjectModelEntity)element$iv;
                        boolean bl5 = false;
                        if (!ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)it)) continue;
                        bl2 = true;
                        break block15;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List candidates = (List)destination$iv$iv;
        if (((Collection)candidates).size() == 1) {
            return (ProjectModelEntity)CollectionsKt.single((List)candidates);
        }
        return this.recursiveSearch(targetLocation.getParent());
    }

    private final boolean isHiddenFolder(VirtualFile targetLocation) {
        String string = targetLocation.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        return StringsKt.endsWith$default((String)name, (String)"~", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)".", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final List<ProjectModelEntity> filterOutItemsFromNonPrimaryProjects(List<? extends ProjectModelEntity> items) {
        $this$filter$iv = items;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectModelEntity)element$iv$iv;
            $i$a$-filter-UnityProjectModelViewExtensions$filterOutItemsFromNonPrimaryProjects$elementsWithoutProject$1 = false;
            if (!(ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        elementsWithoutProject = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        $this$filter$iv = items;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectModelEntity)element$iv$iv;
            $i$a$-filter-UnityProjectModelViewExtensions$filterOutItemsFromNonPrimaryProjects$elementsWithProject$1 = false;
            if (!(ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        elementsWithProject = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        $this$filter$iv = elementsWithProject;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectModelEntity)element$iv$iv;
            $i$a$-filter-UnityProjectModelViewExtensions$filterOutItemsFromNonPrimaryProjects$elementsWithNonPlayerProject$1 = false;
            v0 = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)it);
            Intrinsics.checkNotNull((Object)v0);
            if (!(StringsKt.endsWith$default((String)v0.getName(), (String)".Player", (boolean)false, (int)2, null) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        elementsWithNonPlayerProject = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        $this$filter$iv = elementsWithProject;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectModelEntity)element$iv$iv;
            $i$a$-filter-UnityProjectModelViewExtensions$filterOutItemsFromNonPrimaryProjects$elementsWithPlayerProject$1 = false;
            v1 = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)it);
            Intrinsics.checkNotNull((Object)v1);
            if (!StringsKt.endsWith$default((String)v1.getName(), (String)".Player", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        elementsWithPlayerProject = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        res = new ArrayList<E>();
        res.addAll(elementsWithoutProject);
        res.addAll(elementsWithNonPlayerProject);
        $this$forEach$iv = elementsWithPlayerProject;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block8: {
                block9: {
                    player = (ProjectModelEntity)element$iv;
                    $i$a$-forEach-UnityProjectModelViewExtensions$filterOutItemsFromNonPrimaryProjects$1 = false;
                    $this$any$iv = elementsWithNonPlayerProject;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block9;
                    v2 = false;
                    break block8;
                }
                for (T element$iv : $this$any$iv) {
                    el = (ProjectModelEntity)element$iv;
                    $i$a$-any-UnityProjectModelViewExtensions$filterOutItemsFromNonPrimaryProjects$1$1 = false;
                    if (!Intrinsics.areEqual((Object)el.getUrl(), (Object)player.getUrl())) ** GOTO lbl-1000
                    v3 = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)el);
                    Intrinsics.checkNotNull((Object)v3);
                    v4 = v3.getName() + ".Player";
                    v5 = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)player);
                    Intrinsics.checkNotNull((Object)v5);
                    if (Intrinsics.areEqual((Object)v4, (Object)v5.getName())) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    v2 = true;
                    break block8;
                }
                v2 = false;
            }
            if (v2) continue;
            res.add(player);
        }
        return res;
    }

    public boolean shouldShowSolutionConfigurationsGotIt() {
        return (Boolean)UnityProjectDiscovererKt.isUnityProject(this.getProject()).getValue() == false;
    }
}

