/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ExperimentalUI;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.actions.UnityPluginActionsBundle;
import com.jetbrains.rider.plugins.unity.explorer.PackagesRootNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerRootNode;
import com.jetbrains.rider.projectView.views.SolutionViewPaneBase;
import com.jetbrains.rider.projectView.views.SolutionViewRootNodeBase;
import com.jetbrains.rider.projectView.views.actions.SolutionViewToggleAction;
import com.jetbrains.rider.projectView.views.impl.SolutionViewSelectInTargetBase;
import icons.UnityIcons;
import java.util.HashSet;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorer;", "Lcom/jetbrains/rider/projectView/views/SolutionViewPaneBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "showTildeFolders", "", "getShowTildeFolders", "()Z", "setShowTildeFolders", "(Z)V", "value", "showProjectNames", "getShowProjectNames", "hasPackagesRoot", "isInitiallyVisible", "writeExternal", "", "element", "Lorg/jdom/Element;", "readExternal", "getTitle", "", "getIcon", "Ljavax/swing/Icon;", "getId", "getWeight", "", "createSelectInTarget", "Lcom/jetbrains/rider/projectView/views/impl/SolutionViewSelectInTargetBase;", "addToolbarActions", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "addPrimaryToolbarActions", "Companion", "intellij.rider.plugins.unity"})
public final class UnityExplorer
extends SolutionViewPaneBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean showTildeFolders;
    private boolean showProjectNames;
    @NotNull
    public static final String ID = "UnityExplorer";
    @NlsSafe
    @NotNull
    public static final String Title = "Unity";
    public static final int Weight = 1;
    @NotNull
    public static final String ShowProjectNamesOption = "show-project-names";
    @NotNull
    public static final String ShowTildeFoldersOption = "show-tilde-folders";
    @NotNull
    public static final String DefaultProjectPrefix = "Assembly-CSharp";
    @NotNull
    private static final Regex DefaultProjectPrefixRegex = new Regex("Assembly-CSharp[.-]?");
    @NotNull
    private static final Icon Icon = UnityIcons.ToolWindows.Companion.getUnityExplorer();
    @NotNull
    private static final HashSet<String> IgnoredExtensions;

    public UnityExplorer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, (SolutionViewRootNodeBase)new UnityExplorerRootNode(project));
        this.showTildeFolders = true;
        this.showProjectNames = true;
    }

    public final boolean getShowTildeFolders() {
        return this.showTildeFolders;
    }

    public final void setShowTildeFolders(boolean bl) {
        this.showTildeFolders = bl;
    }

    public final boolean getShowProjectNames() {
        return this.showProjectNames;
    }

    public final boolean hasPackagesRoot() {
        if (this.getTree() == null) {
            return false;
        }
        Object root = this.getTree().getModel().getRoot();
        int i = 0;
        int count = this.getTree().getModel().getChildCount(root);
        if (i <= count) {
            while (true) {
                if (this.getTree().getModel().getChild(root, i) instanceof PackagesRootNode) {
                    return true;
                }
                if (i == count) break;
                ++i;
            }
        }
        return false;
    }

    public boolean isInitiallyVisible() {
        return (Boolean)UnityProjectDiscovererKt.isUnityProject(this.getProject()).getValue();
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)ShowProjectNamesOption, (String)String.valueOf(this.showProjectNames));
        JDOMExternalizerUtil.writeField((Element)element, (String)ShowTildeFoldersOption, (String)String.valueOf(this.showTildeFolders));
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        String option = JDOMExternalizerUtil.readField((Element)element, (String)ShowProjectNamesOption);
        this.showProjectNames = option == null || Boolean.parseBoolean(option);
        option = JDOMExternalizerUtil.readField((Element)element, (String)ShowTildeFoldersOption);
        this.showTildeFolders = option == null || Boolean.parseBoolean(option);
    }

    @NotNull
    public String getTitle() {
        return Title;
    }

    @NotNull
    public Icon getIcon() {
        return Icon;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 1;
    }

    @NotNull
    public SolutionViewSelectInTargetBase createSelectInTarget() {
        Project project = this.getProject();
        return new SolutionViewSelectInTargetBase(project){

            public boolean canSelect(SelectInContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return true;
            }

            public void selectIn(SelectInContext context, boolean requestFocus) {
                block0: {
                    SelectInContext selectInContext = context;
                    if (selectInContext == null) break block0;
                    SelectInContext it = selectInContext;
                    boolean bl = false;
                    this.select(it, null, requestFocus);
                }
            }

            public String toString() {
                return "Unity";
            }

            public String getMinorViewId() {
                return "UnityExplorer";
            }

            public float getWeight() {
                return 1.0f;
            }
        };
    }

    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        actionGroup.addAction((AnAction)new SolutionViewToggleAction(UnityPluginActionsBundle.Companion.message("action.show.project.names.text", new Object[0]), UnityPluginActionsBundle.Companion.message("action.show.project.names.description", new Object[0]), AllIcons.Actions.ListFiles, () -> UnityExplorer.addToolbarActions$lambda$0(this), arg_0 -> UnityExplorer.addToolbarActions$lambda$1(this, arg_0))).setAsSecondary(true);
        actionGroup.addAction((AnAction)new SolutionViewToggleAction(UnityPluginActionsBundle.Companion.message("action.show.tilde.folders.text", new Object[0]), null, AllIcons.Actions.ListFiles, () -> UnityExplorer.addToolbarActions$lambda$2(this), arg_0 -> UnityExplorer.addToolbarActions$lambda$3(this, arg_0))).setAsSecondary(true);
        super.addToolbarActions(actionGroup);
    }

    public void addPrimaryToolbarActions(@NotNull DefaultActionGroup actionGroup) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        if (!ExperimentalUI.Companion.isNewUI()) {
            actionGroup.addAction(ActionManager.getInstance().getAction("ShowAllInUnityExplorer"));
            actionGroup.addSeparator();
        }
        super.addPrimaryToolbarActions(actionGroup);
    }

    private static final boolean addToolbarActions$lambda$0(UnityExplorer this$0) {
        return this$0.showProjectNames;
    }

    private static final Unit addToolbarActions$lambda$1(UnityExplorer this$0, boolean it) {
        this$0.showProjectNames = it;
        return Unit.INSTANCE;
    }

    private static final boolean addToolbarActions$lambda$2(UnityExplorer this$0) {
        return this$0.showTildeFolders;
    }

    private static final Unit addToolbarActions$lambda$3(UnityExplorer this$0, boolean it) {
        this$0.showTildeFolders = it;
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"meta", "tmp"};
        IgnoredExtensions = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0015j\b\u0012\u0004\u0012\u00020\u0005`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorer$Companion;", "", "<init>", "()V", "ID", "", "Title", "Weight", "", "ShowProjectNamesOption", "ShowTildeFoldersOption", "DefaultProjectPrefix", "DefaultProjectPrefixRegex", "Lkotlin/text/Regex;", "getDefaultProjectPrefixRegex", "()Lkotlin/text/Regex;", "Icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "IgnoredExtensions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getIgnoredExtensions", "()Ljava/util/HashSet;", "getInstance", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorer;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getDefaultProjectPrefixRegex() {
            return DefaultProjectPrefixRegex;
        }

        @NotNull
        public final Icon getIcon() {
            return Icon;
        }

        @NotNull
        public final HashSet<String> getIgnoredExtensions() {
            return IgnoredExtensions;
        }

        @NotNull
        public final UnityExplorer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            UnityExplorer unityExplorer = this.tryGetInstance(project);
            Intrinsics.checkNotNull((Object)((Object)unityExplorer));
            return unityExplorer;
        }

        @Nullable
        public final UnityExplorer tryGetInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AbstractProjectViewPane abstractProjectViewPane = ProjectView.getInstance((Project)project).getProjectViewPaneById(UnityExplorer.ID);
            return abstractProjectViewPane instanceof UnityExplorer ? (UnityExplorer)abstractProjectViewPane : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

