/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.plugins.unity.explorer.AncestorNodeType;
import com.jetbrains.rider.plugins.unity.explorer.PackageNode;
import com.jetbrains.rider.plugins.unity.explorer.ReadOnlyPackagesRootNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.explorer.UnknownPackageNode;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.UnityPackageSource;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspaceExtensionsKt;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import icons.UnityIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0014J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\"\u0010\u0018\u001a\u00020\t2\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/PackagesRootNode;", "Lcom/jetbrains/rider/plugins/unity/explorer/UnityExplorerFileSystemNode;", "project", "Lcom/intellij/openapi/project/Project;", "packagesFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "createNode", "Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "virtualFile", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "contains", "", "file", "addPackageNode", "children", "packageEntity", "Lcom/jetbrains/rider/plugins/unity/workspace/UnityPackageEntity;", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nPackageNodes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/PackagesRootNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,397:1\n1755#2,3:398\n774#2:401\n865#2,2:402\n1863#2,2:404\n774#2:406\n865#2,2:407\n1863#2,2:409\n1755#2,3:411\n*S KotlinDebug\n*F\n+ 1 PackageNodes.kt\ncom/jetbrains/rider/plugins/unity/explorer/PackagesRootNode\n*L\n41#1:398,3\n46#1:401\n46#1:402,2\n46#1:404,2\n47#1:406\n47#1:407,2\n47#1:409,2\n65#1:411,3\n*E\n"})
public final class PackagesRootNode
extends UnityExplorerFileSystemNode {
    public PackagesRootNode(@NotNull Project project, @NotNull VirtualFile packagesFolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packagesFolder, (String)"packagesFolder");
        super(project, packagesFolder, CollectionsKt.emptyList(), AncestorNodeType.FileSystem);
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (!this.getVirtualFile().isValid()) {
            return;
        }
        presentation.setPresentableText("Packages");
        presentation.setIcon(UnityIcons.Explorer.Companion.getPackagesRoot());
    }

    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        UnityPackageEntity it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        boolean bl;
        List<UnityPackageEntity> allPackages;
        List children;
        block8: {
            children = super.calculateChildren();
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            allPackages = UnityWorkspaceExtensionsKt.getPackages(WorkspaceModel.Companion.getInstance(project));
            Iterable $this$any$iv = allPackages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UnityPackageEntity it2 = (UnityPackageEntity)element$iv;
                    boolean bl2 = false;
                    if (!it2.isReadOnly()) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            children.add(0, new ReadOnlyPackagesRootNode(project));
        }
        Iterable $this$filter$iv = allPackages;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator bl2 = $this$filterTo$iv$iv.iterator();
        while (bl2.hasNext()) {
            element$iv$iv = bl2.next();
            it = (UnityPackageEntity)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getSource() == UnityPackageSource.Local)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnityPackageEntity it3 = (UnityPackageEntity)element$iv;
            boolean bl4 = false;
            this.addPackageNode(children, it3);
        }
        $this$filter$iv = allPackages;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl4 = $this$filterTo$iv$iv.iterator();
        while (bl4.hasNext()) {
            element$iv$iv = bl4.next();
            it = (UnityPackageEntity)element$iv$iv;
            boolean bl5 = false;
            if (!(it.getSource() == UnityPackageSource.Unknown)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnityPackageEntity it4 = (UnityPackageEntity)element$iv;
            boolean bl6 = false;
            this.addPackageNode(children, it4);
        }
        return children;
    }

    @Override
    @NotNull
    public FileSystemNodeBase createNode(@NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        if (virtualFile.isDirectory()) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            UnityPackageEntity unityPackageEntity = UnityWorkspaceExtensionsKt.tryGetPackage(WorkspaceModel.Companion.getInstance(project), virtualFile);
            if (unityPackageEntity != null) {
                UnityPackageEntity it = unityPackageEntity;
                boolean bl = false;
                Project project2 = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
                return new PackageNode(project2, virtualFile, it);
            }
        }
        return super.createNode(virtualFile, nestedFiles);
    }

    public boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$any$iv = this.getChildren();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractTreeNode it = (AbstractTreeNode)element$iv;
                    boolean bl2 = false;
                    SolutionViewNode solutionViewNode = it instanceof SolutionViewNode ? (SolutionViewNode)it : null;
                    boolean bl3 = solutionViewNode != null ? solutionViewNode.contains(file) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void addPackageNode(List<AbstractTreeNode<?>> children, UnityPackageEntity packageEntity) {
        VirtualFile packageFolder = packageEntity.getPackageFolder();
        if (packageFolder != null) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            v1 = children.add((AbstractTreeNode<?>)new PackageNode(project, packageFolder, packageEntity));
        } else {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            v1 = children.add(new UnknownPackageNode(project, packageEntity));
        }
    }
}

