/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.plugins.unity.workspace.UnityPackageEntity;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspaceExtensionsKt;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import icons.UnityIcons;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/PackageDependencyItemNode;", "Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "packageId", "", "version", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "isAlwaysLeaf", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "canNavigate", "navigate", "requestFocus", "intellij.rider.plugins.unity"})
public final class PackageDependencyItemNode
extends SolutionViewNode<Object> {
    @NotNull
    private final String packageId;

    public PackageDependencyItemNode(@NotNull Project project, @NotNull String packageId, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(project, (Object)(packageId + "@" + version));
        this.packageId = packageId;
        this.myName = this.packageId + "@" + version;
    }

    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        return new ArrayList();
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText(this.getName());
        presentation.setIcon(UnityIcons.Explorer.Companion.getPackageDependency());
    }

    public boolean canNavigate() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        UnityPackageEntity unityPackageEntity = UnityWorkspaceExtensionsKt.tryGetPackage(WorkspaceModel.Companion.getInstance(project), this.packageId);
        return (unityPackageEntity != null ? unityPackageEntity.getPackageFolder() : null) != null;
    }

    public void navigate(boolean requestFocus) {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        UnityPackageEntity unityPackageEntity = UnityWorkspaceExtensionsKt.tryGetPackage(WorkspaceModel.Companion.getInstance(project), this.packageId);
        if (unityPackageEntity == null || (unityPackageEntity = unityPackageEntity.getPackageFolder()) == null) {
            return;
        }
        UnityPackageEntity packageFolder = unityPackageEntity;
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        SolutionViewUtilsKt.navigateToSolutionView((Project)project2, (VirtualFile)packageFolder, (boolean)requestFocus);
    }
}

