/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.explorer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.prefixTree.set.MutablePrefixTreeSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unity.UnityProjectLifetimeService;
import com.jetbrains.rider.plugins.unity.explorer.UnityExplorerFileSystemNode;
import com.jetbrains.rider.plugins.unity.explorer.UnityPluginExplorerBundle;
import com.jetbrains.rider.plugins.unity.workspace.UnityWorkspacePackageUpdater;
import com.jetbrains.rider.projectView.VfsBackendRequester;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 (2\u00020\u0001:\u0004()*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\n2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\bH\u0003J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0002J\"\u0010\"\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u001e2\u0006\u0010$\u001a\u00020\u001eH\u0003J \u0010%\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker;", "Lcom/jetbrains/rider/projectView/VfsBackendRequester;", "<init>", "()V", "lock", "Ljava/lang/Object;", "projects", "", "Lcom/intellij/openapi/project/Project;", "register", "", "project", "actionsPerProject", "", "Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList;", "onEvent", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "getOrCreate", "isValidEvent", "", "event", "isUndoRedoInProgress", "isMetaFile", "isApplicableForProject", "getMetaFile", "Ljava/nio/file/Path;", "path", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "getMetaFileName", "fileName", "shouldCreateMetaFile", "assetFile", "parent", "createMetaFile", "metaFileName", "ls", "Companion", "MetaActionList", "MetaAction", "MetaGroupId", "intellij.rider.plugins.unity"})
@SourceDebugExtension(value={"SMAP\nMetaTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,290:1\n1#2:291\n774#3:292\n865#3,2:293\n13#4:295\n15#5:296\n*S KotlinDebug\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker\n*L\n64#1:292\n64#1:293,2\n51#1:295\n51#1:296\n*E\n"})
public final class MetaTracker
implements VfsBackendRequester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private Set<Project> projects = new LinkedHashSet();
    @NotNull
    private final Map<Project, MetaActionList> actionsPerProject = new LinkedHashMap();
    @NotNull
    private static final Logger logger;

    public final void register(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Lifetime lifetime = UnityProjectLifetimeService.Companion.getLifetime(project);
        lifetime.bracketIfAlive(() -> MetaTracker.register$lambda$1(this, project), () -> MetaTracker.register$lambda$3(this, project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onEvent(@NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Iterable $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Object object = this.lock;
        synchronized (object) {
            List list;
            boolean $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232 = false;
            List it = list = (List)new ArrayList();
            boolean bl3 = false;
            it.addAll((Collection)this.projects);
            $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232 = list;
        }
        Iterable $this$filter$iv = $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232;
        boolean bl = false;
        $i$a$-synchronized-MetaTracker$onEvent$unityProjects$232 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.isUndoRedoInProgress(it) && !it.isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unityProjects = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        for (VFileEvent vFileEvent : events) {
            if (!this.isValidEvent(vFileEvent)) continue;
            for (Object e : unityProjects) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Project project = (Project)e;
                if (!this.isApplicableForProject(vFileEvent, project)) continue;
                MetaActionList actions = this.getOrCreate(project);
                if (this.isMetaFile(vFileEvent)) {
                    Path path = Paths.get(vFileEvent.getPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    actions.addInitialSetOfChangedMetaFiles(path);
                    continue;
                }
                try {
                    Path metaFile;
                    VFileEvent bl3 = vFileEvent;
                    if (bl3 instanceof VFileCreateEvent) {
                        String string = ((VFileCreateEvent)vFileEvent).getChildName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                        String metaFileName = this.getMetaFileName(string);
                        Path metaFile2 = ((VFileCreateEvent)vFileEvent).getParent().toNioPath().resolve(metaFileName);
                        Object object2 = ((VFileCreateEvent)vFileEvent).getFile();
                        if (object2 == null || (object2 = object2.getDetectedLineSeparator()) == null) {
                            object2 = "\n";
                        }
                        Object ls = object2;
                        Intrinsics.checkNotNull((Object)metaFile2);
                        actions.add(metaFile2, project, (Function0<Unit>)((Function0)() -> MetaTracker.onEvent$lambda$7(this, project, vFileEvent, metaFileName, (String)ls)));
                        continue;
                    }
                    if (bl3 instanceof VFileDeleteEvent) {
                        if (this.getMetaFile(((VFileDeleteEvent)vFileEvent).getPath()) == null) continue;
                        actions.add(metaFile, project, (Function0<Unit>)((Function0)() -> MetaTracker.onEvent$lambda$8(metaFile, this)));
                        continue;
                    }
                    if (bl3 instanceof VFileCopyEvent) {
                        if (this.getMetaFile(((VFileCopyEvent)vFileEvent).getFile().getPath()) == null) continue;
                        String string = ((VFileCopyEvent)vFileEvent).getFile().getDetectedLineSeparator();
                        if (string == null) {
                            string = "\n";
                        }
                        String ls = string;
                        actions.add(metaFile, project, (Function0<Unit>)((Function0)() -> MetaTracker.onEvent$lambda$9(this, project, vFileEvent, ls)));
                        continue;
                    }
                    if (bl3 instanceof VFileMoveEvent) {
                        if (this.getMetaFile(((VFileMoveEvent)vFileEvent).getOldPath()) == null) continue;
                        actions.add(metaFile, project, (Function0<Unit>)((Function0)() -> MetaTracker.onEvent$lambda$10(metaFile, this, vFileEvent)));
                        continue;
                    }
                    if (!(bl3 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename() || this.getMetaFile(((VFilePropertyChangeEvent)vFileEvent).getOldPath()) == null) continue;
                    actions.add(metaFile, project, (Function0<Unit>)((Function0)() -> MetaTracker.onEvent$lambda$11(this, vFileEvent, metaFile)));
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            }
        }
    }

    private final MetaActionList getOrCreate(Project project) {
        MetaActionList actions = this.actionsPerProject.get(project);
        if (actions == null) {
            actions = new MetaActionList(project);
            CollectionExKt.addUnique(this.actionsPerProject, (Lifetime)UnityProjectLifetimeService.Companion.getLifetime(project), (Object)project, (Object)actions);
        }
        return actions;
    }

    private final boolean isValidEvent(VFileEvent event) {
        if (event.isFromRefresh()) {
            return false;
        }
        if (!(event.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        return CommandProcessor.getInstance().getCurrentCommand() != null;
    }

    private final boolean isUndoRedoInProgress(Project project) {
        return UndoManager.getInstance((Project)project).isUndoOrRedoInProgress();
    }

    private final boolean isMetaFile(VFileEvent event) {
        Object object = event.getFile();
        if (object == null || (object = object.getExtension()) == null) {
            object = PathUtil.getFileExtension((String)event.getPath());
        }
        Object extension = object;
        return StringsKt.equals((String)"meta", (String)extension, (boolean)true);
    }

    @RequiresEdt
    private final boolean isApplicableForProject(VFileEvent event, Project project) {
        VirtualFile virtualFile = event.getFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return CollectionsKt.any((Iterable)UnityWorkspacePackageUpdater.Companion.getInstance(project).getSourceRootsTree().getAncestors((Object)file));
    }

    private final Path getMetaFile(String path) {
        if (path == null) {
            return null;
        }
        Path file = Paths.get(path, new String[0]);
        Intrinsics.checkNotNull((Object)file);
        String metaFileName = this.getMetaFileName(PathsKt.getName((Path)file));
        return file.getParent().resolve(metaFileName);
    }

    private final VirtualFile getMetaFile(VirtualFile file) {
        if (file == null) {
            return null;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String metaFileName = this.getMetaFileName(string);
        VirtualFile virtualFile = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        return VirtualFileUtil.findFile((VirtualFile)virtualFile, (String)metaFileName);
    }

    private final String getMetaFileName(String fileName) {
        return fileName + ".meta";
    }

    @RequiresEdt
    private final boolean shouldCreateMetaFile(Project project, VirtualFile assetFile, VirtualFile parent) {
        MutablePrefixTreeSet<VirtualFile> roots = UnityWorkspacePackageUpdater.Companion.getInstance(project).getSourceRootsTree();
        if (UnityExplorerFileSystemNode.Companion.isHiddenAsset(assetFile) || !roots.contains((Object)parent) && this.getMetaFile(parent) == null) {
            logger.info("avoid adding meta file for " + assetFile + ".");
            return false;
        }
        return true;
    }

    private final void createMetaFile(VirtualFile parent, String metaFileName, String ls) {
        VirtualFile virtualFile = parent.createChildData((Object)this, metaFileName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildData(...)");
        VirtualFile metaFile = virtualFile;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
        int n = 0;
        int n2 = 32;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String guid = string3;
        long timestamp = LocalDateTime.now(ZoneOffset.UTC).atZone(ZoneOffset.UTC).toEpochSecond();
        String content = "fileFormatVersion: 2" + ls + "guid: " + guid + ls + "timeCreated: " + timestamp;
        VfsUtil.saveText((VirtualFile)metaFile, (String)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean register$lambda$1(MetaTracker this$0, Project $project) {
        boolean bl;
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this$0.projects.add($project);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit register$lambda$3(MetaTracker this$0, Project $project) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.projects.remove($project);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$7(MetaTracker this$0, Project $project, VFileEvent $event, String $metaFileName, String $ls) {
        VirtualFile virtualFile = ((VFileCreateEvent)$event).getFile();
        VirtualFile virtualFile2 = ((VFileCreateEvent)$event).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        if (this$0.shouldCreateMetaFile($project, virtualFile, virtualFile2)) {
            VirtualFile virtualFile3 = ((VFileCreateEvent)$event).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getParent(...)");
            this$0.createMetaFile(virtualFile3, $metaFileName, $ls);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$8(Path $metaFile, MetaTracker this$0) {
        VirtualFile fileToDelete = VfsUtil.findFile((Path)$metaFile, (boolean)true);
        if (fileToDelete != null) {
            VirtualFileUtil.readBytes((VirtualFile)fileToDelete);
            fileToDelete.delete((Object)this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$9(MetaTracker this$0, Project $project, VFileEvent $event, String $ls) {
        VirtualFile virtualFile = ((VFileCopyEvent)$event).getFile();
        VirtualFile virtualFile2 = ((VFileCopyEvent)$event).getNewParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getNewParent(...)");
        if (this$0.shouldCreateMetaFile($project, virtualFile, virtualFile2)) {
            VirtualFile virtualFile3 = ((VFileCopyEvent)$event).getNewParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getNewParent(...)");
            String string = ((VFileCopyEvent)$event).getNewChildName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewChildName(...)");
            this$0.createMetaFile(virtualFile3, this$0.getMetaFileName(string), $ls);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$10(Path $metaFile, MetaTracker this$0, VFileEvent $event) {
        block0: {
            VirtualFile virtualFile = VfsUtil.findFile((Path)$metaFile, (boolean)true);
            if (virtualFile == null) break block0;
            virtualFile.move((Object)this$0, ((VFileMoveEvent)$event).getNewParent());
        }
        return Unit.INSTANCE;
    }

    private static final Unit onEvent$lambda$11(MetaTracker this$0, VFileEvent $event, Path $metaFile) {
        block1: {
            VirtualFile conflictingMeta;
            Object object = ((VFilePropertyChangeEvent)$event).getNewValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String target = this$0.getMetaFileName((String)object);
            VirtualFile origin = VfsUtil.findFile((Path)$metaFile, (boolean)true);
            VirtualFile virtualFile = origin;
            VirtualFile virtualFile2 = virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.findChild(target) : (conflictingMeta = null);
            if (conflictingMeta != null) {
                logger.warn("Removing conflicting meta " + conflictingMeta);
                conflictingMeta.delete((Object)this$0);
            }
            VirtualFile virtualFile3 = origin;
            if (virtualFile3 == null) break block1;
            virtualFile3.rename((Object)this$0, target);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MetaTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MetaTracker.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nMetaTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,290:1\n40#2,3:291\n*S KotlinDebug\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$Companion\n*L\n50#1:291,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MetaTracker getInstance() {
            boolean $i$f$service = false;
            Class<MetaTracker> serviceClass$iv = MetaTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MetaTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaAction;", "", "metaFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "getMetaFile", "()Ljava/nio/file/Path;", "getProject", "()Lcom/intellij/openapi/project/Project;", "execute", "intellij.rider.plugins.unity"})
    private static final class MetaAction {
        @NotNull
        private final Path metaFile;
        @NotNull
        private final Project project;
        @NotNull
        private final Function0<Unit> action;

        public MetaAction(@NotNull Path metaFile, @NotNull Project project, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)metaFile, (String)"metaFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.metaFile = metaFile;
            this.project = project;
            this.action = action;
        }

        @NotNull
        public final Path getMetaFile() {
            return this.metaFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public final void execute() {
            try {
                this.action.invoke();
            }
            catch (Throwable ex) {
                logger.error(ex);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0003J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\nJ$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "clear", "", "changedMetaFiles", "Ljava/util/HashSet;", "Ljava/nio/file/Path;", "actions", "", "Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaAction;", "nextGroupIdIndex", "", "addInitialSetOfChangedMetaFiles", "path", "add", "metaFile", "action", "Lkotlin/Function0;", "execute", "getCommandName", "", "intellij.rider.plugins.unity"})
    @SourceDebugExtension(value={"SMAP\nMetaTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1863#2,2:291\n*S KotlinDebug\n*F\n+ 1 MetaTracker.kt\ncom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaActionList\n*L\n250#1:291,2\n*E\n"})
    private static final class MetaActionList {
        @NotNull
        private final HashSet<Path> changedMetaFiles;
        @NotNull
        private final List<MetaAction> actions;
        private int nextGroupIdIndex;

        public MetaActionList(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            MessageBusConnection connection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UnityProjectLifetimeService.Companion.getLifetime(project), null, (int)1, null));
            Topic topic = CommandListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new CommandListener(){

                public void beforeCommandFinished(CommandEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.execute();
                    this.clear();
                    super.beforeCommandFinished(event);
                }
            });
            this.changedMetaFiles = new HashSet();
            this.actions = new ArrayList();
        }

        @RequiresEdt
        private final void clear() {
            this.changedMetaFiles.clear();
            this.actions.clear();
        }

        public final void addInitialSetOfChangedMetaFiles(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.changedMetaFiles.add(path);
        }

        public final void add(@NotNull Path metaFile, @NotNull Project project, @NotNull Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)metaFile, (String)"metaFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.changedMetaFiles.contains(metaFile)) {
                return;
            }
            this.actions.add(new MetaAction(metaFile, project, action));
        }

        public final void execute() {
            if (this.actions.isEmpty()) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Ref.ObjectRef groupId = new Ref.ObjectRef();
            groupId.element = commandProcessor.getCurrentCommandGroupId();
            if (groupId.element == null) {
                int n = this.nextGroupIdIndex;
                this.nextGroupIdIndex = n + 1;
                groupId.element = new MetaGroupId(n);
                commandProcessor.setCurrentCommandGroupId(groupId.element);
            }
            commandProcessor.allowMergeGlobalCommands(() -> MetaActionList.execute$lambda$3(this, commandProcessor, groupId));
        }

        @Nls
        @NotNull
        public final String getCommandName() {
            String string;
            if (((Collection)this.actions).size() == 1) {
                Object[] objectArray = new Object[]{PathsKt.getName((Path)((MetaAction)CollectionsKt.single(this.actions)).getMetaFile())};
                string = UnityPluginExplorerBundle.Companion.message("process.one.meta.file", objectArray);
            } else {
                Object[] objectArray = new Object[]{((Collection)this.actions).size()};
                string = UnityPluginExplorerBundle.Companion.message("process.several.meta.files", objectArray);
            }
            return string;
        }

        private static final void execute$lambda$3$lambda$2$lambda$1$lambda$0(MetaActionList this$0, MetaAction $it) {
            if (!this$0.changedMetaFiles.contains($it.getMetaFile())) {
                $it.execute();
            }
        }

        private static final void execute$lambda$3$lambda$2$lambda$1(MetaActionList this$0, MetaAction $it) {
            ApplicationKt.getApplication().runWriteAction(() -> MetaActionList.execute$lambda$3$lambda$2$lambda$1$lambda$0(this$0, $it));
        }

        private static final void execute$lambda$3(MetaActionList this$0, CommandProcessor $commandProcessor, Ref.ObjectRef $groupId) {
            Iterable $this$forEach$iv = this$0.actions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MetaAction it = (MetaAction)element$iv;
                boolean bl = false;
                $commandProcessor.executeCommand(it.getProject(), () -> MetaActionList.execute$lambda$3$lambda$2$lambda$1(this$0, it), this$0.getCommandName(), $groupId.element);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/unity/explorer/MetaTracker$MetaGroupId;", "", "index", "", "<init>", "(I)V", "getIndex", "()I", "toString", "", "intellij.rider.plugins.unity"})
    private static final class MetaGroupId {
        private final int index;

        public MetaGroupId(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public String toString() {
            return "MetaGroupId" + this.index;
        }
    }
}

