/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.breakpoints;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointBreakpointType;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a4\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u001a0\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a \u0010\u000f\u001a\u0004\u0018\u00010\n2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a0\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0013"}, d2={"convertToPausepoint", "", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "providedEditor", "Lcom/intellij/openapi/editor/Editor;", "providedIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "convertToLineBreakpoint", "tryGetIconRendererLocation", "Ljava/awt/Point;", "tryGetEditor", "tryGetGutterIconRenderer", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "tryEditBreakpoint", "whereToShow", "intellij.rider.plugins.unity"})
public final class UnityPausepointsKt {
    public static final void convertToPausepoint(@NotNull Project project, @NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @Nullable Editor providedEditor, @Nullable GutterIconRenderer providedIconRenderer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> UnityPausepointsKt.convertToPausepoint$lambda$2(project, providedEditor, breakpoint, providedIconRenderer));
    }

    public static /* synthetic */ void convertToPausepoint$default(Project project, XLineBreakpoint xLineBreakpoint, Editor editor, GutterIconRenderer gutterIconRenderer, int n, Object object) {
        if ((n & 4) != 0) {
            editor = null;
        }
        if ((n & 8) != 0) {
            gutterIconRenderer = null;
        }
        UnityPausepointsKt.convertToPausepoint(project, (XLineBreakpoint<DotNetLineBreakpointProperties>)xLineBreakpoint, editor, gutterIconRenderer);
    }

    public static final void convertToLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @Nullable Editor providedEditor, @Nullable GutterIconRenderer providedIconRenderer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        UIUtil.invokeLaterIfNeeded(() -> UnityPausepointsKt.convertToLineBreakpoint$lambda$5(project, providedEditor, breakpoint, providedIconRenderer));
    }

    public static /* synthetic */ void convertToLineBreakpoint$default(Project project, XLineBreakpoint xLineBreakpoint, Editor editor, GutterIconRenderer gutterIconRenderer, int n, Object object) {
        if ((n & 4) != 0) {
            editor = null;
        }
        if ((n & 8) != 0) {
            gutterIconRenderer = null;
        }
        UnityPausepointsKt.convertToLineBreakpoint(project, (XLineBreakpoint<DotNetLineBreakpointProperties>)xLineBreakpoint, editor, gutterIconRenderer);
    }

    @Nullable
    public static final Point tryGetIconRendererLocation(@NotNull Project project, @Nullable Editor providedEditor, @NotNull XLineBreakpoint<?> breakpoint, @Nullable GutterIconRenderer providedIconRenderer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Editor editor = UnityPausepointsKt.tryGetEditor(project, providedEditor);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        GutterIconRenderer gutterIconRenderer = UnityPausepointsKt.tryGetGutterIconRenderer((XBreakpoint)breakpoint, providedIconRenderer);
        if (gutterIconRenderer == null) {
            return null;
        }
        GutterIconRenderer renderer = gutterIconRenderer;
        EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
        return editorEx != null && (editorEx = editorEx.getGutterComponentEx()) != null ? editorEx.getCenterPoint(renderer) : null;
    }

    private static final Editor tryGetEditor(Project project, Editor providedEditor) {
        if (providedEditor != null) {
            return providedEditor;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
        TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
        return textEditor != null ? textEditor.getEditor() : null;
    }

    private static final GutterIconRenderer tryGetGutterIconRenderer(XBreakpoint<?> breakpoint, GutterIconRenderer providedIconRenderer) {
        GutterIconRenderer gutterIconRenderer;
        block2: {
            GutterIconRenderer gutterIconRenderer2 = providedIconRenderer;
            if (gutterIconRenderer2 != null) {
                return gutterIconRenderer2;
            }
            List list = DebuggerSupport.getDebuggerSupports();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDebuggerSupports(...)");
            for (DebuggerSupport it : (Iterable)list) {
                boolean bl = false;
                GutterIconRenderer gutterIconRenderer3 = it.getBreakpointPanelProvider().getBreakpointGutterIconRenderer(breakpoint);
                if (gutterIconRenderer3 == null) continue;
                gutterIconRenderer = gutterIconRenderer3;
                break block2;
            }
            gutterIconRenderer = null;
        }
        return gutterIconRenderer;
    }

    private static final void tryEditBreakpoint(Project project, XBreakpoint<?> breakpoint, Point whereToShow, Editor providedEditor) {
        Editor editor = UnityPausepointsKt.tryGetEditor(project, providedEditor);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (!BreakpointsDialogFactory.getInstance((Project)project).popupRequested(breakpoint)) {
            EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
            if (editorEx == null || (editorEx = editorEx.getGutterComponentEx()) == null) {
                return;
            }
            EditorEx gutterComponent = editorEx;
            DebuggerUIUtil.showXBreakpointEditorBalloon((Project)project, (Point)whereToShow, (JComponent)((JComponent)gutterComponent), (boolean)false, breakpoint);
        }
    }

    private static final void convertToPausepoint$lambda$2$lambda$1(Project $project, Editor $providedEditor, XLineBreakpoint $breakpoint, GutterIconRenderer $providedIconRenderer) {
        XLineBreakpoint xLineBreakpoint;
        XDependentBreakpointManager dependentBreakpointManager;
        Point balloonLocation = UnityPausepointsKt.tryGetIconRendererLocation($project, $providedEditor, $breakpoint, $providedIconRenderer);
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)$project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        XBreakpointManagerImpl xBreakpointManagerImpl = breakpointManager instanceof XBreakpointManagerImpl ? (XBreakpointManagerImpl)breakpointManager : null;
        XDependentBreakpointManager xDependentBreakpointManager = dependentBreakpointManager = xBreakpointManagerImpl != null ? xBreakpointManagerImpl.getDependentBreakpointManager() : null;
        XBreakpoint masterBreakpoint = xDependentBreakpointManager != null ? xDependentBreakpointManager.getMasterBreakpoint((XBreakpoint)$breakpoint) : null;
        XDependentBreakpointManager xDependentBreakpointManager2 = dependentBreakpointManager;
        boolean leaveEnabled = xDependentBreakpointManager2 != null ? xDependentBreakpointManager2.isLeaveEnabled((XBreakpoint)$breakpoint) : false;
        breakpointManager.removeBreakpoint((XBreakpoint)$breakpoint);
        UnityPausepointBreakpointType unityPausepointType = (UnityPausepointBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(UnityPausepointBreakpointType.class);
        XLineBreakpoint $this$convertToPausepoint_u24lambda_u242_u24lambda_u241_u24lambda_u240 = xLineBreakpoint = breakpointManager.addLineBreakpoint((XLineBreakpointType)unityPausepointType, $breakpoint.getFileUrl(), $breakpoint.getLine(), $breakpoint.getProperties());
        boolean bl = false;
        $this$convertToPausepoint_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSuspendPolicy(SuspendPolicy.NONE);
        $this$convertToPausepoint_u24lambda_u242_u24lambda_u241_u24lambda_u240.setConditionExpression($breakpoint.getConditionExpression());
        if (masterBreakpoint != null) {
            dependentBreakpointManager.setMasterBreakpoint((XBreakpoint)$this$convertToPausepoint_u24lambda_u242_u24lambda_u241_u24lambda_u240, masterBreakpoint, leaveEnabled);
        }
        XLineBreakpoint xLineBreakpoint2 = xLineBreakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)xLineBreakpoint2, (String)"apply(...)");
        XLineBreakpoint newBreakpoint = xLineBreakpoint2;
        UnityPausepointsKt.tryEditBreakpoint($project, (XBreakpoint)newBreakpoint, balloonLocation, $providedEditor);
    }

    private static final void convertToPausepoint$lambda$2(Project $project, Editor $providedEditor, XLineBreakpoint $breakpoint, GutterIconRenderer $providedIconRenderer) {
        ApplicationKt.getApplication().runWriteAction(() -> UnityPausepointsKt.convertToPausepoint$lambda$2$lambda$1($project, $providedEditor, $breakpoint, $providedIconRenderer));
    }

    private static final void convertToLineBreakpoint$lambda$5$lambda$4(Project $project, Editor $providedEditor, XLineBreakpoint $breakpoint, GutterIconRenderer $providedIconRenderer) {
        XLineBreakpoint xLineBreakpoint;
        XDependentBreakpointManager dependentBreakpointManager;
        Point balloonLocation = UnityPausepointsKt.tryGetIconRendererLocation($project, $providedEditor, $breakpoint, $providedIconRenderer);
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)$project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        XBreakpointManagerImpl xBreakpointManagerImpl = breakpointManager instanceof XBreakpointManagerImpl ? (XBreakpointManagerImpl)breakpointManager : null;
        XDependentBreakpointManager xDependentBreakpointManager = dependentBreakpointManager = xBreakpointManagerImpl != null ? xBreakpointManagerImpl.getDependentBreakpointManager() : null;
        XBreakpoint masterBreakpoint = xDependentBreakpointManager != null ? xDependentBreakpointManager.getMasterBreakpoint((XBreakpoint)$breakpoint) : null;
        XDependentBreakpointManager xDependentBreakpointManager2 = dependentBreakpointManager;
        boolean leaveEnabled = xDependentBreakpointManager2 != null ? xDependentBreakpointManager2.isLeaveEnabled((XBreakpoint)$breakpoint) : false;
        breakpointManager.removeBreakpoint((XBreakpoint)$breakpoint);
        DotNetLineBreakpointType dotnetLineBreakpointType = (DotNetLineBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(DotNetLineBreakpointType.class);
        XLineBreakpoint $this$convertToLineBreakpoint_u24lambda_u245_u24lambda_u244_u24lambda_u243 = xLineBreakpoint = breakpointManager.addLineBreakpoint((XLineBreakpointType)dotnetLineBreakpointType, $breakpoint.getFileUrl(), $breakpoint.getLine(), $breakpoint.getProperties());
        boolean bl = false;
        $this$convertToLineBreakpoint_u24lambda_u245_u24lambda_u244_u24lambda_u243.setConditionExpression($breakpoint.getConditionExpression());
        if (masterBreakpoint != null) {
            dependentBreakpointManager.setMasterBreakpoint((XBreakpoint)$this$convertToLineBreakpoint_u24lambda_u245_u24lambda_u244_u24lambda_u243, masterBreakpoint, leaveEnabled);
        }
        XLineBreakpoint xLineBreakpoint2 = xLineBreakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)xLineBreakpoint2, (String)"apply(...)");
        XLineBreakpoint newBreakpoint = xLineBreakpoint2;
        UnityPausepointsKt.tryEditBreakpoint($project, (XBreakpoint)newBreakpoint, balloonLocation, $providedEditor);
    }

    private static final void convertToLineBreakpoint$lambda$5(Project $project, Editor $providedEditor, XLineBreakpoint $breakpoint, GutterIconRenderer $providedIconRenderer) {
        ApplicationKt.getApplication().runWriteAction(() -> UnityPausepointsKt.convertToLineBreakpoint$lambda$5$lambda$4($project, $providedEditor, $breakpoint, $providedIconRenderer));
    }
}

