/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.debugger.actions.handlers;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.rd.framework.impl.RdProperty;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.plugins.unity.actions.ActionUtilsKt;
import com.jetbrains.rider.plugins.unity.debugger.breakpoints.UnityPausepointBreakpointType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/actions/handlers/AddPauseBreakpoint;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.rider.plugins.unity"})
public final class AddPauseBreakpoint
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        XLineBreakpoint xLineBreakpoint;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        Project project = (Project)object;
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        XSourcePosition xSourcePosition = AddPauseBreakpoint.Companion.getLineBreakpointPosition(e);
        Intrinsics.checkNotNull((Object)xSourcePosition);
        XSourcePosition position = xSourcePosition;
        UnityPausepointBreakpointType unityPausepointType = (UnityPausepointBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(UnityPausepointBreakpointType.class);
        VirtualFile virtualFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        DotNetLineBreakpointProperties properties = unityPausepointType.createBreakpointProperties(virtualFile, position.getLine());
        XLineBreakpoint $this$actionPerformed_u24lambda_u240 = xLineBreakpoint = breakpointManager.addLineBreakpoint((XLineBreakpointType)unityPausepointType, position.getFile().getUrl(), position.getLine(), (XBreakpointProperties)properties);
        boolean bl = false;
        $this$actionPerformed_u24lambda_u240.setSuspendPolicy(SuspendPolicy.NONE);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RdProperty<Boolean> isUnityProject = ActionUtilsKt.isUnityProjectFolder(e);
        e.getPresentation().setEnabledAndVisible(ActionUtilsKt.getValueOrDefault(isUnityProject) && ExperimentalUI.Companion.isNewUI() && AddPauseBreakpoint.Companion.getLineBreakpointPosition(e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/unity/debugger/actions/handlers/AddPauseBreakpoint$Companion;", "", "<init>", "()V", "getLineBreakpointPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        private final XSourcePosition getLineBreakpointPosition(AnActionEvent e) {
            Project project = e.getProject();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (project != null && editor != null && file != null) {
                EditorGutter editorGutter = editor.getGutter();
                Intrinsics.checkNotNullExpressionValue((Object)editorGutter, (String)"getGutter(...)");
                EditorGutter gutter = editorGutter;
                if (gutter instanceof EditorGutterComponentEx) {
                    Object lineNumber = ((EditorGutterComponentEx)gutter).getClientProperty((Object)"active.line.number");
                    if (!(lineNumber instanceof Integer)) {
                        lineNumber = e.getData(XDebuggerManagerImpl.ACTIVE_LINE_NUMBER);
                    }
                    if (lineNumber != null) {
                        LogicalPosition pos = new LogicalPosition(((Integer)lineNumber).intValue(), 0);
                        return (XSourcePosition)XSourcePositionImpl.createByOffset((VirtualFile)file, (int)editor.logicalPositionToOffset(pos));
                    }
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

