/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity.actions;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rider.plugins.unity.FrontendBackendHostKt;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.plugins.unity.model.UnityApplicationData;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel;
import com.jetbrains.rider.plugins.unity.model.frontendBackend.FrontendBackendModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unity.util.Utils;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/unity/actions/ShowFileInUnityAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.rider.plugins.unity"})
public class ShowFileInUnityAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = ShowFileInUnityAction.Companion.getFile(e);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        Companion.execute(project2, file);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        e.getPresentation().setEnabledAndVisible((Boolean)UnityProjectDiscovererKt.isUnityProject(project2).getValue() != false && ShowFileInUnityAction.Companion.getFile(e) != null && (!e.isFromContextMenu() || editor == null || !editor.getSelectionModel().hasSelection()));
        e.getPresentation().setEnabled(FrontendBackendHostKt.isConnectedToEditor(project2));
        super.update(e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/unity/actions/ShowFileInUnityAction$Companion;", "", "<init>", "()V", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile getFile(AnActionEvent e) {
            return RevealFileAction.findLocalFile((VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)));
        }

        public final void execute(@NotNull Project project, @NotNull VirtualFile file) {
            Integer value;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FrontendBackendModel model = FrontendBackendModel_PregeneratedKt.getFrontendBackendModel(SolutionHostExtensionsKt.getSolution((Project)project));
            UnityApplicationData unityApplicationData = (UnityApplicationData)model.getUnityApplicationData().getValueOrNull();
            Integer n = value = unityApplicationData != null ? unityApplicationData.getUnityProcessId() : null;
            if (value != null) {
                Utils.Companion.AllowUnitySetForegroundWindow(value);
            }
            ISignal<String> iSignal = model.getShowFileInUnity();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            iSignal.fire((Object)string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

