/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.jetbrains.rider.plugins.unity.UnityBundle;
import com.jetbrains.rider.plugins.unity.UnityProjectDiscovererKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/unity/UnityIgnoredFileProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "<init>", "()V", "isIgnoredFile", "", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "getPluginPath", "Ljava/io/File;", "file", "getIgnoredGroupDescription", "", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "Companion", "intellij.rider.plugins.unity"})
public final class UnityIgnoredFileProvider
implements IgnoredFileProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashSet<String> ignoredExtensions;

    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!((Boolean)UnityProjectDiscovererKt.isUnityProject(project).getValue()).booleanValue()) {
            return false;
        }
        File solDir = SolutionHostExtensionsKt.getSolutionDirectory((Project)project);
        File[] fileArray = new File[]{new File(solDir, "Library"), new File(solDir, "library"), new File(solDir, "Temp"), new File(solDir, "temp"), new File(solDir, "Obj"), new File(solDir, "obj"), new File(solDir, "Build"), new File(solDir, "build"), new File(solDir, "Builds"), new File(solDir, "builds"), new File(solDir, "Logs"), new File(solDir, "logs"), new File(solDir, "MemoryCaptures"), new File(solDir, "memoryCaptures"), this.getPluginPath(new File(solDir, "Assets")), this.getPluginPath(new File(solDir, "assets"))};
        File[] ignoredFolders = fileArray;
        String string = filePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"sysinfo.txt") || Intrinsics.areEqual((Object)name, (Object)"crashlytics-build.properties")) {
            return true;
        }
        Iterator<String> iterator = ignoredExtensions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String ext;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (!StringsKt.endsWith$default((String)name, (String)ext, (boolean)false, (int)2, null)) continue;
            return true;
        }
        for (File ignoredFolder : ignoredFolders) {
            if (!VfsUtil.isAncestor((File)ignoredFolder, (File)filePath.getIOFile(), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private final File getPluginPath(File file) {
        return FilesKt.resolve((File)file, (String)"Plugins/Editor/Jetbrains");
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        return UnityBundle.Companion.message("text.unity.ignored.files", new Object[0]);
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new LinkedHashSet();
    }

    static {
        Object[] objectArray = new String[]{".apk", ".unitypackage", ".pidb.meta", "mdb.meta", "pdb.meta"};
        ignoredExtensions = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/unity/UnityIgnoredFileProvider$Companion;", "", "<init>", "()V", "ignoredExtensions", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getIgnoredExtensions", "()Ljava/util/HashSet;", "intellij.rider.plugins.unity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashSet<String> getIgnoredExtensions() {
            return ignoredExtensions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

