/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.jetbrains.rider.plugins.fsharp.FSharpBundle;
import com.jetbrains.rider.settings.RiderCodeStyleOptionPageProvider;
import com.jetbrains.rider.settings.RiderLanguageCodeStyleSettingsProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\f0\r\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0012H\u0016J!\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u00140\u00122\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/settings/FSharpCodeStyleSettingsProviderBase;", "Lcom/jetbrains/rider/settings/RiderLanguageCodeStyleSettingsProvider;", "lang", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "getLanguage", "getHelpTopic", "", "getConfigurableDisplayName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getPagesId", "", "filterPages", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "filterTag", "intellij.rider.plugins.fsharp"})
public abstract class FSharpCodeStyleSettingsProviderBase
extends RiderLanguageCodeStyleSettingsProvider {
    @NotNull
    private final Language lang;

    public FSharpCodeStyleSettingsProviderBase(@NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        this.lang = lang;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        return RiderCodeStyleOptionPageProvider.createRiderConfigurable$default((RiderCodeStyleOptionPageProvider)((RiderCodeStyleOptionPageProvider)this), (CodeStyleSettings)baseSettings, (CodeStyleSettings)modelSettings, (Language)this.getLanguage(), (String)this.getConfigurableDisplayName(), null, (int)16, null);
    }

    @NotNull
    public Language getLanguage() {
        return this.lang;
    }

    @NotNull
    public String getHelpTopic() {
        return "Settings_Code_Style_FSHARP";
    }

    @NotNull
    public String getConfigurableDisplayName() {
        String string = this.lang.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @NotNull
    public Map<String, String> getPagesId() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"FSharpCodeStylePage", (Object)FSharpBundle.message("Options.code.style.page.title", new Object[0])), TuplesKt.to((Object)"FantomasPage", (Object)FSharpBundle.message("Options.fantomas.page.title", new Object[0]))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public Map<String, String> filterPages(@NotNull String filterTag) {
        Intrinsics.checkNotNullParameter((Object)filterTag, (String)"filterTag");
        return Intrinsics.areEqual((Object)filterTag, (Object)"EditorConfig") ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"FSharpCodeStylePage", (Object)FSharpBundle.message("Options.code.style.page.title", new Object[0]))) : super.filterPages(filterTag);
    }
}

