/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.services.fsi;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.fsharp.services.fsi.CommandHistory;
import com.jetbrains.rider.plugins.fsharp.services.fsi.HistoryUpdateListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001bB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/HistoryKeyListener;", "Ljava/awt/event/KeyAdapter;", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/HistoryUpdateListener;", "project", "Lcom/intellij/openapi/project/Project;", "consoleEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "history", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/CommandHistory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rider/plugins/fsharp/services/fsi/CommandHistory;)V", "historyPos", "", "unfinishedCommand", "", "curCursorLine", "prevCursorLine", "onNewEntry", "", "entry", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/CommandHistory$Entry;", "keyReleased", "e", "Ljava/awt/event/KeyEvent;", "moveHistoryCursor", "move", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/HistoryKeyListener$HistoryMove;", "HistoryMove", "intellij.rider.plugins.fsharp"})
public final class HistoryKeyListener
extends KeyAdapter
implements HistoryUpdateListener {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx consoleEditor;
    @NotNull
    private final CommandHistory history;
    private int historyPos;
    @NotNull
    private String unfinishedCommand;
    private int curCursorLine;
    private int prevCursorLine;

    public HistoryKeyListener(@NotNull Project project, @NotNull EditorEx consoleEditor, @NotNull CommandHistory history) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleEditor, (String)"consoleEditor");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.project = project;
        this.consoleEditor = consoleEditor;
        this.history = history;
        this.unfinishedCommand = "";
    }

    @Override
    public void onNewEntry(@NotNull CommandHistory.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.historyPos = this.history.getSize();
        this.unfinishedCommand = "";
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.prevCursorLine = this.curCursorLine;
        switch (e.getKeyCode()) {
            case 38: {
                this.moveHistoryCursor(HistoryMove.UP);
                break;
            }
            case 40: {
                this.moveHistoryCursor(HistoryMove.DOWN);
                break;
            }
            default: {
                this.curCursorLine = this.consoleEditor.getDocument().getLineNumber(this.consoleEditor.getDocument().getTextLength());
            }
        }
    }

    private final void moveHistoryCursor(HistoryMove move) {
        if (this.history.getSize() == 0) {
            return;
        }
        if (LookupManager.getInstance((Project)this.project).getActiveLookup() != null) {
            return;
        }
        CaretModel caretModel = this.consoleEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caret = caretModel;
        DocumentEx documentEx = this.consoleEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int curOffset = caret.getOffset();
        this.curCursorLine = document.getLineNumber(curOffset);
        int totalLines = document.getLineCount();
        switch (WhenMappings.$EnumSwitchMapping$0[move.ordinal()]) {
            case 1: {
                if (this.curCursorLine != 0 || this.prevCursorLine != this.curCursorLine) {
                    return;
                }
                if (this.historyPos == this.history.getSize()) {
                    this.unfinishedCommand = document.getText();
                }
                this.historyPos = Math.max(this.historyPos - 1, 0);
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HistoryKeyListener.moveHistoryCursor$lambda$0(document, this, caret));
                break;
            }
            case 2: {
                if (this.historyPos == this.history.getSize() || this.curCursorLine != totalLines - 1 || this.curCursorLine != this.prevCursorLine) {
                    return;
                }
                this.historyPos = Math.min(this.historyPos + 1, this.history.getSize());
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HistoryKeyListener.moveHistoryCursor$lambda$1(document, this, caret));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void moveHistoryCursor$lambda$0(DocumentEx $document, HistoryKeyListener this$0, CaretModel $caret) {
        $document.setText((CharSequence)this$0.history.get(this$0.historyPos).getVisibleText());
        EditorUtil.scrollToTheEnd((Editor)((Editor)this$0.consoleEditor));
        $caret.moveToOffset($document.getTextLength());
        this$0.curCursorLine = $document.getLineNumber($document.getTextLength());
    }

    private static final void moveHistoryCursor$lambda$1(DocumentEx $document, HistoryKeyListener this$0, CaretModel $caret) {
        $document.setText((CharSequence)(this$0.historyPos == this$0.history.getSize() ? this$0.unfinishedCommand : this$0.history.get(this$0.historyPos).getVisibleText()));
        $caret.moveToOffset($document.getTextLength());
        EditorUtil.scrollToTheEnd((Editor)((Editor)this$0.consoleEditor));
        this$0.curCursorLine = $document.getLineNumber($document.getTextLength());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/HistoryKeyListener$HistoryMove;", "", "<init>", "(Ljava/lang/String;I)V", "UP", "DOWN", "intellij.rider.plugins.fsharp"})
    private static final class HistoryMove
    extends Enum<HistoryMove> {
        public static final /* enum */ HistoryMove UP = new HistoryMove();
        public static final /* enum */ HistoryMove DOWN = new HistoryMove();
        private static final /* synthetic */ HistoryMove[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HistoryMove[] values() {
            return (HistoryMove[])$VALUES.clone();
        }

        public static HistoryMove valueOf(String value) {
            return Enum.valueOf(HistoryMove.class, value);
        }

        @NotNull
        public static EnumEntries<HistoryMove> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = historyMoveArray = new HistoryMove[]{HistoryMove.UP, HistoryMove.DOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HistoryMove.values().length];
            try {
                nArray[HistoryMove.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HistoryMove.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

