/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.backend.split.run;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.ide.model.RunConfiguration;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.permissions.PermissionInteractionManager;
import com.jetbrains.rider.run.RunConfigurationHostExtensions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/backend/split/run/CodeWithMeRunConfigurationHostExtensions;", "Lcom/jetbrains/rider/run/RunConfigurationHostExtensions;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "canRunConfiguration", "", "runConfiguration", "Lcom/jetbrains/rd/ide/model/RunConfiguration;", "intellij.rider.backend.split"})
public final class CodeWithMeRunConfigurationHostExtensions
implements RunConfigurationHostExtensions {
    @NotNull
    private final Project project;

    public CodeWithMeRunConfigurationHostExtensions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public boolean canRunConfiguration(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.project);
        if (session.isOwner()) {
            return true;
        }
        RunAccessLevel runAccess = ClientPermissionManager.Companion.getInstance(session).getRunAccess();
        if (runAccess == RunAccessLevel.FullAccess) {
            return true;
        }
        AccessLevelMarker[] accessLevelMarkerArray = new AccessLevelMarker[]{RunAccessLevel.FullAccess};
        PermissionInteractionManager.Companion.notifyNotPermitted((ClientSession)session, "Executing " + runConfiguration.getName(), (AccessRequirements)AccessRequirements.Companion.of(accessLevelMarkerArray));
        return false;
    }
}

