/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.io.Util;
import org.apache.commons.vfs2.provider.ftp.MLSxLoggingEntryParser;

public class FTPExtendedClient
extends FTPClient {
    private static final Log log = LogFactory.getLog((String)"#com.jetbrains.plugins.webDeployment.ftp");

    FTPExtendedClient() {
        this.setStrictReplyParsing(false);
    }

    @Override
    public FTPFile[] mlistDir() throws IOException {
        return this.mlistDir(null);
    }

    @Override
    public FTPFile[] mlistDir(String pathname) throws IOException {
        return this.initiateMListParsing(pathname).getFiles();
    }

    @Override
    public FTPFile[] mlistDir(String pathname, FTPFileFilter filter) throws IOException {
        return this.initiateMListParsing(pathname).getFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FTPListParseEngine initiateMListParsing(String pathname) throws IOException {
        Socket socket = this._openDataConnection_(FTPCmd.MLSD, pathname);
        FTPListParseEngine engine = new FTPListParseEngine(new MLSxLoggingEntryParser(log));
        if (socket == null) {
            return engine;
        }
        try {
            engine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            Util.closeQuietly(socket);
            this.completePendingCommand();
        }
        return engine;
    }
}

