/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.states.verifiers.wormhole;

import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.verifiers.ProxyFactoryWindowOperationVerifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fj\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/wormhole/states/verifiers/wormhole/EmbeddedTargetAttachOperationVerifier;", "Lcom/jetbrains/wormhole/states/verifiers/ProxyFactoryWindowOperationVerifier;", "targetWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "(Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/Platform;)V", "getPlatform", "()Lcom/jetbrains/wormhole/interop/Platform;", "getTargetWindowId", "()Lcom/jetbrains/wormhole/interop/WindowId;", "canPerformOperation", "Lkotlin/Pair;", "", "", "Lcom/jetbrains/wormhole/states/verifiers/VerificationResult;", "windowId", "component"})
public class EmbeddedTargetAttachOperationVerifier
extends ProxyFactoryWindowOperationVerifier {
    @NotNull
    private final WindowId targetWindowId;
    @NotNull
    private final Platform platform;

    @Override
    @NotNull
    protected Pair<Boolean, String> canPerformOperation(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowId windowId2 = windowId;
        if (!this.platform.getWindowIdProvider().doesWindowExist(this.targetWindowId)) {
            return this.fail("The target window is dead now");
        }
        if (Intrinsics.areEqual((Object)this.targetWindowId, (Object)windowId2)) {
            return this.fail("The target window is the window of the component");
        }
        if (this.platform.getWindowIdProvider().getAncestors(windowId2).contains(this.targetWindowId)) {
            return this.fail("The target window is an ancestor of the component");
        }
        return super.canPerformOperation(this.targetWindowId);
    }

    @NotNull
    protected final WindowId getTargetWindowId() {
        return this.targetWindowId;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    public EmbeddedTargetAttachOperationVerifier(@NotNull WindowId targetWindowId, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        super(platform.getProxyFactory());
        this.targetWindowId = targetWindowId;
        this.platform = platform;
    }
}

