/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.states.common;

import com.jetbrains.wormhole.AssertionsKt;
import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.verifiers.WindowOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.UnknownRootEmbedOperationVerifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/wormhole/states/common/InitialState;", "Lcom/jetbrains/wormhole/states/WormholeState;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "(Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "embedOperationVerifier", "Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getEmbedOperationVerifier", "()Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "attachToRoot", "hostWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "isShowing", "", "detachFromRoot", "restorePreviousWindowState", "embedWindow", "targetWindowId", "component"})
public final class InitialState
extends WormholeState {
    @NotNull
    private final WindowOperationVerifier embedOperationVerifier;
    private final StateFactory stateFactory;

    @Override
    @NotNull
    public WindowOperationVerifier getEmbedOperationVerifier() {
        return this.embedOperationVerifier;
    }

    @Override
    @NotNull
    public WormholeState embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        return this.stateFactory.intermediateTargetState(targetWindowId);
    }

    @Override
    @NotNull
    public WormholeState attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        return this.stateFactory.intermediateRootState(hostWindowId);
    }

    @Override
    @NotNull
    public WormholeState detachFromRoot(boolean restorePreviousWindowState) {
        AssertionsKt.assert("Detaching root in initial state looks suspicious");
        return this;
    }

    public InitialState(@NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.stateFactory = stateFactory;
        this.embedOperationVerifier = new UnknownRootEmbedOperationVerifier(platform);
    }
}

