/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.windows;

import com.jetbrains.wormhole.interop.WindowId;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/wormhole/interop/windows/WindowsWindowId;", "Lcom/jetbrains/wormhole/interop/WindowId;", "string", "", "(Ljava/lang/String;)V", "hWnd", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "(Lcom/sun/jna/platform/win32/WinDef$HWND;)V", "number", "", "(Ljava/lang/Number;)V", "getHWnd", "()Lcom/sun/jna/platform/win32/WinDef$HWND;", "hexView", "getHexView", "()Ljava/lang/String;", "pointer", "", "getPointer", "()J", "equals", "", "other", "", "hashCode", "", "toString", "interop"})
public final class WindowsWindowId
extends WindowId {
    private final long pointer;
    @NotNull
    private final String hexView;
    @NotNull
    private final WinDef.HWND hWnd;

    public final long getPointer() {
        return this.pointer;
    }

    @NotNull
    public final String getHexView() {
        return this.hexView;
    }

    @NotNull
    public final WinDef.HWND getHWnd() {
        return this.hWnd;
    }

    @NotNull
    public String toString() {
        return this.hexView;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.wormhole.interop.windows.WindowsWindowId");
        }
        WindowsWindowId cfr_ignored_0 = (WindowsWindowId)object2;
        return this.pointer == ((WindowsWindowId)other).pointer;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.pointer);
    }

    public WindowsWindowId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"0x"}, (boolean)false, (int)0, (int)6, null));
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        string2 = this.hexView = string4;
        n = 16;
        boolean bl = false;
        this.pointer = Long.parseLong(string2, CharsKt.checkRadix((int)n));
        this.hWnd = new WinDef.HWND(Pointer.createConstant((long)this.pointer));
    }

    public WindowsWindowId(@NotNull WinDef.HWND hWnd) {
        Intrinsics.checkNotNullParameter((Object)hWnd, (String)"hWnd");
        String string = hWnd.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hWnd.toString()");
        this(string);
    }

    public WindowsWindowId(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        long l = this.pointer = number.longValue();
        int n = 16;
        boolean bl = false;
        String string = Long.toString(l, CharsKt.checkRadix((int)n));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Long.toString(this, checkRadix(radix))");
        this.hexView = string;
        this.hWnd = new WinDef.HWND(Pointer.createConstant((long)this.pointer));
    }
}

