/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.keyboard;

import com.jetbrains.wormhole.AssertionStatus;
import com.jetbrains.wormhole.Assertions;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.keyboard.InputRedirectionToken;
import com.jetbrains.wormhole.interop.keyboard.KeyboardInputRouter$duplicateInput$$inlined$with$1$wm$AssertionsKt$WhenMappings;
import com.jetbrains.wormhole.logging.LogLevel;
import com.jetbrains.wormhole.logging.Logger;
import com.jetbrains.wormhole.logging.LoggerKt;
import com.jetbrains.wormhole.logging.NoOperationLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH&J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/wormhole/interop/keyboard/KeyboardInputRouter;", "", "logger", "Lcom/jetbrains/wormhole/logging/Logger;", "(Lcom/jetbrains/wormhole/logging/Logger;)V", "getLogger", "()Lcom/jetbrains/wormhole/logging/Logger;", "routes", "", "Lcom/jetbrains/wormhole/interop/WindowId;", "getRoutes", "()Ljava/util/Map;", "duplicateInput", "Lcom/jetbrains/wormhole/interop/keyboard/InputRedirectionToken;", "from", "to", "onInputDuplicationRequested", "", "onRemove", "InnerInputRedirectionToken", "interop"})
public abstract class KeyboardInputRouter {
    @NotNull
    private final Map<WindowId, WindowId> routes;
    @NotNull
    private final Logger logger;

    @NotNull
    protected final Map<WindowId, WindowId> getRoutes() {
        return this.routes;
    }

    @NotNull
    public final InputRedirectionToken duplicateInput(@NotNull WindowId from, @NotNull WindowId to) {
        boolean bl;
        AssertionStatus assertionStatus;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        boolean bl2 = false;
        if (!Assertions.IsEnabled) {
            assertionStatus = AssertionStatus.Negative;
        } else {
            bl = false;
            assertionStatus = !this.routes.containsKey(from) ? AssertionStatus.Negative : AssertionStatus.Triggered;
        }
        AssertionStatus assertionStatus2 = assertionStatus;
        bl = false;
        if (Assertions.IsEnabled) {
            switch (KeyboardInputRouter$duplicateInput$$inlined$with$1$wm$AssertionsKt$WhenMappings.$EnumSwitchMapping$0[assertionStatus2.ordinal()]) {
                case 1: {
                    boolean bl3 = false;
                    String string = "Can't add router. System already has subscription for target window ";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
        }
        this.routes.put(from, to);
        LoggerKt.lazyLog(this.logger, LogLevel.DEBUG, (Function0<String>)((Function0)new Function0<String>(from, to){
            final /* synthetic */ WindowId $from;
            final /* synthetic */ WindowId $to;

            @NotNull
            public final String invoke() {
                return "New keyboard router set " + this.$from + " -> " + this.$to;
            }
            {
                this.$from = windowId;
                this.$to = windowId2;
                super(0);
            }
        }));
        this.onInputDuplicationRequested(from, to);
        return new InnerInputRedirectionToken(from, to);
    }

    public abstract void onInputDuplicationRequested(@NotNull WindowId var1, @NotNull WindowId var2);

    public abstract void onRemove(@NotNull WindowId var1, @NotNull WindowId var2);

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    public KeyboardInputRouter(@NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        boolean bl = false;
        this.routes = new LinkedHashMap();
    }

    public /* synthetic */ KeyboardInputRouter(Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger2 = NoOperationLogger.INSTANCE;
        }
        this(logger2);
    }

    public KeyboardInputRouter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/wormhole/interop/keyboard/KeyboardInputRouter$InnerInputRedirectionToken;", "Lcom/jetbrains/wormhole/interop/keyboard/InputRedirectionToken;", "from", "Lcom/jetbrains/wormhole/interop/WindowId;", "to", "(Lcom/jetbrains/wormhole/interop/keyboard/KeyboardInputRouter;Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/WindowId;)V", "getFrom", "()Lcom/jetbrains/wormhole/interop/WindowId;", "getTo", "remove", "", "interop"})
    private final class InnerInputRedirectionToken
    implements InputRedirectionToken {
        @NotNull
        private final WindowId from;
        @NotNull
        private final WindowId to;

        @Override
        public void remove() {
            KeyboardInputRouter.this.getRoutes().remove(this.from);
            KeyboardInputRouter.this.onRemove(this.from, this.to);
        }

        @NotNull
        public final WindowId getFrom() {
            return this.from;
        }

        @NotNull
        public final WindowId getTo() {
            return this.to;
        }

        public InnerInputRedirectionToken(@NotNull WindowId from, WindowId to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.from = from;
            this.to = to;
        }
    }
}

