/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.awt.states;

import com.jetbrains.wormhole.interop.NativeWindowProxy;
import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.ReadOnlyNativeWindowProxy;
import com.jetbrains.wormhole.interop.WindowChain;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.verifiers.WindowOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.AttachOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.EmbedOperationVerifier;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020 H\u0016J\u0018\u0010#\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010$\u001a\u00020\u0001H\u0016J\b\u0010%\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0001H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/jetbrains/wormhole/awt/states/FinalState;", "Lcom/jetbrains/wormhole/states/WormholeState;", "targetWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "hostWindowId", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "(Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "chain", "Lcom/jetbrains/wormhole/interop/WindowChain;", "(Lcom/jetbrains/wormhole/interop/WindowChain;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "attachOperationVerifier", "Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getAttachOperationVerifier", "()Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getChain", "()Lcom/jetbrains/wormhole/interop/WindowChain;", "embedOperationVerifier", "getEmbedOperationVerifier", "getPlatform", "()Lcom/jetbrains/wormhole/interop/Platform;", "getStateFactory", "()Lcom/jetbrains/wormhole/states/StateFactory;", "arrange", "", "componentRect", "Ljava/awt/Rectangle;", "visibleRect", "attachToRoot", "isShowing", "", "detachFromRoot", "restorePreviousWindowState", "embedWindow", "hide", "onTargetDead", "unembedWindow", "component"})
public class FinalState
extends WormholeState {
    @NotNull
    private final WindowOperationVerifier embedOperationVerifier;
    @NotNull
    private final WindowOperationVerifier attachOperationVerifier;
    @NotNull
    private final WindowChain chain;
    @NotNull
    private final StateFactory stateFactory;
    @NotNull
    private final Platform platform;

    @Override
    @NotNull
    public final WindowOperationVerifier getEmbedOperationVerifier() {
        return this.embedOperationVerifier;
    }

    @Override
    @NotNull
    public final WindowOperationVerifier getAttachOperationVerifier() {
        return this.attachOperationVerifier;
    }

    @NotNull
    public final WindowChain getChain() {
        return this.chain;
    }

    @NotNull
    protected final StateFactory getStateFactory() {
        return this.stateFactory;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    @Override
    @NotNull
    public WormholeState embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        this.chain.detach();
        return this.stateFactory.finalState(targetWindowId, this.chain.getHostWindow().getId());
    }

    @Override
    @NotNull
    public WormholeState unembedWindow() {
        this.chain.detach();
        return this.stateFactory.intermediateRootState(this.chain.getHostWindow().getId());
    }

    @Override
    @NotNull
    public WormholeState attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        throw (Throwable)new IllegalStateException("Failed to attach new root with '" + hostWindowId + "' id. " + "Attaching new root in " + Reflection.getOrCreateKotlinClass(com.jetbrains.wormhole.swing.states.FinalState.class).getSimpleName() + " state is not allowed. " + "Needs to detach current root ('" + this.chain.getHostWindow().getId() + "') first.");
    }

    @Override
    @NotNull
    public WormholeState detachFromRoot(boolean restorePreviousWindowState) {
        WormholeState wormholeState;
        if (restorePreviousWindowState) {
            wormholeState = this.stateFactory.intermediateHiddenTargetState(this.chain);
        } else {
            this.chain.detach();
            wormholeState = this.stateFactory.intermediateTargetState(this.chain.getTargetWindow().getId());
        }
        return wormholeState;
    }

    @Override
    @NotNull
    public WormholeState hide() {
        return this.stateFactory.hiddenState(this.chain);
    }

    @Override
    @NotNull
    public WormholeState onTargetDead() {
        this.chain.detach();
        return this.stateFactory.deadTargetState(this.chain.getHostWindow().getId());
    }

    @Override
    public void arrange(@NotNull Rectangle componentRect, @NotNull Rectangle visibleRect) {
        Intrinsics.checkNotNullParameter((Object)componentRect, (String)"componentRect");
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        this.chain.getTargetWindow().arrange(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
    }

    public FinalState(@NotNull WindowId targetWindowId, @NotNull WindowId hostWindowId, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.stateFactory = stateFactory;
        this.platform = platform;
        ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy = platform.getProxyFactory().find(hostWindowId);
        NativeWindowProxy nativeWindowProxy = platform.getProxyFactory().getProxyForExistingWindow(targetWindowId);
        boolean bl = false;
        boolean bl2 = false;
        NativeWindowProxy nativeWindowProxy2 = nativeWindowProxy;
        boolean bl3 = false;
        nativeWindowProxy2.bind(readOnlyNativeWindowProxy);
        NativeWindowProxy nativeWindowProxy3 = nativeWindowProxy;
        this.chain = new WindowChain(readOnlyNativeWindowProxy, nativeWindowProxy3);
        this.embedOperationVerifier = new EmbedOperationVerifier(hostWindowId, platform);
        this.attachOperationVerifier = new AttachOperationVerifier(targetWindowId, platform);
    }

    public FinalState(@NotNull WindowChain chain, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.stateFactory = stateFactory;
        this.chain = chain;
        this.platform = platform;
        this.embedOperationVerifier = new EmbedOperationVerifier(chain.getHostWindow().getId(), platform);
        this.attachOperationVerifier = new AttachOperationVerifier(chain.getTargetWindow().getId(), platform);
    }
}

