/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.awt;

import com.jetbrains.wormhole.AssertionStatus;
import com.jetbrains.wormhole.Assertions;
import com.jetbrains.wormhole.awt.Wormhole;
import com.jetbrains.wormhole.awt.Wormhole$addNotify$$inlined$with$1$wm$AssertionsKt$WhenMappings;
import com.jetbrains.wormhole.awt.WormholeStateFactory;
import com.jetbrains.wormhole.events.Event;
import com.jetbrains.wormhole.events.EventBus;
import com.jetbrains.wormhole.events.EventBusSubscription;
import com.jetbrains.wormhole.events.MainThreadEventBus;
import com.jetbrains.wormhole.events.WormholeEvent;
import com.jetbrains.wormhole.events.WormholeEventArgument;
import com.jetbrains.wormhole.interop.NativeWindowIdProvider;
import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.PlatformProvider;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.WindowIdNotFoundException;
import com.jetbrains.wormhole.interop.events.WindowEvent;
import com.jetbrains.wormhole.interop.events.WindowEventArgument;
import com.jetbrains.wormhole.logging.LogLevel;
import com.jetbrains.wormhole.logging.Logger;
import com.jetbrains.wormhole.logging.LoggerKt;
import com.jetbrains.wormhole.logging.NoOperationLogger;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.WormholeStateMachine;
import com.jetbrains.wormhole.swing.scheduler.SwingMainThreadScheduler;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.peer.ComponentPeer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0019\u001a\u00020\u0016\"\b\b\u0000\u0010\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020 0\u001fJ\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020$J\b\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u00020 2\u0006\u0010)\u001a\u00020$J\b\u0010-\u001a\u00020 H\u0002J\u0006\u0010.\u001a\u00020 J\b\u0010/\u001a\u00020 H\u0016J(\u00100\u001a\u00020 2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u0002022\u0006\u00105\u001a\u000202H\u0016J\u0012\u00106\u001a\u00020 *\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/wormhole/awt/Wormhole;", "Ljava/awt/Canvas;", "platformProvider", "Lcom/jetbrains/wormhole/interop/PlatformProvider;", "loggerForComponent", "Lcom/jetbrains/wormhole/logging/Logger;", "(Lcom/jetbrains/wormhole/interop/PlatformProvider;Lcom/jetbrains/wormhole/logging/Logger;)V", "currentState", "Lcom/jetbrains/wormhole/states/WormholeState;", "G", "()Lcom/jetbrains/wormhole/states/WormholeState;", "logger", "mainThreadScheduler", "Lcom/jetbrains/wormhole/swing/scheduler/SwingMainThreadScheduler;", "outerEventBus", "Lcom/jetbrains/wormhole/events/MainThreadEventBus;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateMachine", "Lcom/jetbrains/wormhole/states/WormholeStateMachine;", "subscriptions", "", "Lcom/jetbrains/wormhole/events/EventBusSubscription;", "windowEventBus", "Lcom/jetbrains/wormhole/events/EventBus;", "addEventListener", "TSubscribingEventArgs", "Lcom/jetbrains/wormhole/events/WormholeEventArgument;", "wormholeEvent", "Lcom/jetbrains/wormhole/events/WormholeEvent;", "handler", "Lkotlin/Function1;", "", "addNotify", "b", "calculateClosestWindowsId", "Lcom/jetbrains/wormhole/interop/WindowId;", "component", "Ljava/awt/Component;", "canEmbedWindow", "", "targetWindowId", "G", "Ljava/awt/Rectangle;", "embed", "G", "release", "removeNotify", "reshape", "x", "", "y", "width", "height", "G"})
public final class Wormhole
extends Canvas {
    private final Logger logger;
    private final WormholeStateMachine stateMachine;
    private final Platform platform;
    private final SwingMainThreadScheduler mainThreadScheduler;
    private final EventBus windowEventBus;
    private final MainThreadEventBus outerEventBus;
    private final List<EventBusSubscription> subscriptions;

    private final WormholeState G() {
        return (WormholeState)this.stateMachine.getCurrentState();
    }

    public final boolean canEmbedWindow(@NotNull WindowId targetWindowId) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        return ((WormholeState)this.stateMachine.getCurrentState()).getEmbedOperationVerifier().isAllowedForWindow(targetWindowId);
    }

    public final void embed(@NotNull WindowId targetWindowId) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        this.G().getEmbedOperationVerifier().ensureIsAllowedForWindow(targetWindowId);
        this.stateMachine.embedWindow(targetWindowId, this.isShowing());
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ Wormhole this$0;

            public final void run() {
                Wormhole.access$arrange(this.this$0);
            }
            {
                this.this$0 = wormhole;
            }
        });
        this.subscriptions.add(this.windowEventBus.subscribe((Event)WindowEvent.Companion.getWindowDestroyed(), (Function1)new Function1<WindowEventArgument.WindowDestroyedArgument, Unit>(this, targetWindowId){
            final /* synthetic */ Wormhole this$0;
            final /* synthetic */ WindowId $targetWindowId;

            public final void invoke(@NotNull WindowEventArgument.WindowDestroyedArgument it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getId(), (Object)this.$targetWindowId)) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ embed.2 this$0;

                        public final void run() {
                            Wormhole.access$onTargetWindowDestroy(this.this$0.this$0);
                            Wormhole.access$unsubscribe(this.this$0.this$0, Wormhole.access$getSubscriptions$p(this.this$0.this$0));
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = wormhole;
                this.$targetWindowId = windowId;
                super(1);
            }
        }));
    }

    public final void release() {
        this.G(this.subscriptions);
        this.stateMachine.unembedWindow();
    }

    @NotNull
    public final <TSubscribingEventArgs extends WormholeEventArgument> EventBusSubscription addEventListener(@NotNull WormholeEvent<? super TSubscribingEventArgs> wormholeEvent, @NotNull Function1<? super TSubscribingEventArgs, Unit> handler2) {
        Intrinsics.checkNotNullParameter(wormholeEvent, (String)"wormholeEvent");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        return this.outerEventBus.subscribe((Event)wormholeEvent, handler2);
    }

    private final void G() {
        this.stateMachine.onTargetDead();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.b();
    }

    @Override
    public void addNotify() {
        block8: {
            super.addNotify();
            try {
                Object t = AWTAccessor.getComponentAccessor().getPeer(this);
                NativeWindowIdProvider nativeWindowIdProvider = this.platform.getWindowIdProvider();
                Object t2 = t;
                Intrinsics.checkNotNullExpressionValue(t2, (String)"firstHeavyweightPeer");
                WindowId windowId = nativeWindowIdProvider.getWindowId((ComponentPeer)t2);
                if (this.G().getAttachOperationVerifier().isAllowedForWindow(windowId)) {
                    this.stateMachine.attachToRoot(windowId, this.isShowing());
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ Wormhole this$0;

                        public final void run() {
                            Wormhole.access$arrange(this.this$0);
                        }
                        {
                            this.this$0 = wormhole;
                        }
                    });
                }
            }
            catch (WindowIdNotFoundException windowIdNotFoundException) {
                boolean bl;
                AssertionStatus assertionStatus;
                Function0 function0 = (Function0)new Function0<String>(windowIdNotFoundException){
                    final /* synthetic */ WindowIdNotFoundException $e;

                    @NotNull
                    public final String invoke() {
                        return "Failed to attach to the root window. Can not obtain native window ID for the root window. Exception: " + this.$e;
                    }
                    {
                        this.$e = windowIdNotFoundException;
                        super(0);
                    }
                };
                LoggerKt.lazyLog(this.logger, LogLevel.ERROR, (Function0<String>)function0);
                boolean bl2 = false;
                if (!Assertions.IsEnabled) {
                    assertionStatus = AssertionStatus.Negative;
                } else {
                    bl = false;
                    assertionStatus = false ? AssertionStatus.Negative : AssertionStatus.Triggered;
                }
                AssertionStatus assertionStatus2 = assertionStatus;
                bl = false;
                if (!Assertions.IsEnabled) break block8;
                switch (Wormhole$addNotify$$inlined$with$1$wm$AssertionsKt$WhenMappings.$EnumSwitchMapping$0[assertionStatus2.ordinal()]) {
                    case 1: {
                        String string = (String)function0.invoke();
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                }
            }
        }
    }

    @Override
    public void removeNotify() {
        this.stateMachine.detachFromRoot(false);
        super.removeNotify();
    }

    @Nullable
    public final WindowId calculateClosestWindowsId(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Object t = AWTAccessor.getComponentAccessor().getPeer(component2);
        NativeWindowIdProvider nativeWindowIdProvider = this.platform.getWindowIdProvider();
        Object t2 = t;
        Intrinsics.checkNotNullExpressionValue(t2, (String)"peer");
        return nativeWindowIdProvider.getWindowId((ComponentPeer)t2);
    }

    private final void b() {
        Rectangle rectangle = this.G();
        this.G().arrange(rectangle, rectangle);
    }

    private final Rectangle G() {
        Rectangle rectangle = new Rectangle();
        computeVisibleRect.1 var2_2 = computeVisibleRect.1.INSTANCE;
        var2_2.invoke(this, rectangle);
        return rectangle;
    }

    private final void G(List<EventBusSubscription> list2) {
        Iterable iterable = list2;
        boolean bl = false;
        for (Object t : iterable) {
            EventBusSubscription eventBusSubscription = (EventBusSubscription)t;
            boolean bl2 = false;
            eventBusSubscription.unsubscribe();
        }
        list2.clear();
    }

    @JvmOverloads
    public Wormhole(@NotNull PlatformProvider platformProvider, @NotNull Logger loggerForComponent) {
        Intrinsics.checkNotNullParameter((Object)platformProvider, (String)"platformProvider");
        Intrinsics.checkNotNullParameter((Object)loggerForComponent, (String)"loggerForComponent");
        this.logger = loggerForComponent;
        this.mainThreadScheduler = SwingMainThreadScheduler.INSTANCE;
        this.windowEventBus = new EventBus();
        this.outerEventBus = new MainThreadEventBus(this.mainThreadScheduler);
        boolean bl = false;
        this.subscriptions = new ArrayList();
        this.platform = platformProvider.getPlatform(this.windowEventBus, SwingMainThreadScheduler.INSTANCE);
        this.stateMachine = new WormholeStateMachine(new WormholeStateFactory(this.platform), this.outerEventBus);
    }

    public /* synthetic */ Wormhole(PlatformProvider platformProvider, Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger2 = NoOperationLogger.INSTANCE;
        }
        this(platformProvider, logger2);
    }

    @JvmOverloads
    public Wormhole(@NotNull PlatformProvider platformProvider) {
        this(platformProvider, null, 2, null);
    }

    public static final /* synthetic */ void access$arrange(Wormhole $this) {
        $this.b();
    }

    public static final /* synthetic */ void access$onTargetWindowDestroy(Wormhole $this) {
        $this.G();
    }

    public static final /* synthetic */ void access$unsubscribe(Wormhole $this, List $this$access_u24unsubscribe) {
        $this.G($this$access_u24unsubscribe);
    }

    public static final /* synthetic */ List access$getSubscriptions$p(Wormhole $this) {
        return $this.subscriptions;
    }
}

